/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.store;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.mongo.adapter.ScopeAdapter;
import org.keycloak.authorization.mongo.entities.ScopeEntity;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MongoScopeStore
implements ScopeStore {
    private final MongoStoreInvocationContext invocationContext;
    private final AuthorizationProvider authorizationProvider;

    public MongoScopeStore(MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        this.invocationContext = invocationContext;
        this.authorizationProvider = authorizationProvider;
    }

    public Scope create(String name, ResourceServer resourceServer) {
        ScopeEntity entity = new ScopeEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        this.getMongoStore().insertEntity(entity, this.getInvocationContext());
        return new ScopeAdapter(entity, this.getInvocationContext(), this.authorizationProvider);
    }

    public void delete(String id) {
        this.getMongoStore().removeEntity(ScopeEntity.class, id, this.getInvocationContext());
    }

    public Scope findById(String id, String resourceServerId) {
        ScopeEntity entity = this.getMongoStore().loadEntity(ScopeEntity.class, id, this.getInvocationContext());
        if (entity == null) {
            return null;
        }
        return new ScopeAdapter(entity, this.getInvocationContext(), this.authorizationProvider);
    }

    public Scope findByName(String name, String resourceServerId) {
        DBObject query = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId).and("name").is((Object)name).get();
        return this.getMongoStore().loadEntities(ScopeEntity.class, query, this.getInvocationContext()).stream().map(scope -> this.findById(scope.getId(), scope.getResourceServerId())).findFirst().orElse(null);
    }

    public List<Scope> findByResourceServer(String resourceServerId) {
        DBObject query = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId).get();
        return this.getMongoStore().loadEntities(ScopeEntity.class, query, this.getInvocationContext()).stream().map(scope -> this.findById(scope.getId(), scope.getResourceServerId())).collect(Collectors.toList());
    }

    public List<Scope> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        QueryBuilder queryBuilder = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId);
        attributes.forEach((name, value) -> queryBuilder.and(name).regex(Pattern.compile(".*" + value[0] + ".*", 2)));
        BasicDBObject sort = new BasicDBObject("name", (Object)1);
        return this.getMongoStore().loadEntities(ScopeEntity.class, queryBuilder.get(), (DBObject)sort, firstResult, maxResult, this.invocationContext).stream().map(scope -> this.findById(scope.getId(), scope.getResourceServerId())).collect(Collectors.toList());
    }

    private MongoStoreInvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    private MongoStore getMongoStore() {
        return this.getInvocationContext().getMongoStore();
    }
}

