/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.adapter;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.mongo.entities.PolicyEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class PolicyAdapter
extends AbstractMongoAdapter<PolicyEntity>
implements Policy {
    private final PolicyEntity entity;
    private final AuthorizationProvider authorizationProvider;

    public PolicyAdapter(PolicyEntity entity, MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        super(invocationContext);
        this.entity = entity;
        this.authorizationProvider = authorizationProvider;
    }

    @Override
    protected PolicyEntity getMongoEntity() {
        return this.entity;
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getType() {
        return this.getMongoEntity().getType();
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.getMongoEntity().getDecisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.getMongoEntity().setDecisionStrategy(decisionStrategy);
        this.updateMongoEntity();
    }

    public Logic getLogic() {
        return this.getMongoEntity().getLogic();
    }

    public void setLogic(Logic logic) {
        this.getMongoEntity().setLogic(logic);
        this.updateMongoEntity();
    }

    public Map<String, String> getConfig() {
        return this.getMongoEntity().getConfig();
    }

    public void setConfig(Map<String, String> config) {
        this.getMongoEntity().setConfig(config);
        this.updateMongoEntity();
    }

    public String getName() {
        return this.getMongoEntity().getName();
    }

    public void setName(String name) {
        this.getMongoEntity().setName(name);
        this.updateMongoEntity();
    }

    public String getDescription() {
        return this.getMongoEntity().getDescription();
    }

    public void setDescription(String description) {
        this.getMongoEntity().setDescription(description);
        this.updateMongoEntity();
    }

    public ResourceServer getResourceServer() {
        return this.authorizationProvider.getStoreFactory().getResourceServerStore().findById(this.getMongoEntity().getResourceServerId());
    }

    public Set<Policy> getAssociatedPolicies() {
        return this.getMongoEntity().getAssociatedPolicies().stream().map(id -> this.authorizationProvider.getStoreFactory().getPolicyStore().findById(id, this.getMongoEntity().getResourceServerId())).collect(Collectors.toSet());
    }

    public Set<Resource> getResources() {
        return this.getMongoEntity().getResources().stream().map(id -> this.authorizationProvider.getStoreFactory().getResourceStore().findById(id, this.getMongoEntity().getResourceServerId())).collect(Collectors.toSet());
    }

    public Set<Scope> getScopes() {
        return this.getMongoEntity().getScopes().stream().map(id -> this.authorizationProvider.getStoreFactory().getScopeStore().findById(id, this.getMongoEntity().getResourceServerId())).collect(Collectors.toSet());
    }

    public void addScope(Scope scope) {
        this.getMongoEntity().addScope(scope.getId());
        this.updateMongoEntity();
    }

    public void removeScope(Scope scope) {
        this.getMongoEntity().removeScope(scope.getId());
        this.updateMongoEntity();
    }

    public void addAssociatedPolicy(Policy associatedPolicy) {
        this.getMongoEntity().addAssociatedPolicy(associatedPolicy.getId());
        this.updateMongoEntity();
    }

    public void removeAssociatedPolicy(Policy associatedPolicy) {
        this.getMongoEntity().removeAssociatedPolicy(associatedPolicy.getId());
        this.updateMongoEntity();
    }

    public void addResource(Resource resource) {
        this.getMongoEntity().addResource(resource.getId());
        this.updateMongoEntity();
    }

    public void removeResource(Resource resource) {
        this.getMongoEntity().removeResource(resource.getId());
        this.updateMongoEntity();
    }
}

