/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.adapter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.mongo.entities.ResourceEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;

public class ResourceAdapter
extends AbstractMongoAdapter<ResourceEntity>
implements Resource {
    private final ResourceEntity entity;
    private final AuthorizationProvider authorizationProvider;

    public ResourceAdapter(ResourceEntity entity, MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        super(invocationContext);
        this.entity = entity;
        this.authorizationProvider = authorizationProvider;
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getName() {
        return this.getMongoEntity().getName();
    }

    public void setName(String name) {
        this.getMongoEntity().setName(name);
        this.updateMongoEntity();
    }

    public String getUri() {
        return this.getMongoEntity().getUri();
    }

    public void setUri(String uri) {
        this.getMongoEntity().setUri(uri);
        this.updateMongoEntity();
    }

    public String getType() {
        return this.getMongoEntity().getType();
    }

    public void setType(String type) {
        this.getMongoEntity().setType(type);
        this.updateMongoEntity();
    }

    public List<Scope> getScopes() {
        return this.getMongoEntity().getScopes().stream().map(id -> this.authorizationProvider.getStoreFactory().getScopeStore().findById(id, this.getResourceServer().getId())).collect(Collectors.toList());
    }

    public String getIconUri() {
        return this.getMongoEntity().getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.getMongoEntity().setIconUri(iconUri);
        this.updateMongoEntity();
    }

    public ResourceServer getResourceServer() {
        return this.authorizationProvider.getStoreFactory().getResourceServerStore().findById(this.getMongoEntity().getResourceServerId());
    }

    public String getOwner() {
        return this.getMongoEntity().getOwner();
    }

    public void updateScopes(Set<Scope> scopes) {
        this.getMongoEntity().updateScopes(scopes);
        this.updateMongoEntity();
    }

    @Override
    protected ResourceEntity getMongoEntity() {
        return this.entity;
    }
}

