/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.KeycloakModelUtils;

public class UserAdapter
extends AbstractMongoAdapter<MongoUserEntity>
implements UserModel {
    private final MongoUserEntity user;
    private final RealmModel realm;
    private final KeycloakSession session;

    public UserAdapter(KeycloakSession session, RealmModel realm, MongoUserEntity userEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.user = userEntity;
        this.realm = realm;
        this.session = session;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        username = KeycloakModelUtils.toLowerCaseSafe((String)username);
        this.user.setUsername(username);
        this.updateUser();
    }

    public Long getCreatedTimestamp() {
        return this.user.getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.user.setCreatedTimestamp(timestamp);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
        this.updateUser();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
        this.updateUser();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
        this.updateUser();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        email = KeycloakModelUtils.toLowerCaseSafe((String)email);
        this.user.setEmail(email);
        this.updateUser();
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
        this.updateUser();
    }

    public void setSingleAttribute(String name, String value) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap<String, List<String>>());
        }
        ArrayList<String> attrValues = new ArrayList<String>();
        attrValues.add(value);
        this.user.getAttributes().put(name, attrValues);
        this.updateUser();
    }

    public void setAttribute(String name, List<String> values) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap<String, List<String>>());
        }
        this.user.getAttributes().put(name, values);
        this.updateUser();
    }

    public void removeAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return;
        }
        this.user.getAttributes().remove(name);
        this.updateUser();
    }

    public String getFirstAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return null;
        }
        List<String> attrValues = this.user.getAttributes().get(name);
        return attrValues == null || attrValues.isEmpty() ? null : attrValues.get(0);
    }

    public List<String> getAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return Collections.emptyList();
        }
        List<String> attrValues = this.user.getAttributes().get(name);
        return attrValues == null ? Collections.emptyList() : Collections.unmodifiableList(attrValues);
    }

    public Map<String, List<String>> getAttributes() {
        return this.user.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.user.getAttributes());
    }

    public MongoUserEntity getUser() {
        return this.user;
    }

    public Set<String> getRequiredActions() {
        HashSet<String> result = new HashSet<String>();
        if (this.user.getRequiredActions() != null) {
            result.addAll(this.user.getRequiredActions());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    public void addRequiredAction(String actionName) {
        this.getMongoStore().pushItemToList(this.user, "requiredActions", actionName, true, this.invocationContext);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    public void removeRequiredAction(String actionName) {
        this.getMongoStore().pullItemFromList(this.user, "requiredActions", actionName, this.invocationContext);
    }

    protected void updateUser() {
        super.updateMongoEntity();
    }

    @Override
    public MongoUserEntity getMongoEntity() {
        return this.user;
    }

    public Set<GroupModel> getGroups() {
        if (this.user.getGroupIds() == null || this.user.getGroupIds().size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<GroupModel> groups = new HashSet<GroupModel>();
        for (String id : this.user.getGroupIds()) {
            groups.add(this.realm.getGroupById(id));
        }
        return groups;
    }

    public void joinGroup(GroupModel group) {
        this.getMongoStore().pushItemToList(this.getUser(), "groupIds", group.getId(), true, this.invocationContext);
    }

    public void leaveGroup(GroupModel group) {
        if (this.user == null || group == null) {
            return;
        }
        this.getMongoStore().pullItemFromList(this.getUser(), "groupIds", group.getId(), this.invocationContext);
    }

    public boolean isMemberOf(GroupModel group) {
        if (this.user.getGroupIds().contains(group.getId())) {
            return true;
        }
        Set<GroupModel> groups = this.getGroups();
        return KeycloakModelUtils.isMember(groups, (GroupModel)group);
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return KeycloakModelUtils.hasRole(roles, (RoleModel)role) || KeycloakModelUtils.hasRoleFromGroup(this.getGroups(), (RoleModel)role, (boolean)true);
    }

    public void grantRole(RoleModel role) {
        this.getMongoStore().pushItemToList(this.getUser(), "roleIds", role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings() {
        List<RoleModel> roles = MongoModelUtils.getAllRolesOfUser(this.realm, this);
        return new HashSet<RoleModel>(roles);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> allRoles = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            if (!(role.getContainer() instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        this.getMongoStore().pullItemFromList(this.getUser(), "roleIds", role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleModel> roles = MongoModelUtils.getAllRolesOfUser(this.realm, this);
        for (RoleModel role : roles) {
            if (!app.equals(role.getContainer())) continue;
            result.add(role);
        }
        return result;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
        this.updateUser();
    }

    public String getServiceAccountClientLink() {
        return this.user.getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.user.setServiceAccountClientLink(clientInternalId);
        this.updateUser();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

