/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.store;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.mongo.adapter.ResourceServerAdapter;
import org.keycloak.authorization.mongo.entities.ResourceServerEntity;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MongoResourceServerStore
implements ResourceServerStore {
    private final MongoStoreInvocationContext invocationContext;
    private final AuthorizationProvider authorizationProvider;

    public MongoResourceServerStore(MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        this.invocationContext = invocationContext;
        this.authorizationProvider = authorizationProvider;
    }

    public ResourceServer create(String clientId) {
        ResourceServerEntity entity = new ResourceServerEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setClientId(clientId);
        this.getMongoStore().insertEntity(entity, this.getInvocationContext());
        return new ResourceServerAdapter(entity, this.getInvocationContext());
    }

    public void delete(String id) {
        this.getMongoStore().removeEntity(ResourceServerEntity.class, id, this.getInvocationContext());
    }

    public ResourceServer findById(String id) {
        ResourceServerEntity entity = this.getMongoStore().loadEntity(ResourceServerEntity.class, id, this.getInvocationContext());
        if (entity == null) {
            return null;
        }
        return new ResourceServerAdapter(entity, this.getInvocationContext());
    }

    public ResourceServer findByClient(String clientId) {
        DBObject query = new QueryBuilder().and("clientId").is((Object)clientId).get();
        return this.getMongoStore().loadEntities(ResourceServerEntity.class, query, this.getInvocationContext()).stream().map(resourceServer -> this.findById(resourceServer.getId())).findFirst().orElse(null);
    }

    private MongoStoreInvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    private MongoStore getMongoStore() {
        return this.getInvocationContext().getMongoStore();
    }
}

