/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
extends AbstractMongoAdapter<MongoRoleEntity>
implements RoleModel {
    private final MongoRoleEntity role;
    private RoleContainerModel roleContainer;
    private RealmModel realm;
    private KeycloakSession session;

    public RoleAdapter(KeycloakSession session, RealmModel realm, MongoRoleEntity roleEntity, MongoStoreInvocationContext invContext) {
        this(session, realm, roleEntity, null, invContext);
    }

    public RoleAdapter(KeycloakSession session, RealmModel realm, MongoRoleEntity roleEntity, RoleContainerModel roleContainer, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.role = roleEntity;
        this.roleContainer = roleContainer;
        this.realm = realm;
        this.session = session;
    }

    public String getId() {
        return this.role.getId();
    }

    public String getName() {
        return this.role.getName();
    }

    public void setName(String name) {
        this.role.setName(name);
        this.updateRole();
    }

    public String getDescription() {
        return this.role.getDescription();
    }

    public void setDescription(String description) {
        this.role.setDescription(description);
        this.updateRole();
    }

    public boolean isScopeParamRequired() {
        return this.role.isScopeParamRequired();
    }

    public void setScopeParamRequired(boolean scopeParamRequired) {
        this.role.setScopeParamRequired(scopeParamRequired);
        this.updateRole();
    }

    public boolean isComposite() {
        return this.role.getCompositeRoleIds() != null && this.role.getCompositeRoleIds().size() > 0;
    }

    protected void updateRole() {
        super.updateMongoEntity();
    }

    public void addCompositeRole(RoleModel childRole) {
        this.getMongoStore().pushItemToList(this.role, "compositeRoleIds", childRole.getId(), true, this.invocationContext);
    }

    public void removeCompositeRole(RoleModel childRole) {
        this.getMongoStore().pullItemFromList(this.role, "compositeRoleIds", childRole.getId(), this.invocationContext);
    }

    public Set<RoleModel> getComposites() {
        if (this.role.getCompositeRoleIds() == null || this.role.getCompositeRoleIds().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        DBObject query = new QueryBuilder().and("_id").in((Object)this.role.getCompositeRoleIds()).get();
        List<MongoRoleEntity> childRoles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (MongoRoleEntity childRole : childRoles) {
            set.add(new RoleAdapter(this.session, this.realm, childRole, this.invocationContext));
        }
        return set;
    }

    public boolean isClientRole() {
        return this.role.getClientId() != null;
    }

    public String getContainerId() {
        if (this.isClientRole()) {
            return this.role.getClientId();
        }
        return this.role.getRealmId();
    }

    public RoleContainerModel getContainer() {
        if (this.roleContainer == null) {
            if (this.role.getRealmId() != null) {
                MongoRealmEntity realm = this.getMongoStore().loadEntity(MongoRealmEntity.class, this.role.getRealmId(), this.invocationContext);
                if (realm == null) {
                    throw new IllegalStateException("Realm with id: " + this.role.getRealmId() + " doesn't exists");
                }
                this.roleContainer = new RealmAdapter(this.session, realm, this.invocationContext);
            } else if (this.role.getClientId() != null) {
                MongoClientEntity appEntity = this.getMongoStore().loadEntity(MongoClientEntity.class, this.role.getClientId(), this.invocationContext);
                if (appEntity == null) {
                    throw new IllegalStateException("Application with id: " + this.role.getClientId() + " doesn't exists");
                }
                this.roleContainer = new ClientAdapter(this.session, this.realm, appEntity, this.invocationContext);
            } else {
                throw new IllegalStateException("Both realmId and clientId are null for role: " + this);
            }
        }
        return this.roleContainer;
    }

    public boolean hasRole(RoleModel role) {
        if (this.equals(role)) {
            return true;
        }
        if (!this.isComposite()) {
            return false;
        }
        HashSet visited = new HashSet();
        return KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, visited);
    }

    public MongoRoleEntity getRole() {
        return this.role;
    }

    @Override
    public MongoRoleEntity getMongoEntity() {
        return this.role;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RoleModel)) {
            return false;
        }
        RoleModel that = (RoleModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

