/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.mongo.DefaultMongoConnectionProvider;
import org.keycloak.connections.mongo.MongoConnectionProvider;
import org.keycloak.connections.mongo.MongoConnectionProviderFactory;
import org.keycloak.connections.mongo.MongoKeycloakTransaction;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.impl.MongoStoreImpl;
import org.keycloak.connections.mongo.impl.context.TransactionMongoStoreInvocationContext;
import org.keycloak.connections.mongo.updater.MongoUpdaterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class DefaultMongoConnectionFactoryProvider
implements MongoConnectionProviderFactory,
ServerInfoAwareProviderFactory {
    private String[] entities = new String[]{"org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity", "org.keycloak.models.mongo.keycloak.entities.MongoUserEntity", "org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity", "org.keycloak.models.mongo.keycloak.entities.MongoGroupEntity", "org.keycloak.models.mongo.keycloak.entities.MongoClientEntity", "org.keycloak.models.mongo.keycloak.entities.MongoClientTemplateEntity", "org.keycloak.models.mongo.keycloak.entities.MongoUserConsentEntity", "org.keycloak.models.mongo.keycloak.entities.MongoMigrationModelEntity", "org.keycloak.models.mongo.keycloak.entities.MongoOnlineUserSessionEntity", "org.keycloak.models.mongo.keycloak.entities.MongoOfflineUserSessionEntity", "org.keycloak.models.entities.IdentityProviderEntity", "org.keycloak.models.entities.ClientIdentityProviderMappingEntity", "org.keycloak.models.entities.RequiredCredentialEntity", "org.keycloak.models.entities.CredentialEntity", "org.keycloak.models.entities.FederatedIdentityEntity", "org.keycloak.models.entities.UserFederationProviderEntity", "org.keycloak.models.entities.UserFederationMapperEntity", "org.keycloak.models.entities.ProtocolMapperEntity", "org.keycloak.models.entities.IdentityProviderMapperEntity", "org.keycloak.models.entities.AuthenticationExecutionEntity", "org.keycloak.models.entities.AuthenticationFlowEntity", "org.keycloak.models.entities.AuthenticatorConfigEntity", "org.keycloak.models.entities.RequiredActionProviderEntity", "org.keycloak.models.entities.PersistentUserSessionEntity", "org.keycloak.models.entities.PersistentClientSessionEntity"};
    private static final Logger logger = Logger.getLogger(DefaultMongoConnectionFactoryProvider.class);
    private static final int STATE_BEFORE_INIT = 0;
    private static final int STATE_BEFORE_UPDATE = 1;
    private static final int STATE_AFTER_UPDATE = 2;
    private volatile int state = 0;
    private MongoClient client;
    private MongoStore mongoStore;
    private DB db;
    protected Config.Scope config;
    private Map<String, String> operationalInfo;

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public DB getDBBeforeUpdate() {
        this.lazyInitBeforeUpdate();
        return this.db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitBeforeUpdate() {
        if (this.state == 0) {
            DefaultMongoConnectionFactoryProvider defaultMongoConnectionFactoryProvider = this;
            synchronized (defaultMongoConnectionFactoryProvider) {
                if (this.state == 0) {
                    try {
                        this.client = this.createMongoClient();
                        String dbName = this.config.get("db", "keycloak");
                        this.db = this.client.getDB(dbName);
                        this.state = 1;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public MongoConnectionProvider create(KeycloakSession session) {
        this.lazyInit(session);
        TransactionMongoStoreInvocationContext invocationContext = new TransactionMongoStoreInvocationContext(this.mongoStore);
        session.getTransaction().enlist((KeycloakTransaction)new MongoKeycloakTransaction(invocationContext));
        return new DefaultMongoConnectionProvider(this.db, this.mongoStore, invocationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        this.lazyInitBeforeUpdate();
        if (this.state == 1) {
            DefaultMongoConnectionFactoryProvider defaultMongoConnectionFactoryProvider = this;
            synchronized (defaultMongoConnectionFactoryProvider) {
                if (this.state == 1) {
                    try {
                        this.update(session);
                        this.mongoStore = new MongoStoreImpl(this.db, this.getManagedEntities());
                        this.state = 2;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private void update(KeycloakSession session) {
        String databaseSchema = this.config.get("databaseSchema");
        if (databaseSchema == null) {
            throw new RuntimeException("Property 'databaseSchema' needs to be specified in the configuration of mongo connections");
        }
        MongoUpdaterProvider mongoUpdater = (MongoUpdaterProvider)session.getProvider(MongoUpdaterProvider.class);
        if (mongoUpdater == null) {
            throw new RuntimeException("Can't update database: Mongo updater provider not found");
        }
        if (databaseSchema.equals("update")) {
            mongoUpdater.update(session, this.db);
        } else if (databaseSchema.equals("validate")) {
            mongoUpdater.validate(session, this.db);
        } else {
            throw new RuntimeException("Invalid value for databaseSchema: " + databaseSchema);
        }
    }

    private Class[] getManagedEntities() throws ClassNotFoundException {
        Class[] entityClasses = new Class[this.entities.length];
        for (int i = 0; i < this.entities.length; ++i) {
            entityClasses[i] = this.getClass().getClassLoader().loadClass(this.entities[i]);
        }
        return entityClasses;
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public String getId() {
        return "default";
    }

    protected MongoClient createMongoClient() throws UnknownHostException {
        MongoClient client;
        this.operationalInfo = new LinkedHashMap<String, String>();
        String dbName = this.config.get("db", "keycloak");
        String uriString = this.config.get("uri");
        if (uriString != null) {
            MongoClientURI uri = new MongoClientURI(uriString);
            MongoClient client2 = new MongoClient(uri);
            StringBuilder hostsBuilder = new StringBuilder();
            for (int i = 0; i < uri.getHosts().size(); ++i) {
                if (i != 0) {
                    hostsBuilder.append(", ");
                }
                hostsBuilder.append((String)uri.getHosts().get(i));
            }
            String hosts = hostsBuilder.toString();
            this.operationalInfo.put("mongoHosts", hosts);
            this.operationalInfo.put("mongoDatabaseName", dbName);
            this.operationalInfo.put("mongoUser", uri.getUsername());
            logger.debugv("Initialized mongo model. host(s): %s, db: %s", (Object)uri.getHosts(), (Object)dbName);
            return client2;
        }
        String host = this.config.get("host", ServerAddress.defaultHost());
        int port = this.config.getInt("port", Integer.valueOf(ServerAddress.defaultPort()));
        String user = this.config.get("user");
        String password = this.config.get("password");
        MongoClientOptions clientOptions = this.getClientOptions();
        if (user != null && password != null) {
            MongoCredential credential = MongoCredential.createCredential((String)user, (String)dbName, (char[])password.toCharArray());
            client = new MongoClient(new ServerAddress(host, port), Collections.singletonList(credential), clientOptions);
        } else {
            client = new MongoClient(new ServerAddress(host, port), clientOptions);
        }
        this.operationalInfo.put("mongoServerAddress", client.getAddress().toString());
        this.operationalInfo.put("mongoDatabaseName", dbName);
        this.operationalInfo.put("mongoUser", user);
        logger.debugv("Initialized mongo model. host: %s, port: %d, db: %s", (Object)host, (Object)port, (Object)dbName);
        return client;
    }

    protected MongoClientOptions getClientOptions() {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        this.checkIntOption("connectionsPerHost", builder);
        this.checkIntOption("threadsAllowedToBlockForConnectionMultiplier", builder);
        this.checkIntOption("maxWaitTime", builder);
        this.checkIntOption("connectTimeout", builder);
        this.checkIntOption("socketTimeout", builder);
        this.checkBooleanOption("socketKeepAlive", builder);
        this.checkBooleanOption("autoConnectRetry", builder);
        if (this.config.getBoolean("ssl", Boolean.valueOf(false)).booleanValue()) {
            builder.socketFactory(SSLSocketFactory.getDefault());
        }
        return builder.build();
    }

    protected void checkBooleanOption(String optionName, MongoClientOptions.Builder builder) {
        Boolean val = this.config.getBoolean(optionName);
        if (val != null) {
            try {
                Method m = MongoClientOptions.Builder.class.getMethod(optionName, Boolean.TYPE);
                m.invoke((Object)builder, val);
            }
            catch (Exception e) {
                throw new IllegalStateException("Problem configuring boolean option " + optionName + " for mongo client. Ensure you used correct value true or false and if this option is supported by mongo driver", e);
            }
        }
    }

    protected void checkIntOption(String optionName, MongoClientOptions.Builder builder) {
        Integer val = this.config.getInt(optionName);
        if (val != null) {
            try {
                Method m = MongoClientOptions.Builder.class.getMethod(optionName, Integer.TYPE);
                m.invoke((Object)builder, val);
            }
            catch (Exception e) {
                throw new IllegalStateException("Problem configuring int option " + optionName + " for mongo client. Ensure you used correct value (number) and if this option is supported by mongo driver", e);
            }
        }
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }
}

