/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.mongo.MongoAdminEventQuery;
import org.keycloak.events.mongo.MongoEventQuery;

public class MongoEventStoreProvider
implements EventStoreProvider {
    private DBCollection events;
    private DBCollection adminEvents;

    public MongoEventStoreProvider(DBCollection events, DBCollection adminEvents) {
        this.events = events;
        this.adminEvents = adminEvents;
    }

    public EventQuery createQuery() {
        return new MongoEventQuery(this.events);
    }

    public void clear() {
        this.events.remove((DBObject)new BasicDBObject());
    }

    public void clear(String realmId) {
        this.events.remove((DBObject)new BasicDBObject("realmId", (Object)realmId));
    }

    public void clear(String realmId, long olderThan) {
        BasicDBObject q = new BasicDBObject();
        q.put((Object)"realmId", (Object)realmId);
        q.put((Object)"time", (Object)new BasicDBObject("$lt", (Object)olderThan));
        this.events.remove((DBObject)q);
    }

    public void onEvent(Event event) {
        this.events.insert(new DBObject[]{MongoEventStoreProvider.convertEvent(event)});
    }

    public AdminEventQuery createAdminQuery() {
        return new MongoAdminEventQuery(this.adminEvents);
    }

    public void clearAdmin() {
        this.adminEvents.remove((DBObject)new BasicDBObject());
    }

    public void clearAdmin(String realmId) {
        this.adminEvents.remove((DBObject)new BasicDBObject("realmId", (Object)realmId));
    }

    public void clearAdmin(String realmId, long olderThan) {
        BasicDBObject q = new BasicDBObject();
        q.put((Object)"realmId", (Object)realmId);
        q.put((Object)"time", (Object)new BasicDBObject("$lt", (Object)olderThan));
        this.adminEvents.remove((DBObject)q);
    }

    public void onEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        this.adminEvents.insert(new DBObject[]{MongoEventStoreProvider.convertAdminEvent(adminEvent, includeRepresentation)});
    }

    public void close() {
    }

    static DBObject convertEvent(Event event) {
        BasicDBObject e = new BasicDBObject();
        e.put((Object)"time", (Object)event.getTime());
        e.put((Object)"type", (Object)event.getType().toString());
        e.put((Object)"realmId", (Object)event.getRealmId());
        e.put((Object)"clientId", (Object)event.getClientId());
        e.put((Object)"userId", (Object)event.getUserId());
        e.put((Object)"sessionId", (Object)event.getSessionId());
        e.put((Object)"ipAddress", (Object)event.getIpAddress());
        e.put((Object)"error", (Object)event.getError());
        BasicDBObject details = new BasicDBObject();
        if (event.getDetails() != null) {
            for (Map.Entry entry : event.getDetails().entrySet()) {
                details.put(entry.getKey(), entry.getValue());
            }
        }
        e.put((Object)"details", (Object)details);
        return e;
    }

    static Event convertEvent(BasicDBObject o) {
        Event event = new Event();
        event.setTime(o.getLong("time"));
        event.setType(EventType.valueOf((String)o.getString("type")));
        event.setRealmId(o.getString("realmId"));
        event.setClientId(o.getString("clientId"));
        event.setUserId(o.getString("userId"));
        event.setSessionId(o.getString("sessionId"));
        event.setIpAddress(o.getString("ipAddress"));
        event.setError(o.getString("error"));
        BasicDBObject d = (BasicDBObject)o.get("details");
        if (d != null) {
            HashMap<String, String> details = new HashMap<String, String>();
            for (Object k : d.keySet()) {
                details.put((String)k, d.getString((String)k));
            }
            event.setDetails(details);
        }
        return event;
    }

    private static DBObject convertAdminEvent(AdminEvent adminEvent, boolean includeRepresentation) {
        BasicDBObject e = new BasicDBObject();
        e.put((Object)"time", (Object)adminEvent.getTime());
        e.put((Object)"realmId", (Object)adminEvent.getRealmId());
        e.put((Object)"operationType", (Object)adminEvent.getOperationType().toString());
        MongoEventStoreProvider.setAuthDetails(e, adminEvent.getAuthDetails());
        e.put((Object)"resourcePath", (Object)adminEvent.getResourcePath());
        e.put((Object)"error", (Object)adminEvent.getError());
        if (includeRepresentation) {
            e.put((Object)"representation", (Object)adminEvent.getRepresentation());
        }
        return e;
    }

    static AdminEvent convertAdminEvent(BasicDBObject o) {
        AdminEvent adminEvent = new AdminEvent();
        adminEvent.setTime(o.getLong("time"));
        adminEvent.setRealmId(o.getString("realmId"));
        adminEvent.setOperationType(OperationType.valueOf((String)o.getString("operationType")));
        MongoEventStoreProvider.setAuthDetails(adminEvent, o);
        adminEvent.setResourcePath(o.getString("resourcePath"));
        adminEvent.setError(o.getString("error"));
        if (o.getString("representation") != null) {
            adminEvent.setRepresentation(o.getString("representation"));
        }
        return adminEvent;
    }

    private static void setAuthDetails(BasicDBObject e, AuthDetails authDetails) {
        e.put((Object)"authRealmId", (Object)authDetails.getRealmId());
        e.put((Object)"authClientId", (Object)authDetails.getClientId());
        e.put((Object)"authUserId", (Object)authDetails.getUserId());
        e.put((Object)"authIpAddress", (Object)authDetails.getIpAddress());
    }

    private static void setAuthDetails(AdminEvent adminEvent, BasicDBObject o) {
        AuthDetails authDetails = new AuthDetails();
        authDetails.setRealmId(o.getString("authRealmId"));
        authDetails.setClientId(o.getString("authClientId"));
        authDetails.setUserId(o.getString("authUserId"));
        authDetails.setIpAddress(o.getString("authIpAddress"));
        adminEvent.setAuthDetails(authDetails);
    }
}

