/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.mongo.MongoEventStoreProvider;

public class MongoAdminEventQuery
implements AdminEventQuery {
    private Integer firstResult;
    private Integer maxResults;
    private DBCollection audit;
    private final BasicDBObject query;

    public MongoAdminEventQuery(DBCollection audit) {
        this.audit = audit;
        this.query = new BasicDBObject();
    }

    public AdminEventQuery realm(String realmId) {
        this.query.put((Object)"realmId", (Object)realmId);
        return this;
    }

    public AdminEventQuery operation(OperationType ... operations) {
        LinkedList<String> operationStrings = new LinkedList<String>();
        for (OperationType e : operations) {
            operationStrings.add(e.toString());
        }
        this.query.put((Object)"operationType", (Object)new BasicDBObject("$in", operationStrings));
        return this;
    }

    public AdminEventQuery authRealm(String authRealmId) {
        this.query.put((Object)"authRealmId", (Object)authRealmId);
        return this;
    }

    public AdminEventQuery authClient(String authClientId) {
        this.query.put((Object)"authClientId", (Object)authClientId);
        return this;
    }

    public AdminEventQuery authUser(String authUserId) {
        this.query.put((Object)"authUserId", (Object)authUserId);
        return this;
    }

    public AdminEventQuery authIpAddress(String ipAddress) {
        this.query.put((Object)"authIpAddress", (Object)ipAddress);
        return this;
    }

    public AdminEventQuery resourcePath(String resourcePath) {
        this.query.put((Object)"resourcePath", (Object)Pattern.compile(resourcePath));
        return this;
    }

    public AdminEventQuery fromTime(Date fromTime) {
        BasicDBObject time = this.query.containsField("time") ? (BasicDBObject)this.query.get("time") : new BasicDBObject();
        time.append("$gte", (Object)fromTime.getTime());
        this.query.put((Object)"time", (Object)time);
        return this;
    }

    public AdminEventQuery toTime(Date toTime) {
        BasicDBObject time = this.query.containsField("time") ? (BasicDBObject)this.query.get("time") : new BasicDBObject();
        time.append("$lte", (Object)toTime.getTime());
        this.query.put((Object)"time", (Object)time);
        return this;
    }

    public AdminEventQuery firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public AdminEventQuery maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<AdminEvent> getResultList() {
        DBCursor cur = this.audit.find((DBObject)this.query).sort((DBObject)new BasicDBObject("time", (Object)-1));
        if (this.firstResult != null) {
            cur.skip(this.firstResult.intValue());
        }
        if (this.maxResults != null) {
            cur.limit(this.maxResults.intValue());
        }
        LinkedList<AdminEvent> events = new LinkedList<AdminEvent>();
        while (cur.hasNext()) {
            events.add(MongoEventStoreProvider.convertAdminEvent((BasicDBObject)cur.next()));
        }
        return events;
    }
}

