/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;

public abstract class ClientAdapter<T extends MongoIdentifiableEntity>
extends AbstractMongoAdapter<T>
implements ClientModel {
    protected final T clientEntity;
    private final RealmModel realm;
    protected KeycloakSession session;
    private final RealmProvider model;

    public ClientAdapter(KeycloakSession session, RealmModel realm, T clientEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.clientEntity = clientEntity;
        this.realm = realm;
        this.session = session;
        this.model = session.realms();
    }

    @Override
    public T getMongoEntity() {
        return this.clientEntity;
    }

    public ClientEntity getMongoEntityAsClient() {
        return (ClientEntity)this.getMongoEntity();
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getClientId() {
        return this.getMongoEntityAsClient().getName();
    }

    public long getAllowedClaimsMask() {
        return this.getMongoEntityAsClient().getAllowedClaimsMask();
    }

    public void setAllowedClaimsMask(long mask) {
        this.getMongoEntityAsClient().setAllowedClaimsMask(mask);
        this.updateMongoEntity();
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntityAsClient().getWebOrigins() != null) {
            result.addAll(this.getMongoEntityAsClient().getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        this.getMongoEntityAsClient().setWebOrigins(result);
        this.updateMongoEntity();
    }

    public void addWebOrigin(String webOrigin) {
        this.getMongoStore().pushItemToList(this.clientEntity, "webOrigins", (Object)webOrigin, true, this.invocationContext);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getMongoStore().pullItemFromList(this.clientEntity, "webOrigins", (Object)webOrigin, this.invocationContext);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntityAsClient().getRedirectUris() != null) {
            result.addAll(this.getMongoEntityAsClient().getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        this.getMongoEntityAsClient().setRedirectUris(result);
        this.updateMongoEntity();
    }

    public void addRedirectUri(String redirectUri) {
        this.getMongoStore().pushItemToList(this.clientEntity, "redirectUris", (Object)redirectUri, true, this.invocationContext);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getMongoStore().pullItemFromList(this.clientEntity, "redirectUris", (Object)redirectUri, this.invocationContext);
    }

    public boolean isEnabled() {
        return this.getMongoEntityAsClient().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getMongoEntityAsClient().setEnabled(enabled);
        this.updateMongoEntity();
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.getMongoEntityAsClient().getSecret());
    }

    public String getSecret() {
        return this.getMongoEntityAsClient().getSecret();
    }

    public void setSecret(String secret) {
        this.getMongoEntityAsClient().setSecret(secret);
        this.updateMongoEntity();
    }

    public boolean isPublicClient() {
        return this.getMongoEntityAsClient().isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getMongoEntityAsClient().setPublicClient(flag);
        this.updateMongoEntity();
    }

    public boolean isFullScopeAllowed() {
        return this.getMongoEntityAsClient().isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.getMongoEntityAsClient().setFullScopeAllowed(value);
        this.updateMongoEntity();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return this.getMongoEntityAsClient().getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getMongoEntityAsClient().setNotBefore(notBefore);
        this.updateMongoEntity();
    }

    public Set<RoleModel> getScopeMappings() {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllScopesOfClient(this, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (this.realm.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(this.session, this.realm, role, (RoleContainerModel)this.realm, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(this.session, this.realm, role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> allScopes = this.getScopeMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            MongoRoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.realm.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void addScopeMapping(RoleModel role) {
        this.getMongoStore().pushItemToList(this.getMongoEntity(), "scopeIds", (Object)role.getId(), true, this.invocationContext);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getMongoStore().pullItemFromList(this.getMongoEntity(), "scopeIds", (Object)role.getId(), this.invocationContext);
    }
}

