/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUsernameLoginFailureEntity;

public class UsernameLoginFailureAdapter
extends AbstractMongoAdapter<MongoUsernameLoginFailureEntity>
implements UsernameLoginFailureModel {
    protected MongoUsernameLoginFailureEntity user;

    public UsernameLoginFailureAdapter(MongoStoreInvocationContext invocationContext, MongoUsernameLoginFailureEntity user) {
        super(invocationContext);
        this.user = user;
    }

    @Override
    protected MongoUsernameLoginFailureEntity getMongoEntity() {
        return this.user;
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public int getFailedLoginNotBefore() {
        return this.user.getFailedLoginNotBefore();
    }

    public void setFailedLoginNotBefore(int notBefore) {
        this.user.setFailedLoginNotBefore(notBefore);
        this.updateMongoEntity();
    }

    public int getNumFailures() {
        return this.user.getNumFailures();
    }

    public void incrementFailures() {
        this.user.setNumFailures(this.getNumFailures() + 1);
        this.updateMongoEntity();
    }

    public void clearFailures() {
        this.user.setNumFailures(0);
        this.updateMongoEntity();
    }

    public long getLastFailure() {
        return this.user.getLastFailure();
    }

    public void setLastFailure(long lastFailure) {
        this.user.setLastFailure(lastFailure);
        this.updateMongoEntity();
    }

    public String getLastIPFailure() {
        return this.user.getLastIPFailure();
    }

    public void setLastIPFailure(String ip) {
        this.user.setLastIPFailure(ip);
        this.updateMongoEntity();
    }
}

