/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.entities;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.mongo.api.AbstractMongoIdentifiableEntity;
import org.keycloak.models.mongo.api.MongoCollection;
import org.keycloak.models.mongo.api.MongoEntity;
import org.keycloak.models.mongo.api.MongoField;
import org.keycloak.models.mongo.api.MongoStore;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.entities.ApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.RealmEntity;
import org.keycloak.models.mongo.keycloak.entities.UserEntity;

@MongoCollection(collectionName="roles")
public class RoleEntity
extends AbstractMongoIdentifiableEntity
implements MongoEntity {
    private static final Logger logger = Logger.getLogger(RoleEntity.class);
    private String name;
    private String description;
    private List<String> compositeRoleIds;
    private String realmId;
    private String applicationId;

    @MongoField
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @MongoField
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @MongoField
    public List<String> getCompositeRoleIds() {
        return this.compositeRoleIds;
    }

    public void setCompositeRoleIds(List<String> compositeRoleIds) {
        this.compositeRoleIds = compositeRoleIds;
    }

    @MongoField
    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    @MongoField
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public void afterRemove(MongoStoreInvocationContext invContext) {
        ApplicationEntity appEntity;
        RealmEntity realmEntity;
        MongoStore mongoStore = invContext.getMongoStore();
        DBObject query = new QueryBuilder().and("roleIds").is((Object)this.getId()).get();
        List<UserEntity> users = mongoStore.loadEntities(UserEntity.class, query, invContext);
        for (UserEntity user : users) {
            logger.info((Object)("Removing role " + this.getName() + " from user " + user.getLoginName()));
            mongoStore.pullItemFromList(user, "roleIds", this.getId(), invContext);
        }
        query = new QueryBuilder().and("scopeIds").is((Object)this.getId()).get();
        users = mongoStore.loadEntities(UserEntity.class, query, invContext);
        for (UserEntity user : users) {
            logger.info((Object)("Removing scope " + this.getName() + " from user " + user.getLoginName()));
            mongoStore.pullItemFromList(user, "scopeIds", this.getId(), invContext);
        }
        if (this.realmId != null && (realmEntity = mongoStore.loadEntity(RealmEntity.class, this.realmId, invContext)) != null) {
            mongoStore.pullItemFromList(realmEntity, "defaultRoles", this.getId(), invContext);
        }
        if (this.applicationId != null && (appEntity = mongoStore.loadEntity(ApplicationEntity.class, this.applicationId, invContext)) != null) {
            mongoStore.pullItemFromList(appEntity, "defaultRoles", this.getId(), invContext);
        }
        query = new QueryBuilder().and("compositeRoleIds").is((Object)this.getId()).get();
        List<RoleEntity> parentRoles = mongoStore.loadEntities(RoleEntity.class, query, invContext);
        for (RoleEntity role : parentRoles) {
            mongoStore.pullItemFromList(role, "compositeRoleIds", this.getId(), invContext);
        }
    }
}

