/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.AbstractMongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractAdapter;
import org.keycloak.models.mongo.keycloak.entities.UserEntity;

public class UserAdapter
extends AbstractAdapter
implements UserModel {
    private final UserEntity user;

    public UserAdapter(UserEntity userEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.user = userEntity;
    }

    public String getLoginName() {
        return this.user.getLoginName();
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
        this.updateUser();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
        this.updateUser();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
        this.updateUser();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
        this.updateUser();
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
        this.updateUser();
    }

    public void setAttribute(String name, String value) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap<String, String>());
        }
        this.user.getAttributes().put(name, value);
        this.updateUser();
    }

    public void removeAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return;
        }
        this.user.getAttributes().remove(name);
        this.updateUser();
    }

    public String getAttribute(String name) {
        return this.user.getAttributes() == null ? null : this.user.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        return this.user.getAttributes() == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.user.getAttributes());
    }

    public UserEntity getUser() {
        return this.user;
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (this.user.getWebOrigins() != null) {
            result.addAll(this.user.getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        this.user.setWebOrigins(result);
        this.updateUser();
    }

    public void addWebOrigin(String webOrigin) {
        this.getMongoStore().pushItemToList(this.user, "webOrigins", webOrigin, true, this.invocationContext);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getMongoStore().pullItemFromList(this.user, "webOrigins", webOrigin, this.invocationContext);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (this.user.getRedirectUris() != null) {
            result.addAll(this.user.getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        this.user.setRedirectUris(result);
        this.updateUser();
    }

    public void addRedirectUri(String redirectUri) {
        this.getMongoStore().pushItemToList(this.user, "redirectUris", redirectUri, true, this.invocationContext);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getMongoStore().pullItemFromList(this.user, "redirectUris", redirectUri, this.invocationContext);
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        HashSet<UserModel.RequiredAction> result = new HashSet<UserModel.RequiredAction>();
        if (this.user.getRequiredActions() != null) {
            result.addAll(this.user.getRequiredActions());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.getMongoStore().pushItemToList(this.user, "requiredActions", action, true, this.invocationContext);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.getMongoStore().pullItemFromList(this.user, "requiredActions", action, this.invocationContext);
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
        this.updateUser();
    }

    protected void updateUser() {
        this.getMongoStore().updateEntity(this.user, this.invocationContext);
    }

    @Override
    public AbstractMongoIdentifiableEntity getMongoEntity() {
        return this.user;
    }
}

