/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.MongoStore;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.impl.context.TransactionMongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.MongoKeycloakTransaction;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.entities.RealmEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MongoKeycloakSession
implements KeycloakSession {
    private final MongoStoreInvocationContext invocationContext;
    private final MongoKeycloakTransaction transaction;

    public MongoKeycloakSession(MongoStore mongoStore) {
        this.invocationContext = new TransactionMongoStoreInvocationContext(mongoStore);
        this.transaction = new MongoKeycloakTransaction(this.invocationContext);
    }

    public KeycloakTransaction getTransaction() {
        return this.transaction;
    }

    public void close() {
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        if (this.getRealm(id) != null) {
            throw new IllegalStateException("Realm with id '" + id + "' already exists");
        }
        RealmEntity newRealm = new RealmEntity();
        newRealm.setId(id);
        newRealm.setName(name);
        this.getMongoStore().insertEntity(newRealm, this.invocationContext);
        return new RealmAdapter(newRealm, this.invocationContext);
    }

    public RealmModel getRealm(String id) {
        RealmEntity realmEntity = this.getMongoStore().loadEntity(RealmEntity.class, id, this.invocationContext);
        return realmEntity != null ? new RealmAdapter(realmEntity, this.invocationContext) : null;
    }

    public List<RealmModel> getRealms(UserModel admin) {
        BasicDBObject query = new BasicDBObject();
        List<RealmEntity> realms = this.getMongoStore().loadEntities(RealmEntity.class, (DBObject)query, this.invocationContext);
        ArrayList<RealmModel> results = new ArrayList<RealmModel>();
        for (RealmEntity realmEntity : realms) {
            results.add(new RealmAdapter(realmEntity, this.invocationContext));
        }
        return results;
    }

    public RealmModel getRealmByName(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).get();
        RealmEntity realm = this.getMongoStore().loadSingleEntity(RealmEntity.class, query, this.invocationContext);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(realm, this.invocationContext);
    }

    public boolean removeRealm(String id) {
        return this.getMongoStore().removeEntity(RealmEntity.class, id, this.invocationContext);
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }
}

