/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.impl.types;

import com.mongodb.BasicDBList;
import java.util.List;
import org.keycloak.models.mongo.api.types.Mapper;
import org.keycloak.models.mongo.api.types.MapperContext;
import org.keycloak.models.mongo.api.types.MapperRegistry;

public class ListMapper<T extends List>
implements Mapper<T, BasicDBList> {
    private final MapperRegistry mapperRegistry;
    private final Class<T> listType;

    public ListMapper(MapperRegistry mapperRegistry, Class<T> listType) {
        this.mapperRegistry = mapperRegistry;
        this.listType = listType;
    }

    @Override
    public BasicDBList convertObject(MapperContext<T, BasicDBList> context) {
        List appObjectsList = (List)context.getObjectToConvert();
        BasicDBList dbObjects = new BasicDBList();
        for (Object appObject : appObjectsList) {
            Object dbObject = this.mapperRegistry.convertApplicationObjectToDBObject(appObject, Object.class);
            dbObjects.add(dbObject);
        }
        return dbObjects;
    }

    @Override
    public Class<? extends T> getTypeOfObjectToConvert() {
        return this.listType;
    }

    @Override
    public Class<BasicDBList> getExpectedReturnType() {
        return BasicDBList.class;
    }
}

