/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.group.MapGroupAdapter;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.ProviderEvent;

public class MapGroupProvider
implements GroupProvider {
    private static final Logger LOG = Logger.getLogger(MapGroupProvider.class);
    private final KeycloakSession session;
    final MapStorage<MapGroupEntity, GroupModel> store;
    private final boolean storeHasRealmId;

    public MapGroupProvider(KeycloakSession session, MapStorage<MapGroupEntity, GroupModel> groupStore) {
        this.session = session;
        this.store = groupStore;
        this.storeHasRealmId = this.store instanceof HasRealmId;
    }

    private MapStorage<MapGroupEntity, GroupModel> storeWithRealm(RealmModel realm) {
        if (this.storeHasRealmId) {
            ((HasRealmId)((Object)this.store)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.store;
    }

    private Function<MapGroupEntity, GroupModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapGroupAdapter(this.session, realm, (MapGroupEntity)origEntity){

            public Stream<GroupModel> getSubGroupsStream() {
                return MapGroupProvider.this.getGroupsByParentId(this.realm, this.getId());
            }
        };
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        if (id == null || realm == null) {
            return null;
        }
        LOG.tracef("getGroupById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        String realmId = realm.getId();
        MapGroupEntity entity = this.storeWithRealm(realm).read(id);
        return entity == null || !Objects.equals(realmId, entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public GroupModel getGroupByName(RealmModel realm, GroupModel parent, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getGroupByName(%s, %s)%s", (Object)realm, (Object)name, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name})).compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        mcb = parent != null ? (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{parent.getId()}) : (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        QueryParameters queryParameters = QueryParameters.withCriteria(mcb);
        String groupId = this.storeWithRealm(realm).read(queryParameters).findFirst().map(AbstractEntity::getId).orElse(null);
        return groupId == null ? null : this.session.groups().getGroupById(realm, groupId);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        return this.getGroupsStreamInternal(realm, null, null);
    }

    private Stream<GroupModel> getGroupsStreamInternal(RealmModel realm, UnaryOperator<DefaultModelCriteria<GroupModel>> modifier, UnaryOperator<QueryParameters<GroupModel>> queryParametersModifier) {
        LOG.tracef("getGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (modifier != null) {
            mcb = (DefaultModelCriteria)modifier.apply(mcb);
        }
        QueryParameters queryParameters = QueryParameters.withCriteria(mcb).orderBy(GroupModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING);
        if (queryParametersModifier != null) {
            queryParameters = (QueryParameters)queryParametersModifier.apply(queryParameters);
        }
        return this.storeWithRealm(realm).read(queryParameters).map(this.entityToAdapterFunc(realm));
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{ids})).compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (search != null) {
            mcb = (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"});
        }
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(first, max, GroupModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        LOG.tracef("getGroupsCount(%s, %s)%s", (Object)realm, (Object)onlyTopGroups, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (Objects.equals(onlyTopGroups, Boolean.TRUE)) {
            mcb = (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return this.storeWithRealm(realm).getCount(QueryParameters.withCriteria(mcb));
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.searchForGroupByNameStream(realm, search, false, null, null).count();
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        LOG.tracef("getGroupsByRole(%s, %s, %d, %d)%s", new Object[]{realm, role, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.getGroupsStreamInternal(realm, mcb -> (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()}), qp -> qp.offset(firstResult).limit(maxResults));
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        LOG.tracef("getTopLevelGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getGroupsStreamInternal(realm, mcb -> (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]), null);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        LOG.tracef("getTopLevelGroupsStream(%s, %s, %s)%s", new Object[]{realm, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.getGroupsStreamInternal(realm, mcb -> (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]), qp -> qp.offset(firstResult).limit(maxResults));
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Boolean exact, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForGroupByNameStream(%s, %s, %s, %b, %d, %d)%s", new Object[]{realm, this.session, search, exact, firstResult, maxResults, StackUtil.getShortStackTrace()});
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = exact != null && exact.equals(Boolean.TRUE) ? (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{search}) : (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"});
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, GroupModel.SearchableFields.NAME)).map(AbstractEntity::getId).map(id -> {
            GroupModel groupById = this.session.groups().getGroupById(realm, id);
            while (Objects.nonNull(groupById.getParentId())) {
                groupById = this.session.groups().getGroupById(realm, groupById.getParentId());
            }
            return groupById;
        }).sorted(GroupModel.COMPARE_BY_NAME).distinct();
    }

    public Stream<GroupModel> searchGroupsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            mcb = (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.ATTRIBUTE, ModelCriteriaBuilder.Operator.EQ, new Object[]{entry.getKey(), entry.getValue()});
        }
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, GroupModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        LOG.tracef("createGroup(%s, %s, %s, %s)%s", new Object[]{realm, id, name, toParent, StackUtil.getShortStackTrace()});
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        DefaultModelCriteria defaultModelCriteria = mcb = toParent == null ? (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]) : (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{toParent.getId()});
        if (this.storeWithRealm(realm).exists(QueryParameters.withCriteria(mcb))) {
            throw new ModelDuplicateException("Group with name '" + name + "' in realm " + realm.getName() + " already exists for requested parent");
        }
        MapGroupEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapGroupEntity.class);
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setName(name);
        entity.setParentId(toParent == null ? null : toParent.getId());
        if (id != null && this.storeWithRealm(realm).exists(id)) {
            throw new ModelDuplicateException("Group exists: " + id);
        }
        entity = this.storeWithRealm(realm).create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public boolean removeGroup(RealmModel realm, GroupModel group) {
        LOG.tracef("removeGroup(%s, %s)%s", (Object)realm, (Object)group, StackUtil.getShortStackTrace());
        if (group == null) {
            return false;
        }
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.GROUP_BEFORE_REMOVE, new Object[]{realm, group});
        this.storeWithRealm(realm).delete(group.getId());
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.GROUP_AFTER_REMOVE, new Object[]{realm, group});
        return true;
    }

    public void moveGroup(final RealmModel realm, GroupModel group, GroupModel toParent) {
        LOG.tracef("moveGroup(%s, %s, %s)%s", new Object[]{realm, group, toParent, StackUtil.getShortStackTrace()});
        GroupModel previousParent = group.getParent();
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{group.getName()});
        mcb = toParent == null ? (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]) : (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{toParent.getId()});
        try (Stream<MapGroupEntity> possibleSiblings = this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb));){
            if (possibleSiblings.findAny().isPresent()) {
                throw new ModelDuplicateException("Parent already contains subgroup named '" + group.getName() + "'");
            }
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        }
        final String newPath = KeycloakModelUtils.buildGroupPath((GroupModel)group);
        final String previousPath = KeycloakModelUtils.buildGroupPath((GroupModel)group, (GroupModel)previousParent);
        GroupModel.GroupPathChangeEvent event = new GroupModel.GroupPathChangeEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public String getNewPath() {
                return newPath;
            }

            public String getPreviousPath() {
                return previousPath;
            }

            public KeycloakSession getKeycloakSession() {
                return MapGroupProvider.this.session;
            }
        };
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)event);
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        LOG.tracef("addTopLevelGroup(%s, %s)%s", (Object)realm, (Object)subGroup, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{null})).compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{subGroup.getName()});
        try (Stream<MapGroupEntity> possibleSiblings = this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb));){
            if (possibleSiblings.findAny().isPresent()) {
                throw new ModelDuplicateException("There is already a top level group named '" + subGroup.getName() + "'");
            }
        }
        subGroup.setParent(null);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        LOG.tracef("preRemove(%s, %s)%s", (Object)realm, (Object)role, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()});
        try (Stream<MapGroupEntity> toRemove = this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb));){
            toRemove.map(groupEntity -> this.session.groups().getGroupById(realm, groupEntity.getId())).forEach(groupModel -> groupModel.deleteRoleMapping(role));
        }
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.storeWithRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void close() {
    }

    private Stream<GroupModel> getGroupsByParentId(RealmModel realm, String parentId) {
        LOG.tracef("getGroupsByParentId(%s)%s", (Object)parentId, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{parentId});
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb).orderBy(GroupModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }
}

