/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapIdentityProviderEntity
extends UpdatableEntity,
AbstractEntity {
    public static MapIdentityProviderEntity fromModel(IdentityProviderModel model) {
        if (model == null) {
            return null;
        }
        MapIdentityProviderEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapIdentityProviderEntity.class);
        String id = model.getInternalId() == null ? KeycloakModelUtils.generateId() : model.getInternalId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setDisplayName(model.getDisplayName());
        entity.setProviderId(model.getProviderId());
        entity.setFirstBrokerLoginFlowId(model.getFirstBrokerLoginFlowId());
        entity.setPostBrokerLoginFlowId(model.getPostBrokerLoginFlowId());
        entity.setEnabled(model.isEnabled());
        entity.setTrustEmail(model.isTrustEmail());
        entity.setStoreToken(model.isStoreToken());
        entity.setLinkOnly(model.isLinkOnly());
        entity.setAddReadTokenRoleOnCreate(model.isAddReadTokenRoleOnCreate());
        entity.setAuthenticateByDefault(model.isAuthenticateByDefault());
        entity.setConfig(model.getConfig());
        return entity;
    }

    public static IdentityProviderModel toModel(MapIdentityProviderEntity entity, Supplier<IdentityProviderModel> instanceCreator) {
        if (entity == null) {
            return null;
        }
        IdentityProviderModel model = instanceCreator.get();
        model.setInternalId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setDisplayName(entity.getDisplayName());
        model.setProviderId(entity.getProviderId());
        model.setFirstBrokerLoginFlowId(entity.getFirstBrokerLoginFlowId());
        model.setPostBrokerLoginFlowId(entity.getPostBrokerLoginFlowId());
        Boolean enabled = entity.isEnabled();
        model.setEnabled(enabled == null ? false : enabled);
        Boolean trustEmail = entity.isTrustEmail();
        model.setTrustEmail(trustEmail == null ? false : trustEmail);
        Boolean storeToken = entity.isStoreToken();
        model.setStoreToken(storeToken == null ? false : storeToken);
        Boolean linkOnly = entity.isLinkOnly();
        model.setLinkOnly(linkOnly == null ? false : linkOnly);
        Boolean addReadTokenRoleOnCreate = entity.isAddReadTokenRoleOnCreate();
        model.setAddReadTokenRoleOnCreate(addReadTokenRoleOnCreate == null ? false : addReadTokenRoleOnCreate);
        Boolean authenticateByDefault = entity.isAuthenticateByDefault();
        model.setAuthenticateByDefault(authenticateByDefault == null ? false : authenticateByDefault);
        Map<String, String> config = entity.getConfig();
        model.setConfig(config == null ? new HashMap() : new HashMap<String, String>(config));
        return model;
    }

    public String getAlias();

    public void setAlias(String var1);

    public String getDisplayName();

    public void setDisplayName(String var1);

    public String getProviderId();

    public void setProviderId(String var1);

    public String getFirstBrokerLoginFlowId();

    public void setFirstBrokerLoginFlowId(String var1);

    public String getPostBrokerLoginFlowId();

    public void setPostBrokerLoginFlowId(String var1);

    public Boolean isEnabled();

    public void setEnabled(Boolean var1);

    public Boolean isTrustEmail();

    public void setTrustEmail(Boolean var1);

    public Boolean isStoreToken();

    public void setStoreToken(Boolean var1);

    public Boolean isLinkOnly();

    public void setLinkOnly(Boolean var1);

    public Boolean isAddReadTokenRoleOnCreate();

    public void setAddReadTokenRoleOnCreate(Boolean var1);

    public Boolean isAuthenticateByDefault();

    public void setAuthenticateByDefault(Boolean var1);

    public Map<String, String> getConfig();

    public void setConfig(Map<String, String> var1);
}

