/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.keycloak.cluster.ClusterEvent;

public class MapAuthenticationSessionAuthNoteUpdateEvent
implements ClusterEvent {
    private String authSessionId;
    private String tabId;
    private String clientUUID;
    private Map<String, String> authNotesFragment;

    public static MapAuthenticationSessionAuthNoteUpdateEvent create(String authSessionId, String tabId, String clientUUID, Map<String, String> authNotesFragment) {
        MapAuthenticationSessionAuthNoteUpdateEvent event = new MapAuthenticationSessionAuthNoteUpdateEvent();
        event.authSessionId = authSessionId;
        event.tabId = tabId;
        event.clientUUID = clientUUID;
        event.authNotesFragment = new LinkedHashMap<String, String>(authNotesFragment);
        return event;
    }

    public String getAuthSessionId() {
        return this.authSessionId;
    }

    public String getTabId() {
        return this.tabId;
    }

    public String getClientUUID() {
        return this.clientUUID;
    }

    public Map<String, String> getAuthNotesFragment() {
        return this.authNotesFragment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapAuthenticationSessionAuthNoteUpdateEvent that = (MapAuthenticationSessionAuthNoteUpdateEvent)o;
        return Objects.equals(this.authSessionId, that.authSessionId) && Objects.equals(this.tabId, that.tabId) && Objects.equals(this.clientUUID, that.clientUUID);
    }

    public int hashCode() {
        return Objects.hash(this.authSessionId, this.tabId, this.clientUUID);
    }

    public String toString() {
        return String.format("AuthenticationSessionAuthNoteUpdateEvent [ authSessionId=%s, tabId=%s, clientUUID=%s, authNotesFragment=%s ]", this.authSessionId, this.tabId, this.clientUUID, this.authNotesFragment);
    }
}

