/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.realm.MapRealmAdapter;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.storage.SearchableModelField;

public class MapRealmProvider
implements RealmProvider {
    private static final Logger LOG = Logger.getLogger(MapRealmProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<MapRealmEntity, RealmModel> tx;

    public MapRealmProvider(KeycloakSession session, MapStorage<MapRealmEntity, RealmModel> realmStore) {
        this.session = session;
        this.tx = realmStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private RealmModel entityToAdapter(MapRealmEntity entity) {
        return new MapRealmAdapter(this.session, entity);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        if (this.getRealmByName(name) != null) {
            throw new ModelDuplicateException("Realm with given name exists: " + name);
        }
        if (id != null && this.tx.exists(id)) {
            throw new ModelDuplicateException("Realm exists: " + id);
        }
        LOG.tracef("createRealm(%s, %s)%s", (Object)id, (Object)name, StackUtil.getShortStackTrace());
        MapRealmEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapRealmEntity.class);
        entity.setId(id);
        entity.setName(name);
        entity = this.tx.create(entity);
        return this.entityToAdapter(entity);
    }

    public RealmModel getRealm(String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getRealm(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        MapRealmEntity entity = this.tx.read(id);
        return entity == null ? null : this.entityToAdapter(entity);
    }

    public RealmModel getRealmByName(String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmByName(%s)%s", (Object)name, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(RealmModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        String realmId = this.tx.read(QueryParameters.withCriteria(mcb)).findFirst().map(AbstractEntity::getId).orElse(null);
        return realmId == null ? null : this.session.realms().getRealm(realmId);
    }

    public Stream<RealmModel> getRealmsStream() {
        return this.getRealmsStream(DefaultModelCriteria.criteria());
    }

    public Stream<RealmModel> getRealmsWithProviderTypeStream(Class<?> type) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(RealmModel.SearchableFields.COMPONENT_PROVIDER_TYPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{type.getName()});
        return this.getRealmsStream(mcb);
    }

    private Stream<RealmModel> getRealmsStream(DefaultModelCriteria<RealmModel> mcb) {
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy((SearchableModelField<RealmModel>)RealmModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this::entityToAdapter);
    }

    public boolean removeRealm(String id) {
        LOG.tracef("removeRealm(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        RealmModel realm = this.getRealm(id);
        if (realm == null) {
            return false;
        }
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE, new Object[]{realm});
        this.tx.delete(id);
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.REALM_AFTER_REMOVE, new Object[]{realm});
        return true;
    }

    public void removeExpiredClientInitialAccess() {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(RealmModel.SearchableFields.CLIENT_INITIAL_ACCESS, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
        this.tx.read(QueryParameters.withCriteria(mcb)).forEach(MapRealmEntity::removeExpiredClientInitialAccesses);
    }

    public void saveLocalizationText(RealmModel realm, String locale, String key, String text) {
        if (locale == null || key == null || text == null) {
            return;
        }
        HashMap<String, String> texts = new HashMap<String, String>();
        texts.put(key, text);
        realm.createOrUpdateRealmLocalizationTexts(locale, texts);
    }

    public void saveLocalizationTexts(RealmModel realm, String locale, Map<String, String> localizationTexts) {
        if (locale == null || localizationTexts == null) {
            return;
        }
        realm.createOrUpdateRealmLocalizationTexts(locale, localizationTexts);
    }

    public boolean updateLocalizationText(RealmModel realm, String locale, String key, String text) {
        if (locale == null || key == null || text == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return false;
        }
        this.saveLocalizationText(realm, locale, key, text);
        return true;
    }

    public boolean deleteLocalizationTextsByLocale(RealmModel realm, String locale) {
        return realm.removeRealmLocalizationTexts(locale);
    }

    public boolean deleteLocalizationText(RealmModel realm, String locale, String key) {
        if (locale == null || key == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return false;
        }
        HashMap texts = new HashMap(realm.getRealmLocalizationTextsByLocale(locale));
        texts.remove(key);
        realm.removeRealmLocalizationTexts(locale);
        realm.createOrUpdateRealmLocalizationTexts(locale, texts);
        return true;
    }

    public String getLocalizationTextsById(RealmModel realm, String locale, String key) {
        if (locale == null || key == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return null;
        }
        return (String)realm.getRealmLocalizationTextsByLocale(locale).get(key);
    }

    @Deprecated
    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        return this.session.clients().addClient(realm, id, clientId);
    }

    @Deprecated
    public long getClientsCount(RealmModel realm) {
        return this.session.clients().getClientsCount(realm);
    }

    @Deprecated
    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.session.clients().getClientsStream(realm, firstResult, maxResults);
    }

    @Deprecated
    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        return this.session.clients().getAlwaysDisplayInConsoleClientsStream(realm);
    }

    @Deprecated
    public boolean removeClient(RealmModel realm, String id) {
        return this.session.clients().removeClient(realm, id);
    }

    @Deprecated
    public void removeClients(RealmModel realm) {
        this.session.clients().removeClients(realm);
    }

    @Deprecated
    public ClientModel getClientById(RealmModel realm, String id) {
        return this.session.clients().getClientById(realm, id);
    }

    @Deprecated
    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        return this.session.clients().getClientByClientId(realm, clientId);
    }

    @Deprecated
    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByClientIdStream(realm, clientId, firstResult, maxResults);
    }

    @Deprecated
    public Stream<ClientModel> searchClientsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByAttributes(realm, attributes, firstResult, maxResults);
    }

    @Deprecated
    public void addClientScopes(RealmModel realm, ClientModel client, Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        this.session.clients().addClientScopes(realm, client, clientScopes, defaultScope);
    }

    @Deprecated
    public void removeClientScope(RealmModel realm, ClientModel client, ClientScopeModel clientScope) {
        this.session.clients().removeClientScope(realm, client, clientScope);
    }

    @Deprecated
    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScopes) {
        return this.session.clients().getClientScopes(realm, client, defaultScopes);
    }

    @Deprecated
    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        return this.session.clientScopes().getClientScopeById(realm, id);
    }

    @Deprecated
    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        return this.session.clientScopes().getClientScopesStream(realm);
    }

    @Deprecated
    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        return this.session.clientScopes().addClientScope(realm, id, name);
    }

    @Deprecated
    public boolean removeClientScope(RealmModel realm, String id) {
        return this.session.clientScopes().removeClientScope(realm, id);
    }

    @Deprecated
    public void removeClientScopes(RealmModel realm) {
        this.session.clientScopes().removeClientScopes(realm);
    }

    @Deprecated
    public Map<ClientModel, Set<String>> getAllRedirectUrisOfEnabledClients(RealmModel realm) {
        return this.session.clients().getAllRedirectUrisOfEnabledClients(realm);
    }

    @Deprecated
    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        this.session.groups().moveGroup(realm, group, toParent);
    }

    @Deprecated
    public GroupModel getGroupById(RealmModel realm, String id) {
        return this.session.groups().getGroupById(realm, id);
    }

    @Deprecated
    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        return this.session.groups().getGroupsCount(realm, onlyTopGroups);
    }

    @Deprecated
    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.session.groups().getGroupsCountByNameContaining(realm, search);
    }

    @Deprecated
    public boolean removeGroup(RealmModel realm, GroupModel group) {
        return this.session.groups().removeGroup(realm, group);
    }

    @Deprecated
    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        return this.session.groups().createGroup(realm, id, name, toParent);
    }

    @Deprecated
    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        this.session.groups().addTopLevelGroup(realm, subGroup);
    }

    @Deprecated
    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        return this.session.groups().getGroupsStream(realm);
    }

    @Deprecated
    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        return this.session.groups().getGroupsStream(realm, ids, search, first, max);
    }

    @Deprecated
    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return this.session.groups().getGroupsByRoleStream(realm, role, firstResult, maxResults);
    }

    @Deprecated
    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        return this.session.groups().getTopLevelGroupsStream(realm);
    }

    @Deprecated
    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.session.groups().getTopLevelGroupsStream(realm, firstResult, maxResults);
    }

    @Deprecated
    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Boolean exact, Integer firstResult, Integer maxResults) {
        return this.session.groups().searchForGroupByNameStream(realm, search, exact, firstResult, maxResults);
    }

    public Stream<GroupModel> searchGroupsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.session.groups().searchGroupsByAttributes(realm, attributes, firstResult, maxResults);
    }

    @Deprecated
    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        return this.session.roles().addRealmRole(realm, id, name);
    }

    @Deprecated
    public RoleModel getRealmRole(RealmModel realm, String name) {
        return this.session.roles().getRealmRole(realm, name);
    }

    @Deprecated
    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        return this.session.roles().getRealmRolesStream(realm, first, max);
    }

    public Stream<RoleModel> getRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        return this.session.roles().getRolesStream(realm, ids, search, first, max);
    }

    @Deprecated
    public boolean removeRole(RoleModel role) {
        return this.session.roles().removeRole(role);
    }

    @Deprecated
    public void removeRoles(RealmModel realm) {
        this.session.roles().removeRoles(realm);
    }

    @Deprecated
    public RoleModel addClientRole(ClientModel client, String id, String name) {
        return this.session.roles().addClientRole(client, name);
    }

    @Deprecated
    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        return this.session.roles().getClientRolesStream(client, first, max);
    }

    @Deprecated
    public void removeRoles(ClientModel client) {
        this.session.roles().removeRoles(client);
    }

    @Deprecated
    public RoleModel getRoleById(RealmModel realm, String id) {
        return this.session.roles().getRoleById(realm, id);
    }

    @Deprecated
    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        return this.session.roles().searchForRolesStream(realm, search, first, max);
    }

    @Deprecated
    public RoleModel getClientRole(ClientModel client, String name) {
        return this.session.roles().getClientRole(client, name);
    }

    @Deprecated
    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        return this.session.roles().searchForClientRolesStream(client, search, first, max);
    }

    public void close() {
    }
}

