/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityWithAttributes;
import org.keycloak.models.map.common.UpdatableEntity;

@DeepCloner.Root
public interface MapClientScopeEntity
extends AbstractEntity,
UpdatableEntity,
EntityWithAttributes {
    public String getName();

    public String getDescription();

    public String getProtocol();

    public String getRealmId();

    public void setName(String var1);

    public void setDescription(String var1);

    public void setProtocol(String var1);

    public void setRealmId(String var1);

    public Optional<MapProtocolMapperEntity> getProtocolMapper(String var1);

    public Set<MapProtocolMapperEntity> getProtocolMappers();

    public void addProtocolMapper(MapProtocolMapperEntity var1);

    public void removeProtocolMapper(String var1);

    public void addScopeMapping(String var1);

    public void removeScopeMapping(String var1);

    public Collection<String> getScopeMappings();

    public static abstract class AbstractClientScopeEntity
    extends UpdatableEntity.Impl
    implements MapClientScopeEntity {
        private String id;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            this.id = id;
            this.updated |= id != null;
        }

        @Override
        public Optional<MapProtocolMapperEntity> getProtocolMapper(String id) {
            Set<MapProtocolMapperEntity> mappers = this.getProtocolMappers();
            if (mappers == null || mappers.isEmpty()) {
                return Optional.empty();
            }
            return mappers.stream().filter(m -> Objects.equals(m.getId(), id)).findFirst();
        }

        @Override
        public void removeProtocolMapper(String id) {
            Set<MapProtocolMapperEntity> mappers = this.getProtocolMappers();
            this.updated |= mappers != null && mappers.removeIf(m -> Objects.equals(m.getId(), id));
        }
    }
}

