/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.SingleUseObjectKeycloakTransaction;
import org.keycloak.models.map.storage.chm.SingleUseObjectModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class SingleUseObjectConcurrentHashMapStorage<K, V extends AbstractEntity, M>
extends ConcurrentHashMapStorage<K, MapSingleUseObjectEntity, SingleUseObjectValueModel> {
    public SingleUseObjectConcurrentHashMapStorage(StringKeyConverter<K> keyConverter, DeepCloner cloner) {
        super(SingleUseObjectValueModel.class, keyConverter, cloner);
    }

    @Override
    public MapKeycloakTransaction<MapSingleUseObjectEntity, SingleUseObjectValueModel> createTransaction(KeycloakSession session) {
        SingleUseObjectKeycloakTransaction singleUseObjectTransaction = (SingleUseObjectKeycloakTransaction)session.getAttribute("map-transaction-" + this.hashCode(), MapKeycloakTransaction.class);
        if (singleUseObjectTransaction == null) {
            singleUseObjectTransaction = new SingleUseObjectKeycloakTransaction(this, this.keyConverter, this.cloner, this.fieldPredicates);
            session.setAttribute("map-transaction-" + this.hashCode(), singleUseObjectTransaction);
        }
        return singleUseObjectTransaction;
    }

    @Override
    public MapSingleUseObjectEntity create(MapSingleUseObjectEntity value) {
        if (value.getId() == null && value.getObjectKey() != null) {
            value.setId(value.getObjectKey());
        }
        return super.create(value);
    }

    @Override
    public Stream<MapSingleUseObjectEntity> read(QueryParameters<SingleUseObjectValueModel> queryParameters) {
        DefaultModelCriteria<SingleUseObjectValueModel> criteria = queryParameters.getModelCriteriaBuilder();
        if (criteria == null) {
            return Stream.empty();
        }
        SingleUseObjectModelCriteriaBuilder mcb = criteria.flashToModelCriteriaBuilder(this.createSingleUseObjectCriteriaBuilder());
        if (mcb.isValid()) {
            MapSingleUseObjectEntity value = (MapSingleUseObjectEntity)this.read(mcb.getKey());
            return value != null ? Stream.of(value) : Stream.empty();
        }
        return super.read(queryParameters);
    }

    private SingleUseObjectModelCriteriaBuilder createSingleUseObjectCriteriaBuilder() {
        return new SingleUseObjectModelCriteriaBuilder();
    }
}

