/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.function.Supplier;

public class LazilyInitialized<T> {
    private final Supplier<T> supplier;
    private final AtomicMarkableReference<T> supplierRef = new AtomicMarkableReference<Object>(null, false);

    public LazilyInitialized(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T get() {
        if (!this.isInitialized()) {
            this.supplierRef.compareAndSet(null, this.supplier == null ? null : (Object)this.supplier.get(), false, true);
        }
        return this.supplierRef.getReference();
    }

    public boolean isInitialized() {
        return this.supplierRef.isMarked();
    }
}

