/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.userSession.AbstractUserSessionModel;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

public abstract class MapUserSessionAdapter
extends AbstractUserSessionModel {
    public MapUserSessionAdapter(KeycloakSession session, RealmModel realm, MapUserSessionEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getBrokerSessionId() {
        return this.entity.getBrokerSessionId();
    }

    public String getBrokerUserId() {
        return this.entity.getBrokerUserId();
    }

    public UserModel getUser() {
        return this.session.users().getUserById(this.getRealm(), this.entity.getUserId());
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        Boolean rememberMe = this.entity.isRememberMe();
        return rememberMe != null ? rememberMe : false;
    }

    public int getStarted() {
        Long started = this.entity.getStarted();
        return started != null ? TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(started) : 0;
    }

    public int getLastSessionRefresh() {
        Long lastSessionRefresh = this.entity.getLastSessionRefresh();
        return lastSessionRefresh != null ? TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(lastSessionRefresh) : 0;
    }

    public void setLastSessionRefresh(int seconds) {
        this.entity.setLastSessionRefresh(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(seconds));
    }

    public boolean isOffline() {
        Boolean offline = this.entity.isOffline();
        return offline != null ? offline : false;
    }

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
        HashMap result = new HashMap();
        LinkedList removedClientUUIDS = new LinkedList();
        Map<String, String> authenticatedClientSessions = this.entity.getAuthenticatedClientSessions();
        if (authenticatedClientSessions == null) {
            return Collections.emptyMap();
        }
        authenticatedClientSessions = new HashMap<String, String>(authenticatedClientSessions);
        authenticatedClientSessions.forEach((clientUUID, clientSessionId) -> {
            ClientModel client = this.realm.getClientById(clientUUID);
            if (client != null) {
                AuthenticatedClientSessionModel clientSession = this.session.sessions().getClientSession((UserSessionModel)this, client, clientSessionId, this.isOffline());
                if (clientSession != null) {
                    result.put(clientUUID, clientSession);
                }
            } else {
                removedClientUUIDS.add(clientUUID);
            }
        });
        this.removeAuthenticatedClientSessions(removedClientUUIDS);
        return Collections.unmodifiableMap(result);
    }

    public AuthenticatedClientSessionModel getAuthenticatedClientSessionByClient(String clientUUID) {
        String clientSessionId = this.entity.getAuthenticatedClientSession(clientUUID);
        if (clientSessionId == null) {
            return null;
        }
        ClientModel client = this.realm.getClientById(clientUUID);
        if (client != null) {
            return this.session.sessions().getClientSession((UserSessionModel)this, client, clientSessionId, this.isOffline());
        }
        this.removeAuthenticatedClientSessions(Collections.singleton(clientUUID));
        return null;
    }

    public String getNote(String name) {
        return name != null ? this.entity.getNote(name) : null;
    }

    public void setNote(String name, String value) {
        if (name != null) {
            if (value == null) {
                this.entity.removeNote(name);
            } else {
                this.entity.setNote(name, value);
            }
        }
    }

    public void removeNote(String name) {
        if (name != null) {
            this.entity.removeNote(name);
        }
    }

    public Map<String, String> getNotes() {
        Map<String, String> notes = this.entity.getNotes();
        return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
    }

    public UserSessionModel.State getState() {
        return this.entity.getState();
    }

    public void setState(UserSessionModel.State state) {
        this.entity.setState(state);
    }

    public void restartSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        this.entity.setRealmId(realm.getId());
        this.entity.setUserId(user.getId());
        this.entity.setLoginUsername(loginUsername);
        this.entity.setIpAddress(ipAddress);
        this.entity.setAuthMethod(authMethod);
        this.entity.setRememberMe(rememberMe);
        this.entity.setBrokerSessionId(brokerSessionId);
        this.entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        this.entity.setStarted(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(currentTime));
        this.entity.setLastSessionRefresh(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(currentTime));
        this.entity.setState(null);
        String correspondingSessionId = this.entity.getNote("correspondingSessionId");
        this.entity.setNotes(new ConcurrentHashMap<String, String>());
        if (correspondingSessionId != null) {
            this.entity.setNote("correspondingSessionId", correspondingSessionId);
        }
        this.entity.setAuthenticatedClientSessions(null);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return Objects.equals(that.getId(), this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

