/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapKeycloakTransaction;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.storage.SearchableModelField;

public class UserSessionConcurrentHashMapStorage<K>
extends ConcurrentHashMapStorage<K, MapUserSessionEntity, UserSessionModel> {
    private final ConcurrentHashMapStorage<K, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionStore;

    public UserSessionConcurrentHashMapStorage(ConcurrentHashMapStorage<K, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionStore, StringKeyConverter<K> keyConverter, DeepCloner cloner) {
        super(UserSessionModel.class, keyConverter, cloner);
        this.clientSessionStore = clientSessionStore;
    }

    @Override
    public MapKeycloakTransaction<MapUserSessionEntity, UserSessionModel> createTransaction(KeycloakSession session) {
        MapKeycloakTransaction<MapUserSessionEntity, UserSessionModel> sessionTransaction = (MapKeycloakTransaction<MapUserSessionEntity, UserSessionModel>)session.getAttribute("map-transaction-" + this.hashCode(), MapKeycloakTransaction.class);
        return sessionTransaction == null ? new Transaction(this.clientSessionStore.createTransaction(session), this.clientSessionStore.getKeyConverter(), this.cloner, this.fieldPredicates) : sessionTransaction;
    }

    private class Transaction
    extends ConcurrentHashMapKeycloakTransaction<K, MapUserSessionEntity, UserSessionModel> {
        private final MapKeycloakTransaction<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionTr;

        public Transaction(MapKeycloakTransaction<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionTr, StringKeyConverter<K> keyConverter, DeepCloner cloner, Map<SearchableModelField<? super UserSessionModel>, MapModelCriteriaBuilder.UpdatePredicatesFunc<K, MapUserSessionEntity, UserSessionModel>> fieldPredicates) {
            super(UserSessionConcurrentHashMapStorage.this, keyConverter, cloner, fieldPredicates);
            this.clientSessionTr = clientSessionTr;
        }

        @Override
        public long delete(QueryParameters<UserSessionModel> queryParameters) {
            Set ids = this.read(queryParameters).map(AbstractEntity::getId).collect(Collectors.toSet());
            ModelCriteriaBuilder csMcb = DefaultModelCriteria.criteria().compare(AuthenticatedClientSessionModel.SearchableFields.USER_SESSION_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{ids});
            this.clientSessionTr.delete(QueryParameters.withCriteria(csMcb));
            return super.delete(queryParameters);
        }

        @Override
        public boolean delete(String key) {
            ModelCriteriaBuilder csMcb = DefaultModelCriteria.criteria().compare(AuthenticatedClientSessionModel.SearchableFields.USER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{key});
            this.clientSessionTr.delete(QueryParameters.withCriteria(csMcb));
            return super.delete(key);
        }
    }
}

