/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.authorization.adapter.MapResourceServerAdapter;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.storage.StorageId;

public class MapResourceServerStore
implements ResourceServerStore {
    private static final Logger LOG = Logger.getLogger(MapResourceServerStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapResourceServerEntity, ResourceServer> tx;

    public MapResourceServerStore(KeycloakSession session, MapStorage<MapResourceServerEntity, ResourceServer> resourceServerStore, AuthorizationProvider provider) {
        this.tx = resourceServerStore.createTransaction(session);
        this.authorizationProvider = provider;
        session.getTransactionManager().enlist(this.tx);
    }

    private ResourceServer entityToAdapter(MapResourceServerEntity origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapResourceServerAdapter(origEntity, this.authorizationProvider.getStoreFactory());
    }

    public ResourceServer create(ClientModel client) {
        LOG.tracef("create(%s)%s", (Object)client.getClientId(), StackUtil.getShortStackTrace());
        String clientId = client.getId();
        if (clientId == null) {
            return null;
        }
        if (!StorageId.isLocalStorage((String)clientId)) {
            throw new ModelException("Creating resource server from federated ClientModel not supported");
        }
        if (this.findByClient(client) != null) {
            throw new ModelDuplicateException("Resource server assiciated with client : " + client.getClientId() + " already exists.");
        }
        MapResourceServerEntity entity = new MapResourceServerEntityImpl();
        entity.setId(clientId);
        entity = this.tx.create(entity);
        return this.entityToAdapter(entity);
    }

    public void delete(ClientModel client) {
        LOG.tracef("delete(%s, %s)%s", (Object)client.getClientId(), StackUtil.getShortStackTrace());
        ResourceServer resourceServer = this.findByClient(client);
        if (resourceServer == null) {
            return;
        }
        String id = resourceServer.getId();
        PolicyStore policyStore = this.authorizationProvider.getStoreFactory().getPolicyStore();
        policyStore.findByResourceServer(resourceServer).stream().map(Policy::getId).forEach(arg_0 -> ((PolicyStore)policyStore).delete(arg_0));
        PermissionTicketStore permissionTicketStore = this.authorizationProvider.getStoreFactory().getPermissionTicketStore();
        permissionTicketStore.findByResourceServer(resourceServer).stream().map(PermissionTicket::getId).forEach(arg_0 -> ((PermissionTicketStore)permissionTicketStore).delete(arg_0));
        ResourceStore resourceStore = this.authorizationProvider.getStoreFactory().getResourceStore();
        resourceStore.findByResourceServer(resourceServer).stream().map(Resource::getId).forEach(arg_0 -> ((ResourceStore)resourceStore).delete(arg_0));
        ScopeStore scopeStore = this.authorizationProvider.getStoreFactory().getScopeStore();
        scopeStore.findByResourceServer(resourceServer).stream().map(Scope::getId).forEach(arg_0 -> ((ScopeStore)scopeStore).delete(arg_0));
        this.tx.delete(id);
    }

    public ResourceServer findById(String id) {
        LOG.tracef("findById(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        MapResourceServerEntity entity = this.tx.read(id);
        return this.entityToAdapter(entity);
    }

    public ResourceServer findByClient(ClientModel client) {
        return this.findById(client.getId());
    }
}

