/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.component.ComponentModelScope;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntityImpl;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntityImpl;
import org.keycloak.models.map.authorization.entity.MapResourceEntityImpl;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntityImpl;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntityImpl;
import org.keycloak.models.map.client.MapClientEntityImpl;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;
import org.keycloak.models.map.clientscope.MapClientScopeEntityImpl;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.common.StringKeyConvertor;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.group.MapGroupEntityImpl;
import org.keycloak.models.map.role.MapRoleEntityImpl;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorageProvider;
import org.keycloak.models.map.storage.chm.UserSessionConcurrentHashMapStorage;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.user.MapUserConsentEntityImpl;
import org.keycloak.models.map.user.MapUserCredentialEntityImpl;
import org.keycloak.models.map.user.MapUserEntityImpl;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntityImpl;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class ConcurrentHashMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "concurrenthashmap";
    private static final Logger LOG = Logger.getLogger(ConcurrentHashMapStorageProviderFactory.class);
    private final ConcurrentHashMap<String, ConcurrentHashMapStorage<?, ?, ?>> storages = new ConcurrentHashMap();
    private final Map<String, StringKeyConvertor> keyConvertors = new HashMap<String, StringKeyConvertor>();
    private File storageDirectory;
    private String suffix;
    private StringKeyConvertor defaultKeyConvertor;
    private static final DeepCloner CLONER = new DeepCloner.Builder().genericCloner(Serialization::from).constructor(MapClientEntityImpl.class, MapClientEntityImpl::new).constructor(MapProtocolMapperEntity.class, MapProtocolMapperEntityImpl::new).constructor(MapGroupEntityImpl.class, MapGroupEntityImpl::new).constructor(MapRoleEntityImpl.class, MapRoleEntityImpl::new).constructor(MapUserEntityImpl.class, MapUserEntityImpl::new).constructor(MapUserCredentialEntityImpl.class, MapUserCredentialEntityImpl::new).constructor(MapUserFederatedIdentityEntityImpl.class, MapUserFederatedIdentityEntityImpl::new).constructor(MapUserConsentEntityImpl.class, MapUserConsentEntityImpl::new).constructor(MapClientScopeEntityImpl.class, MapClientScopeEntityImpl::new).constructor(MapResourceServerEntityImpl.class, MapResourceServerEntityImpl::new).constructor(MapResourceEntityImpl.class, MapResourceEntityImpl::new).constructor(MapScopeEntity.class, MapScopeEntityImpl::new).constructor(MapPolicyEntity.class, MapPolicyEntityImpl::new).constructor(MapPermissionTicketEntity.class, MapPermissionTicketEntityImpl::new).build();
    private static final Map<String, StringKeyConvertor> KEY_CONVERTORS = new HashMap<String, StringKeyConvertor>();

    public MapStorageProvider create(KeycloakSession session) {
        return new ConcurrentHashMapStorageProvider(this);
    }

    public void init(Config.Scope config) {
        this.suffix = config instanceof ComponentModelScope ? "-" + ((ComponentModelScope)config).getComponentId() : "";
        String keyType = config.get("keyType", "uuid");
        this.defaultKeyConvertor = this.getKeyConvertor(keyType);
        for (String name : ModelEntityUtil.getModelNames()) {
            this.keyConvertors.put(name, this.getKeyConvertor(config.get("keyType." + name, keyType)));
        }
        String dir = config.get("dir");
        try {
            if (dir == null || dir.trim().isEmpty()) {
                LOG.warn((Object)"No directory set, created objects will not survive server restart");
                this.storageDirectory = null;
            } else {
                File f = new File(dir);
                Files.createDirectories(f.toPath(), new FileAttribute[0]);
                if (f.exists()) {
                    this.storageDirectory = f;
                } else {
                    LOG.warnf("Directory cannot be used, created objects will not survive server restart: %s", (Object)dir);
                    this.storageDirectory = null;
                }
            }
        }
        catch (IOException ex) {
            LOG.warnf("Directory cannot be used, created objects will not survive server restart: %s", (Object)dir);
            this.storageDirectory = null;
        }
    }

    private StringKeyConvertor getKeyConvertor(String keyType) throws IllegalArgumentException {
        StringKeyConvertor res = KEY_CONVERTORS.get(keyType);
        if (res == null) {
            throw new IllegalArgumentException("Unknown key type: " + keyType);
        }
        return res;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.storages.forEach(this::storeMap);
    }

    private void storeMap(String mapName, ConcurrentHashMapStorage<?, ?, ?> store) {
        if (mapName != null) {
            File f = this.getFile(mapName);
            try {
                if (this.storageDirectory != null) {
                    LOG.debugf("Storing contents to %s", (Object)f.getCanonicalPath());
                    DefaultModelCriteria readAllCriteria = DefaultModelCriteria.criteria();
                    Serialization.MAPPER.writeValue(f, store.read(QueryParameters.withCriteria(readAllCriteria)));
                } else {
                    LOG.debugf("Not storing contents of %s because directory not set", (Object)mapName);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private <K, V extends AbstractEntity & UpdatableEntity, M> ConcurrentHashMapStorage<K, V, M> loadMap(final String mapName, Class<M> modelType, EnumSet<MapStorageProviderFactory.Flag> flags) {
        File f;
        ConcurrentHashMapStorage store;
        StringKeyConvertor kc = this.keyConvertors.getOrDefault(mapName, this.defaultKeyConvertor);
        Class valueType = ModelEntityUtil.getEntityType(modelType);
        LOG.debugf("Initializing new map storage: %s", (Object)mapName);
        if (modelType == UserSessionModel.class) {
            ConcurrentHashMapStorage<K, V, AuthenticatedClientSessionModel> clientSessionStore = this.getStorage(AuthenticatedClientSessionModel.class, new MapStorageProviderFactory.Flag[0]);
            store = new UserSessionConcurrentHashMapStorage(clientSessionStore, kc, CLONER){

                public String toString() {
                    return "ConcurrentHashMapStorage(" + mapName + ConcurrentHashMapStorageProviderFactory.this.suffix + ")";
                }
            };
        } else {
            store = new ConcurrentHashMapStorage(modelType, kc, CLONER){

                public String toString() {
                    return "ConcurrentHashMapStorage(" + mapName + ConcurrentHashMapStorageProviderFactory.this.suffix + ")";
                }
            };
        }
        if (!flags.contains((Object)MapStorageProviderFactory.Flag.INITIALIZE_EMPTY) && (f = this.getFile(mapName)) != null && f.exists()) {
            try {
                LOG.debugf("Restoring contents from %s", (Object)f.getCanonicalPath());
                Class valueImplType = CLONER.newInstanceType(valueType);
                if (valueImplType == null) {
                    valueImplType = valueType;
                }
                CollectionType type = Serialization.MAPPER.getTypeFactory().constructCollectionType(LinkedList.class, valueImplType);
                List values = (List)Serialization.MAPPER.readValue(f, (JavaType)type);
                values.forEach(mce -> store.create(mce));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return store;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public <K, V extends AbstractEntity & UpdatableEntity, M> ConcurrentHashMapStorage<K, V, M> getStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        EnumSet<MapStorageProviderFactory.Flag> f = flags == null || flags.length == 0 ? EnumSet.noneOf(MapStorageProviderFactory.Flag.class) : EnumSet.of(flags[0], flags);
        String name = ModelEntityUtil.getModelName(modelType, modelType.getSimpleName());
        if (modelType == UserSessionModel.class) {
            this.getStorage(AuthenticatedClientSessionModel.class, flags);
        }
        return this.storages.computeIfAbsent(name, n -> this.loadMap(name, modelType, f));
    }

    private File getFile(String fileName) {
        return this.storageDirectory == null ? null : new File(this.storageDirectory, "map-" + fileName + this.suffix + ".json");
    }

    public String getHelpText() {
        return "In-memory ConcurrentHashMap storage";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    static {
        KEY_CONVERTORS.put("uuid", StringKeyConvertor.UUIDKey.INSTANCE);
        KEY_CONVERTORS.put("string", StringKeyConvertor.StringKey.INSTANCE);
        KEY_CONVERTORS.put("ulong", StringKeyConvertor.ULongKey.INSTANCE);
    }
}

