/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ParConfig;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.map.realm.AbstractRealmModel;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.provider.ProviderEvent;

public class MapRealmAdapter
extends AbstractRealmModel<MapRealmEntity>
implements RealmModel {
    private static final Logger LOG = Logger.getLogger(MapRealmAdapter.class);
    private static final String ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN = "actionTokenGeneratedByUserLifespan";
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "defaultSignatureAlgorithm";
    private static final String BRUTE_FORCE_PROTECTED = "bruteForceProtected";
    private static final String PERMANENT_LOCKOUT = "permanentLockout";
    private static final String MAX_FAILURE_WAIT_SECONDS = "maxFailureWaitSeconds";
    private static final String WAIT_INCREMENT_SECONDS = "waitIncrementSeconds";
    private static final String QUICK_LOGIN_CHECK_MILLISECONDS = "quickLoginCheckMilliSeconds";
    private static final String MINIMUM_QUICK_LOGIN_WAIT_SECONDS = "minimumQuickLoginWaitSeconds";
    private static final String MAX_DELTA_SECONDS = "maxDeltaTimeSeconds";
    private static final String FAILURE_FACTOR = "failureFactor";
    private PasswordPolicy passwordPolicy;
    private static final String COMPONENT_PROVIDER_EXISTS_DISABLED = "component.provider.exists.disabled";

    public MapRealmAdapter(KeycloakSession session, MapRealmEntity entity) {
        super(session, entity);
    }

    public String getId() {
        return ((MapRealmEntity)this.entity).getId();
    }

    public String getName() {
        return ((MapRealmEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((MapRealmEntity)this.entity).setName(name);
    }

    public String getDisplayName() {
        return ((MapRealmEntity)this.entity).getDisplayName();
    }

    public void setDisplayName(String displayName) {
        ((MapRealmEntity)this.entity).setDisplayName(displayName);
    }

    public String getDisplayNameHtml() {
        return ((MapRealmEntity)this.entity).getDisplayNameHtml();
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        ((MapRealmEntity)this.entity).setDisplayNameHtml(displayNameHtml);
    }

    public boolean isEnabled() {
        return ((MapRealmEntity)this.entity).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setEnabled(enabled);
    }

    public SslRequired getSslRequired() {
        return ((MapRealmEntity)this.entity).getSslRequired() == null ? null : SslRequired.valueOf((String)((MapRealmEntity)this.entity).getSslRequired());
    }

    public void setSslRequired(SslRequired sslRequired) {
        ((MapRealmEntity)this.entity).setSslRequired(sslRequired.name());
    }

    public boolean isRegistrationAllowed() {
        return ((MapRealmEntity)this.entity).isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        ((MapRealmEntity)this.entity).setRegistrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        return ((MapRealmEntity)this.entity).isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        ((MapRealmEntity)this.entity).setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        return ((MapRealmEntity)this.entity).isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        ((MapRealmEntity)this.entity).setRememberMe(rememberMe);
    }

    public boolean isEditUsernameAllowed() {
        return ((MapRealmEntity)this.entity).isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        ((MapRealmEntity)this.entity).setEditUsernameAllowed(editUsernameAllowed);
    }

    public boolean isUserManagedAccessAllowed() {
        return ((MapRealmEntity)this.entity).isAllowUserManagedAccess();
    }

    public void setUserManagedAccessAllowed(boolean userManagedAccessAllowed) {
        ((MapRealmEntity)this.entity).setAllowUserManagedAccess(userManagedAccessAllowed);
    }

    public void setAttribute(String name, String value) {
        ((MapRealmEntity)this.entity).setAttribute(name, Collections.singletonList(value));
    }

    public void removeAttribute(String name) {
        ((MapRealmEntity)this.entity).removeAttribute(name);
    }

    public String getAttribute(String name) {
        List<String> attribute = ((MapRealmEntity)this.entity).getAttribute(name);
        if (attribute.isEmpty()) {
            return null;
        }
        return attribute.get(0);
    }

    public Map<String, String> getAttributes() {
        return ((MapRealmEntity)this.entity).getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (((List)entry.getValue()).isEmpty()) {
                return null;
            }
            if (((List)entry.getValue()).size() > 1) {
                LOG.warnf("Realm '%s' has attribute '%s' with %d values, retrieving only the first", (Object)this.getId(), entry.getKey(), (Object)((List)entry.getValue()).size());
            }
            return (String)((List)entry.getValue()).get(0);
        }));
    }

    public boolean isVerifyEmail() {
        return ((MapRealmEntity)this.entity).isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        ((MapRealmEntity)this.entity).setVerifyEmail(verifyEmail);
    }

    public boolean isLoginWithEmailAllowed() {
        return ((MapRealmEntity)this.entity).isLoginWithEmailAllowed();
    }

    public void setLoginWithEmailAllowed(boolean loginWithEmailAllowed) {
        ((MapRealmEntity)this.entity).setLoginWithEmailAllowed(loginWithEmailAllowed);
    }

    public boolean isDuplicateEmailsAllowed() {
        return ((MapRealmEntity)this.entity).isDuplicateEmailsAllowed();
    }

    public void setDuplicateEmailsAllowed(boolean duplicateEmailsAllowed) {
        ((MapRealmEntity)this.entity).setDuplicateEmailsAllowed(duplicateEmailsAllowed);
    }

    public boolean isResetPasswordAllowed() {
        return ((MapRealmEntity)this.entity).isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        ((MapRealmEntity)this.entity).setResetPasswordAllowed(resetPasswordAllowed);
    }

    public boolean isRevokeRefreshToken() {
        return ((MapRealmEntity)this.entity).isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        ((MapRealmEntity)this.entity).setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getRefreshTokenMaxReuse() {
        return ((MapRealmEntity)this.entity).getRefreshTokenMaxReuse();
    }

    public void setRefreshTokenMaxReuse(int revokeRefreshTokenCount) {
        ((MapRealmEntity)this.entity).setRefreshTokenMaxReuse(revokeRefreshTokenCount);
    }

    public int getSsoSessionIdleTimeout() {
        return ((MapRealmEntity)this.entity).getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return ((MapRealmEntity)this.entity).getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionMaxLifespan(seconds);
    }

    public int getSsoSessionIdleTimeoutRememberMe() {
        return ((MapRealmEntity)this.entity).getSsoSessionIdleTimeoutRememberMe();
    }

    public void setSsoSessionIdleTimeoutRememberMe(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionIdleTimeoutRememberMe(seconds);
    }

    public int getSsoSessionMaxLifespanRememberMe() {
        return ((MapRealmEntity)this.entity).getSsoSessionMaxLifespanRememberMe();
    }

    public void setSsoSessionMaxLifespanRememberMe(int seconds) {
        ((MapRealmEntity)this.entity).setSsoSessionMaxLifespanRememberMe(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        return ((MapRealmEntity)this.entity).getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setOfflineSessionIdleTimeout(seconds);
    }

    public int getAccessTokenLifespan() {
        return ((MapRealmEntity)this.entity).getAccessTokenLifespan();
    }

    public int getClientSessionIdleTimeout() {
        return ((MapRealmEntity)this.entity).getClientSessionIdleTimeout();
    }

    public void setClientSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setClientSessionIdleTimeout(seconds);
    }

    public int getClientSessionMaxLifespan() {
        return ((MapRealmEntity)this.entity).getClientSessionMaxLifespan();
    }

    public void setClientSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setClientSessionMaxLifespan(seconds);
    }

    public int getClientOfflineSessionIdleTimeout() {
        return ((MapRealmEntity)this.entity).getClientOfflineSessionIdleTimeout();
    }

    public void setClientOfflineSessionIdleTimeout(int seconds) {
        ((MapRealmEntity)this.entity).setClientOfflineSessionIdleTimeout(seconds);
    }

    public int getClientOfflineSessionMaxLifespan() {
        return ((MapRealmEntity)this.entity).getClientOfflineSessionMaxLifespan();
    }

    public void setClientOfflineSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setClientOfflineSessionMaxLifespan(seconds);
    }

    public void setAccessTokenLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setAccessTokenLifespan(seconds);
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return ((MapRealmEntity)this.entity).getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        ((MapRealmEntity)this.entity).setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getAccessCodeLifespan() {
        return ((MapRealmEntity)this.entity).getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setAccessCodeLifespan(seconds);
    }

    public int getAccessCodeLifespanUserAction() {
        return ((MapRealmEntity)this.entity).getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int seconds) {
        ((MapRealmEntity)this.entity).setAccessCodeLifespanUserAction(seconds);
    }

    public int getAccessCodeLifespanLogin() {
        return ((MapRealmEntity)this.entity).getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int seconds) {
        ((MapRealmEntity)this.entity).setAccessCodeLifespanLogin(seconds);
    }

    public int getActionTokenGeneratedByAdminLifespan() {
        return ((MapRealmEntity)this.entity).getActionTokenGeneratedByAdminLifespan();
    }

    public void setActionTokenGeneratedByAdminLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setActionTokenGeneratedByAdminLifespan(seconds);
    }

    public int getActionTokenGeneratedByUserLifespan() {
        return this.getAttribute(ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN, this.getAccessCodeLifespanUserAction());
    }

    public void setActionTokenGeneratedByUserLifespan(int seconds) {
        this.setAttribute(ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN, seconds);
    }

    public int getActionTokenGeneratedByUserLifespan(String actionTokenType) {
        return this.getAttribute("actionTokenGeneratedByUserLifespan." + actionTokenType, this.getAccessCodeLifespanUserAction());
    }

    public void setActionTokenGeneratedByUserLifespan(String actionTokenType, Integer seconds) {
        if (actionTokenType != null && !actionTokenType.isEmpty() && seconds != null) {
            this.setAttribute("actionTokenGeneratedByUserLifespan." + actionTokenType, seconds);
        }
    }

    public Map<String, Integer> getUserActionTokenLifespans() {
        Map<String, Integer> tokenLifespans = ((MapRealmEntity)this.entity).getAttributes().entrySet().stream().filter(Objects::nonNull).filter(entry -> Objects.nonNull(entry.getValue()) && !((List)entry.getValue()).isEmpty()).filter(entry -> ((String)entry.getKey()).startsWith("actionTokenGeneratedByUserLifespan.")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(ACTION_TOKEN_GENERATED_BY_USER_LIFESPAN.length() + 1), entry -> Integer.valueOf((String)((List)entry.getValue()).get(0))));
        return Collections.unmodifiableMap(tokenLifespans);
    }

    public Stream<RequiredCredentialModel> getRequiredCredentialsStream() {
        return ((MapRealmEntity)this.entity).getRequiredCredentials().map(MapRequiredCredentialEntity::toModel);
    }

    public void addRequiredCredential(String cred) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(cred);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + cred);
        }
        ((MapRealmEntity)this.entity).addRequiredCredential(MapRequiredCredentialEntity.fromModel(model));
    }

    public void updateRequiredCredentials(Set<String> credentials) {
        credentials.stream().map(RequiredCredentialModel.BUILT_IN::get).peek(c -> {
            if (c == null) {
                throw new RuntimeException("Unknown credential type " + c.getType());
            }
        }).map(MapRequiredCredentialEntity::fromModel).forEach(this::updateRequiredCredential);
    }

    private void updateRequiredCredential(MapRequiredCredentialEntity requiredCredential) {
        ((MapRealmEntity)this.entity).updateRequiredCredential(requiredCredential);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = PasswordPolicy.parse((KeycloakSession)this.session, (String)((MapRealmEntity)this.entity).getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        ((MapRealmEntity)this.entity).setPasswordPolicy(policy.toString());
    }

    public OTPPolicy getOTPPolicy() {
        return MapOTPPolicyEntity.toModel(((MapRealmEntity)this.entity).getOTPPolicy());
    }

    public void setOTPPolicy(OTPPolicy policy) {
        ((MapRealmEntity)this.entity).setOTPPolicy(MapOTPPolicyEntity.fromModel(policy));
    }

    public RoleModel getRoleById(String id) {
        return this.session.roles().getRoleById((RealmModel)this, id);
    }

    public Stream<GroupModel> getDefaultGroupsStream() {
        return ((MapRealmEntity)this.entity).getDefaultGroupIds().map(this::getGroupById);
    }

    public void addDefaultGroup(GroupModel group) {
        ((MapRealmEntity)this.entity).addDefaultGroup(group.getId());
    }

    public void removeDefaultGroup(GroupModel group) {
        ((MapRealmEntity)this.entity).removeDefaultGroup(group.getId());
    }

    public Stream<ClientModel> getClientsStream() {
        return this.session.clients().getClientsStream((RealmModel)this);
    }

    public Stream<ClientModel> getClientsStream(Integer firstResult, Integer maxResults) {
        return this.session.clients().getClientsStream((RealmModel)this, firstResult, maxResults);
    }

    public Long getClientsCount() {
        return this.session.clients().getClientsCount((RealmModel)this);
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream() {
        return this.session.clients().getAlwaysDisplayInConsoleClientsStream((RealmModel)this);
    }

    public ClientModel addClient(String name) {
        return this.session.clients().addClient((RealmModel)this, name);
    }

    public ClientModel addClient(String id, String clientId) {
        return this.session.clients().addClient((RealmModel)this, id, clientId);
    }

    public boolean removeClient(String id) {
        return this.session.clients().removeClient((RealmModel)this, id);
    }

    public ClientModel getClientById(String id) {
        return this.session.clients().getClientById((RealmModel)this, id);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.session.clients().getClientByClientId((RealmModel)this, clientId);
    }

    public Stream<ClientModel> searchClientByClientIdStream(String clientId, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByClientIdStream((RealmModel)this, clientId, firstResult, maxResults);
    }

    public Stream<ClientModel> searchClientByAttributes(Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByAttributes((RealmModel)this, attributes, firstResult, maxResults);
    }

    public Map<String, String> getSmtpConfig() {
        return Collections.unmodifiableMap(((MapRealmEntity)this.entity).getSmtpConfig());
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        ((MapRealmEntity)this.entity).setSmtpConfig(smtpConfig);
    }

    public AuthenticationFlowModel getBrowserFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getBrowserFlow());
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setBrowserFlow(flow.getId());
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getRegistrationFlow());
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setRegistrationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getDirectGrantFlow());
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setDirectGrantFlow(flow.getId());
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getResetCredentialsFlow());
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setResetCredentialsFlow(flow.getId());
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getClientAuthenticationFlow());
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setClientAuthenticationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDockerAuthenticationFlow() {
        return this.getAuthenticationFlowById(((MapRealmEntity)this.entity).getDockerAuthenticationFlow());
    }

    public void setDockerAuthenticationFlow(AuthenticationFlowModel flow) {
        ((MapRealmEntity)this.entity).setDockerAuthenticationFlow(flow.getId());
    }

    public Stream<AuthenticationFlowModel> getAuthenticationFlowsStream() {
        return ((MapRealmEntity)this.entity).getAuthenticationFlows().map(MapAuthenticationFlowEntity::toModel);
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        return ((MapRealmEntity)this.entity).getAuthenticationFlows().filter(flow -> Objects.equals(flow.getAlias(), alias)).findFirst().map(MapAuthenticationFlowEntity::toModel).orElse(null);
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        MapAuthenticationFlowEntity authenticationFlowEntity = MapAuthenticationFlowEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addAuthenticationFlow(authenticationFlowEntity);
        model.setId(authenticationFlowEntity.getId());
        return model;
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String flowId) {
        if (flowId == null) {
            return null;
        }
        return MapAuthenticationFlowEntity.toModel(((MapRealmEntity)this.entity).getAuthenticationFlow(flowId));
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        ((MapRealmEntity)this.entity).removeAuthenticationFlow(model.getId());
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        ((MapRealmEntity)this.entity).updateAuthenticationFlow(MapAuthenticationFlowEntity.fromModel(model));
    }

    public Stream<AuthenticationExecutionModel> getAuthenticationExecutionsStream(String flowId) {
        return ((MapRealmEntity)this.entity).getAuthenticationExecutions().filter(execution -> Objects.equals(flowId, execution.getParentFlowId())).map(MapAuthenticationExecutionEntity::toModel).sorted((Comparator<AuthenticationExecutionModel>)AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        if (id == null) {
            return null;
        }
        return MapAuthenticationExecutionEntity.toModel(((MapRealmEntity)this.entity).getAuthenticationExecution(id));
    }

    public AuthenticationExecutionModel getAuthenticationExecutionByFlowId(String flowId) {
        return ((MapRealmEntity)this.entity).getAuthenticationExecutions().filter(execution -> Objects.equals(flowId, execution.getFlowId())).findAny().map(MapAuthenticationExecutionEntity::toModel).orElse(null);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        MapAuthenticationExecutionEntity executionEntity = MapAuthenticationExecutionEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addAuthenticatonExecution(executionEntity);
        model.setId(executionEntity.getId());
        return model;
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        ((MapRealmEntity)this.entity).updateAuthenticatonExecution(MapAuthenticationExecutionEntity.fromModel(model));
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        ((MapRealmEntity)this.entity).removeAuthenticatonExecution(model.getId());
    }

    public Stream<AuthenticatorConfigModel> getAuthenticatorConfigsStream() {
        return ((MapRealmEntity)this.entity).getAuthenticatorConfigs().map(MapAuthenticatorConfigEntity::toModel);
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        MapAuthenticatorConfigEntity authenticatorConfig = MapAuthenticatorConfigEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addAuthenticatorConfig(authenticatorConfig);
        model.setId(authenticatorConfig.getId());
        return model;
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        ((MapRealmEntity)this.entity).updateAuthenticatorConfig(MapAuthenticatorConfigEntity.fromModel(model));
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        ((MapRealmEntity)this.entity).removeAuthenticatorConfig(model.getId());
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        if (id == null) {
            return null;
        }
        return MapAuthenticatorConfigEntity.toModel(((MapRealmEntity)this.entity).getAuthenticatorConfig(id));
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        return ((MapRealmEntity)this.entity).getAuthenticatorConfigs().filter(config -> Objects.equals(config.getAlias(), alias)).findFirst().map(MapAuthenticatorConfigEntity::toModel).orElse(null);
    }

    public Stream<RequiredActionProviderModel> getRequiredActionProvidersStream() {
        return ((MapRealmEntity)this.entity).getRequiredActionProviders().map(MapRequiredActionProviderEntity::toModel).sorted((Comparator<RequiredActionProviderModel>)RequiredActionProviderModel.RequiredActionComparator.SINGLETON);
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        MapRequiredActionProviderEntity requiredActionProvider = MapRequiredActionProviderEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addRequiredActionProvider(requiredActionProvider);
        model.setId(requiredActionProvider.getId());
        return model;
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        ((MapRealmEntity)this.entity).updateRequiredActionProvider(MapRequiredActionProviderEntity.fromModel(model));
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        ((MapRealmEntity)this.entity).removeRequiredActionProvider(model.getId());
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        if (id == null) {
            return null;
        }
        return MapRequiredActionProviderEntity.toModel(((MapRealmEntity)this.entity).getRequiredActionProvider(id));
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        return ((MapRealmEntity)this.entity).getRequiredActionProviders().filter(actionProvider -> Objects.equals(actionProvider.getAlias(), alias)).findFirst().map(MapRequiredActionProviderEntity::toModel).orElse(null);
    }

    public Stream<IdentityProviderModel> getIdentityProvidersStream() {
        return ((MapRealmEntity)this.entity).getIdentityProviders().map(MapIdentityProviderEntity::toModel);
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        return ((MapRealmEntity)this.entity).getIdentityProviders().filter(identityProvider -> Objects.equals(identityProvider.getAlias(), alias)).findFirst().map(MapIdentityProviderEntity::toModel).orElse(null);
    }

    public void addIdentityProvider(IdentityProviderModel model) {
        ((MapRealmEntity)this.entity).addIdentityProvider(MapIdentityProviderEntity.fromModel(model));
    }

    public void removeIdentityProviderByAlias(String alias) {
        final IdentityProviderModel model = this.getIdentityProviderByAlias(alias);
        ((MapRealmEntity)this.entity).removeIdentityProvider(model.getInternalId());
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.IdentityProviderRemovedEvent(){

            public RealmModel getRealm() {
                return MapRealmAdapter.this;
            }

            public IdentityProviderModel getRemovedIdentityProvider() {
                return model;
            }

            public KeycloakSession getKeycloakSession() {
                return MapRealmAdapter.this.session;
            }
        });
    }

    public void updateIdentityProvider(final IdentityProviderModel identityProvider) {
        ((MapRealmEntity)this.entity).updateIdentityProvider(MapIdentityProviderEntity.fromModel(identityProvider));
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.IdentityProviderUpdatedEvent(){

            public RealmModel getRealm() {
                return MapRealmAdapter.this;
            }

            public IdentityProviderModel getUpdatedIdentityProvider() {
                return identityProvider;
            }

            public KeycloakSession getKeycloakSession() {
                return MapRealmAdapter.this.session;
            }
        });
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersStream() {
        return ((MapRealmEntity)this.entity).getIdentityProviderMappers().map(MapIdentityProviderMapperEntity::toModel);
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersByAliasStream(String brokerAlias) {
        return ((MapRealmEntity)this.entity).getIdentityProviderMappers().filter(mapper -> Objects.equals(mapper.getIdentityProviderAlias(), brokerAlias)).map(MapIdentityProviderMapperEntity::toModel);
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        MapIdentityProviderMapperEntity identityProviderMapper = MapIdentityProviderMapperEntity.fromModel(model);
        ((MapRealmEntity)this.entity).addIdentityProviderMapper(identityProviderMapper);
        model.setId(identityProviderMapper.getId());
        return model;
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel model) {
        ((MapRealmEntity)this.entity).removeIdentityProviderMapper(model.getId());
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel model) {
        ((MapRealmEntity)this.entity).updateIdentityProviderMapper(MapIdentityProviderMapperEntity.fromModel(model));
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        if (id == null) {
            return null;
        }
        return MapIdentityProviderMapperEntity.toModel(((MapRealmEntity)this.entity).getIdentityProviderMapper(id));
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String brokerAlias, String name) {
        return ((MapRealmEntity)this.entity).getIdentityProviderMappers().filter(identityProviderMapper -> Objects.equals(identityProviderMapper.getIdentityProviderAlias(), brokerAlias) && Objects.equals(identityProviderMapper.getName(), name)).findFirst().map(MapIdentityProviderMapperEntity::toModel).orElse(null);
    }

    public ComponentModel addComponentModel(ComponentModel model) {
        model = this.importComponentModel(model);
        ComponentUtil.notifyCreated((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)model);
        return model;
    }

    public ComponentModel importComponentModel(ComponentModel model) {
        block4: {
            try {
                ComponentFactory componentFactory = ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)model);
                if (componentFactory == null && System.getProperty(COMPONENT_PROVIDER_EXISTS_DISABLED) == null) {
                    throw new IllegalArgumentException("Invalid component type");
                }
                componentFactory.validateConfiguration(this.session, (RealmModel)this, model);
            }
            catch (IllegalArgumentException | ComponentValidationException e) {
                if (System.getProperty(COMPONENT_PROVIDER_EXISTS_DISABLED) != null) break block4;
                throw e;
            }
        }
        MapComponentEntity component = MapComponentEntity.fromModel(model);
        if (model.getParentId() == null) {
            component.setParentId(this.getId());
            model.setParentId(this.getId());
        }
        ((MapRealmEntity)this.entity).addComponent(component);
        model.setId(component.getId());
        return model;
    }

    public void updateComponent(ComponentModel component) {
        ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)component).validateConfiguration(this.session, (RealmModel)this, component);
        MapComponentEntity old = ((MapRealmEntity)this.entity).getComponent(component.getId());
        if (old == null) {
            return;
        }
        ((MapRealmEntity)this.entity).updateComponent(MapComponentEntity.fromModel(component));
        ComponentUtil.notifyUpdated((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)MapComponentEntity.toModel(old), (ComponentModel)component);
    }

    public void removeComponent(ComponentModel component) {
        if (((MapRealmEntity)this.entity).getComponent(component.getId()) == null) {
            return;
        }
        this.session.users().preRemove((RealmModel)this, component);
        ComponentUtil.notifyPreRemove((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)component);
        this.removeComponents(component.getId());
        ((MapRealmEntity)this.entity).removeComponent(component.getId());
    }

    public void removeComponents(String parentId) {
        ((MapRealmEntity)this.entity).getComponents().filter(c -> Objects.equals(parentId, c.getParentId())).map(MapComponentEntity::toModel).collect(Collectors.toSet()).forEach(c -> {
            this.session.users().preRemove((RealmModel)this, c);
            ComponentUtil.notifyPreRemove((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)c);
            ((MapRealmEntity)this.entity).removeComponent(c.getId());
        });
    }

    public Stream<ComponentModel> getComponentsStream() {
        return ((MapRealmEntity)this.entity).getComponents().map(MapComponentEntity::toModel);
    }

    public Stream<ComponentModel> getComponentsStream(String parentId) {
        return ((MapRealmEntity)this.entity).getComponents().filter(c -> Objects.equals(parentId, c.getParentId())).map(MapComponentEntity::toModel);
    }

    public Stream<ComponentModel> getComponentsStream(String parentId, String providerType) {
        return ((MapRealmEntity)this.entity).getComponents().filter(c -> Objects.equals(parentId, c.getParentId())).filter(c -> Objects.equals(providerType, c.getProviderType())).map(MapComponentEntity::toModel);
    }

    public ComponentModel getComponent(String id) {
        return MapComponentEntity.toModel(((MapRealmEntity)this.entity).getComponent(id));
    }

    public String getLoginTheme() {
        return ((MapRealmEntity)this.entity).getLoginTheme();
    }

    public void setLoginTheme(String name) {
        ((MapRealmEntity)this.entity).setLoginTheme(name);
    }

    public String getAccountTheme() {
        return ((MapRealmEntity)this.entity).getAccountTheme();
    }

    public void setAccountTheme(String name) {
        ((MapRealmEntity)this.entity).setAccountTheme(name);
    }

    public String getAdminTheme() {
        return ((MapRealmEntity)this.entity).getAdminTheme();
    }

    public void setAdminTheme(String name) {
        ((MapRealmEntity)this.entity).setAdminTheme(name);
    }

    public String getEmailTheme() {
        return ((MapRealmEntity)this.entity).getEmailTheme();
    }

    public void setEmailTheme(String name) {
        ((MapRealmEntity)this.entity).setEmailTheme(name);
    }

    public int getNotBefore() {
        return ((MapRealmEntity)this.entity).getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        ((MapRealmEntity)this.entity).setNotBefore(notBefore);
    }

    public boolean isEventsEnabled() {
        return ((MapRealmEntity)this.entity).isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        return ((MapRealmEntity)this.entity).getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        ((MapRealmEntity)this.entity).setEventsExpiration(expiration);
    }

    public Stream<String> getEventsListenersStream() {
        return ((MapRealmEntity)this.entity).getEventsListeners().stream();
    }

    public void setEventsListeners(Set<String> listeners) {
        ((MapRealmEntity)this.entity).setEventsListeners(listeners);
    }

    public Stream<String> getEnabledEventTypesStream() {
        return ((MapRealmEntity)this.entity).getEnabledEventTypes().stream();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        ((MapRealmEntity)this.entity).setEnabledEventTypes(enabledEventTypes);
    }

    public boolean isAdminEventsEnabled() {
        return ((MapRealmEntity)this.entity).isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setAdminEventsEnabled(enabled);
    }

    public boolean isAdminEventsDetailsEnabled() {
        return ((MapRealmEntity)this.entity).isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setAdminEventsDetailsEnabled(enabled);
    }

    public ClientModel getMasterAdminClient() {
        String masterAdminClientId = ((MapRealmEntity)this.entity).getMasterAdminClient();
        if (masterAdminClientId == null) {
            return null;
        }
        MapRealmAdapter masterRealm = this.getName().equals(Config.getAdminRealm()) ? this : this.session.realms().getRealm(Config.getAdminRealm());
        return this.session.clients().getClientById((RealmModel)masterRealm, masterAdminClientId);
    }

    public void setMasterAdminClient(ClientModel client) {
        String id = client == null ? null : client.getId();
        ((MapRealmEntity)this.entity).setMasterAdminClient(id);
    }

    public RoleModel getDefaultRole() {
        return this.session.roles().getRoleById((RealmModel)this, ((MapRealmEntity)this.entity).getDefaultRoleId());
    }

    public void setDefaultRole(RoleModel role) {
        ((MapRealmEntity)this.entity).setDefaultRoleId(role.getId());
    }

    public boolean isIdentityFederationEnabled() {
        return ((MapRealmEntity)this.entity).getIdentityProviders().findFirst().isPresent();
    }

    public boolean isInternationalizationEnabled() {
        return ((MapRealmEntity)this.entity).isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        ((MapRealmEntity)this.entity).setInternationalizationEnabled(enabled);
    }

    public Stream<String> getSupportedLocalesStream() {
        return ((MapRealmEntity)this.entity).getSupportedLocales().stream();
    }

    public void setSupportedLocales(Set<String> locales) {
        ((MapRealmEntity)this.entity).setSupportedLocales(locales);
    }

    public String getDefaultLocale() {
        return ((MapRealmEntity)this.entity).getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        ((MapRealmEntity)this.entity).setDefaultLocale(locale);
    }

    public GroupModel createGroup(String id, String name, GroupModel toParent) {
        return this.session.groups().createGroup((RealmModel)this, id, name, toParent);
    }

    public GroupModel getGroupById(String id) {
        return this.session.groups().getGroupById((RealmModel)this, id);
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.session.groups().getGroupsStream((RealmModel)this);
    }

    public Long getGroupsCount(Boolean onlyTopGroups) {
        return this.session.groups().getGroupsCount((RealmModel)this, onlyTopGroups);
    }

    public Long getGroupsCountByNameContaining(String search) {
        return this.session.groups().getGroupsCountByNameContaining((RealmModel)this, search);
    }

    public Stream<GroupModel> getTopLevelGroupsStream() {
        return this.session.groups().getTopLevelGroupsStream((RealmModel)this);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(Integer first, Integer max) {
        return this.session.groups().getTopLevelGroupsStream((RealmModel)this, first, max);
    }

    public Stream<GroupModel> searchForGroupByNameStream(String search, Integer first, Integer max) {
        return this.session.groups().searchForGroupByNameStream((RealmModel)this, search, first, max);
    }

    public boolean removeGroup(GroupModel group) {
        return this.session.groups().removeGroup((RealmModel)this, group);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.session.groups().moveGroup((RealmModel)this, group, toParent);
    }

    public Stream<ClientScopeModel> getClientScopesStream() {
        return this.session.clientScopes().getClientScopesStream((RealmModel)this);
    }

    public ClientScopeModel addClientScope(String name) {
        return this.session.clientScopes().addClientScope((RealmModel)this, name);
    }

    public ClientScopeModel addClientScope(String id, String name) {
        return this.session.clientScopes().addClientScope((RealmModel)this, id, name);
    }

    public boolean removeClientScope(String id) {
        return this.session.clientScopes().removeClientScope((RealmModel)this, id);
    }

    public ClientScopeModel getClientScopeById(String id) {
        return this.session.clientScopes().getClientScopeById((RealmModel)this, id);
    }

    public void addDefaultClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        if (defaultScope) {
            ((MapRealmEntity)this.entity).addDefaultClientScope(clientScope.getId());
        } else {
            ((MapRealmEntity)this.entity).addOptionalClientScope(clientScope.getId());
        }
    }

    public void removeDefaultClientScope(ClientScopeModel clientScope) {
        ((MapRealmEntity)this.entity).removeDefaultOrOptionalClientScope(clientScope.getId());
    }

    public Stream<ClientScopeModel> getDefaultClientScopesStream(boolean defaultScope) {
        if (defaultScope) {
            return ((MapRealmEntity)this.entity).getDefaultClientScopeIds().map(this::getClientScopeById);
        }
        return ((MapRealmEntity)this.entity).getOptionalClientScopeIds().map(this::getClientScopeById);
    }

    public void createOrUpdateRealmLocalizationTexts(String locale, Map<String, String> localizationTexts) {
        Map<String, Map<String, String>> realmLocalizationTexts = ((MapRealmEntity)this.entity).getLocalizationTexts();
        if (realmLocalizationTexts.containsKey(locale)) {
            Map<String, String> currentTexts = realmLocalizationTexts.get(locale);
            currentTexts.putAll(localizationTexts);
            ((MapRealmEntity)this.entity).updateLocalizationTexts(locale, currentTexts);
        } else {
            ((MapRealmEntity)this.entity).addLocalizationTexts(locale, localizationTexts);
        }
    }

    public boolean removeRealmLocalizationTexts(String locale) {
        if (locale == null) {
            return false;
        }
        return ((MapRealmEntity)this.entity).removeLocalizationTexts(locale);
    }

    public Map<String, Map<String, String>> getRealmLocalizationTexts() {
        return ((MapRealmEntity)this.entity).getLocalizationTexts();
    }

    public Map<String, String> getRealmLocalizationTextsByLocale(String locale) {
        return ((MapRealmEntity)this.entity).getLocalizationText(locale);
    }

    public RoleModel getRole(String name) {
        return this.session.roles().getRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.roles().addRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.roles().addRealmRole((RealmModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.session.roles().removeRole(role);
    }

    public Stream<RoleModel> getRolesStream() {
        return this.session.roles().getRealmRolesStream((RealmModel)this);
    }

    public Stream<RoleModel> getRolesStream(Integer firstResult, Integer maxResults) {
        return this.session.roles().getRealmRolesStream((RealmModel)this, firstResult, maxResults);
    }

    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.session.roles().searchForRolesStream((RealmModel)this, search, first, max);
    }

    @Deprecated
    public Stream<String> getDefaultRolesStream() {
        return this.getDefaultRole().getCompositesStream().filter(this::isRealmRole).map(RoleModel::getName);
    }

    private boolean isRealmRole(RoleModel role) {
        return !role.isClientRole();
    }

    @Deprecated
    public void addDefaultRole(String name) {
        this.getDefaultRole().addCompositeRole(this.getOrAddRoleId(name));
    }

    private RoleModel getOrAddRoleId(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        return role;
    }

    @Deprecated
    public void removeDefaultRoles(String ... defaultRoles) {
        for (String defaultRole : defaultRoles) {
            this.getDefaultRole().removeCompositeRole(this.getRole(defaultRole));
        }
    }

    public boolean isBruteForceProtected() {
        return this.getAttribute(BRUTE_FORCE_PROTECTED, false);
    }

    public void setBruteForceProtected(boolean value) {
        this.setAttribute(BRUTE_FORCE_PROTECTED, value);
    }

    public boolean isPermanentLockout() {
        return this.getAttribute(PERMANENT_LOCKOUT, false);
    }

    public void setPermanentLockout(boolean val) {
        this.setAttribute(PERMANENT_LOCKOUT, val);
    }

    public int getMaxFailureWaitSeconds() {
        return this.getAttribute(MAX_FAILURE_WAIT_SECONDS, 0);
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.setAttribute(MAX_FAILURE_WAIT_SECONDS, val);
    }

    public int getWaitIncrementSeconds() {
        return this.getAttribute(WAIT_INCREMENT_SECONDS, 0);
    }

    public void setWaitIncrementSeconds(int val) {
        this.setAttribute(WAIT_INCREMENT_SECONDS, val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.getAttribute(MINIMUM_QUICK_LOGIN_WAIT_SECONDS, 0);
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.setAttribute(MINIMUM_QUICK_LOGIN_WAIT_SECONDS, val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.getAttribute(QUICK_LOGIN_CHECK_MILLISECONDS, 0L);
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.setAttribute(QUICK_LOGIN_CHECK_MILLISECONDS, val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.getAttribute(MAX_DELTA_SECONDS, 0);
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.setAttribute(MAX_DELTA_SECONDS, val);
    }

    public int getFailureFactor() {
        return this.getAttribute(FAILURE_FACTOR, 0);
    }

    public void setFailureFactor(int failureFactor) {
        this.setAttribute(FAILURE_FACTOR, failureFactor);
    }

    public String getDefaultSignatureAlgorithm() {
        return this.getAttribute(DEFAULT_SIGNATURE_ALGORITHM);
    }

    public void setDefaultSignatureAlgorithm(String defaultSignatureAlgorithm) {
        this.setAttribute(DEFAULT_SIGNATURE_ALGORITHM, defaultSignatureAlgorithm);
    }

    public boolean isOfflineSessionMaxLifespanEnabled() {
        return ((MapRealmEntity)this.entity).isOfflineSessionMaxLifespanEnabled();
    }

    public void setOfflineSessionMaxLifespanEnabled(boolean offlineSessionMaxLifespanEnabled) {
        ((MapRealmEntity)this.entity).setOfflineSessionMaxLifespanEnabled(offlineSessionMaxLifespanEnabled);
    }

    public int getOfflineSessionMaxLifespan() {
        return ((MapRealmEntity)this.entity).getOfflineSessionMaxLifespan();
    }

    public void setOfflineSessionMaxLifespan(int seconds) {
        ((MapRealmEntity)this.entity).setOfflineSessionMaxLifespan(seconds);
    }

    public WebAuthnPolicy getWebAuthnPolicy() {
        return MapWebAuthnPolicyEntity.toModel(((MapRealmEntity)this.entity).getWebAuthnPolicy());
    }

    public void setWebAuthnPolicy(WebAuthnPolicy policy) {
        ((MapRealmEntity)this.entity).setWebAuthnPolicy(MapWebAuthnPolicyEntity.fromModel(policy));
    }

    public WebAuthnPolicy getWebAuthnPolicyPasswordless() {
        return MapWebAuthnPolicyEntity.toModel(((MapRealmEntity)this.entity).getWebAuthnPolicyPasswordless());
    }

    public void setWebAuthnPolicyPasswordless(WebAuthnPolicy policy) {
        ((MapRealmEntity)this.entity).setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity.fromModel(policy));
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return Collections.unmodifiableMap(((MapRealmEntity)this.entity).getBrowserSecurityHeaders());
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        ((MapRealmEntity)this.entity).setBrowserSecurityHeaders(headers);
    }

    public ClientInitialAccessModel createClientInitialAccessModel(int expiration, int count) {
        MapClientInitialAccessEntity clientInitialAccess = MapClientInitialAccessEntity.createEntity(expiration, count);
        ((MapRealmEntity)this.entity).addClientInitialAccess(clientInitialAccess);
        return MapClientInitialAccessEntity.toModel(clientInitialAccess);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(String id) {
        return MapClientInitialAccessEntity.toModel(((MapRealmEntity)this.entity).getClientInitialAccess(id));
    }

    public void removeClientInitialAccessModel(String id) {
        ((MapRealmEntity)this.entity).removeClientInitialAccess(id);
    }

    public Stream<ClientInitialAccessModel> getClientInitialAccesses() {
        return ((MapRealmEntity)this.entity).getClientInitialAccesses().stream().map(MapClientInitialAccessEntity::toModel);
    }

    public void decreaseRemainingCount(ClientInitialAccessModel model) {
        MapClientInitialAccessEntity clientInitialAccess = ((MapRealmEntity)this.entity).getClientInitialAccess(model.getId());
        clientInitialAccess.setRemainingCount(model.getRemainingCount() - 1);
        ((MapRealmEntity)this.entity).updateClientInitialAccess(clientInitialAccess);
    }

    public OAuth2DeviceConfig getOAuth2DeviceConfig() {
        return new OAuth2DeviceConfig((RealmModel)this);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }

    public CibaConfig getCibaPolicy() {
        return new CibaConfig((RealmModel)this);
    }

    public ParConfig getParPolicy() {
        return new ParConfig((RealmModel)this);
    }
}

