/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.common.DeepCloner;

public class MapClientScopeEntityImpl
extends MapClientScopeEntity.AbstractClientScopeEntity
implements MapClientScopeEntity {
    private final DeepCloner cloner;
    private String fId;
    private Map<String, List<String>> fAttributes;
    private String fDescription;
    private String fName;
    private String fProtocol;
    private Set<MapProtocolMapperEntity> fProtocolMappers;
    private String fRealmId;
    private Collection<String> fScopeMappings;

    public MapClientScopeEntityImpl() {
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public MapClientScopeEntityImpl(DeepCloner cloner) {
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapClientScopeEntityImpl)) {
            return false;
        }
        MapClientScopeEntityImpl other = (MapClientScopeEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getProtocol(), other.getProtocol()) && Objects.equals(this.getProtocolMappers(), other.getProtocolMappers()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getScopeMappings(), other.getScopeMappings());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public <V> V deepClone(V obj) {
        return this.cloner.from(obj);
    }

    @Override
    public void setAttribute(String p0, List<String> p1) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, List<String>>();
        }
        p1 = p1 == null ? null : new LinkedList(p1);
        LinkedList v = this.fAttributes.put(p0, p1);
        this.updated |= !Objects.equals(v, p1);
    }

    @Override
    public void removeAttribute(String p0) {
        if (this.fAttributes == null) {
            return;
        }
        boolean removed = this.fAttributes.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public void setAttributes(Map<String, List<String>> p0) {
        p0 = p0 == null ? null : (Map)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        this.updated |= !Objects.equals(this.fAttributes, p0);
        this.fAttributes = p0;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.fAttributes;
    }

    @Override
    public List<String> getAttribute(String p0) {
        return this.fAttributes == null ? null : this.fAttributes.get(p0);
    }

    @Override
    public void setDescription(String p0) {
        this.updated |= !Objects.equals(this.fDescription, p0);
        this.fDescription = p0;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void setName(String p0) {
        this.updated |= !Objects.equals(this.fName, p0);
        this.fName = p0;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getProtocol() {
        return this.fProtocol;
    }

    @Override
    public void setProtocol(String p0) {
        this.updated |= !Objects.equals(this.fProtocol, p0);
        this.fProtocol = p0;
    }

    @Override
    public Set<MapProtocolMapperEntity> getProtocolMappers() {
        return this.fProtocolMappers;
    }

    @Override
    public void addProtocolMapper(MapProtocolMapperEntity p0) {
        if (this.fProtocolMappers == null) {
            this.fProtocolMappers = new HashSet<MapProtocolMapperEntity>();
        }
        p0 = this.deepClone(p0);
        this.updated |= this.fProtocolMappers.add(p0);
    }

    @Override
    public void setRealmId(String p0) {
        this.updated |= !Objects.equals(this.fRealmId, p0);
        this.fRealmId = p0;
    }

    @Override
    public String getRealmId() {
        return this.fRealmId;
    }

    @Override
    public void addScopeMapping(String p0) {
        if (this.fScopeMappings == null) {
            this.fScopeMappings = new LinkedList<String>();
        }
        this.fScopeMappings.add(p0);
        this.updated = true;
    }

    @Override
    public Collection<String> getScopeMappings() {
        return this.fScopeMappings;
    }

    @Override
    public void removeScopeMapping(String p0) {
        if (this.fScopeMappings == null) {
            return;
        }
        boolean removed = this.fScopeMappings.remove(p0);
        this.updated |= removed;
    }

    public static class Empty
    extends MapClientScopeEntity.AbstractClientScopeEntity
    implements MapClientScopeEntity {
        public static final Empty INSTANCE = new Empty();

        @Override
        public void setId(String id) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public void setAttribute(String name, List<String> value) {
        }

        @Override
        public void removeAttribute(String name) {
        }

        @Override
        public void setAttributes(Map<String, List<String>> attributes) {
        }

        @Override
        public Map<String, List<String>> getAttributes() {
            return null;
        }

        @Override
        public List<String> getAttribute(String name) {
            return null;
        }

        @Override
        public void setDescription(String description) {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public void setProtocol(String protocol) {
        }

        @Override
        public void removeProtocolMapper(String id) {
        }

        @Override
        public Set<MapProtocolMapperEntity> getProtocolMappers() {
            return null;
        }

        @Override
        public void addProtocolMapper(MapProtocolMapperEntity mapping) {
        }

        @Override
        public Optional<MapProtocolMapperEntity> getProtocolMapper(String id) {
            return null;
        }

        @Override
        public void setRealmId(String realmId) {
        }

        @Override
        public String getRealmId() {
            return null;
        }

        @Override
        public void addScopeMapping(String id) {
        }

        @Override
        public Collection<String> getScopeMappings() {
            return null;
        }

        @Override
        public void removeScopeMapping(String id) {
        }

        @Override
        public boolean isUpdated() {
            return false;
        }
    }
}

