/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.EntityWithAttributes;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.user.UserConsentEntity;
import org.keycloak.models.map.user.UserCredentialEntity;
import org.keycloak.models.map.user.UserFederatedIdentityEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapUserEntity
extends UpdatableEntity.Impl
implements AbstractEntity,
EntityWithAttributes {
    private String id;
    private String realmId;
    private String username;
    private String firstName;
    private Long createdTimestamp;
    private String lastName;
    private String email;
    private boolean enabled;
    private boolean emailVerified;
    private String emailConstraint = KeycloakModelUtils.generateId();
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private Set<String> requiredActions = new HashSet<String>();
    private final Map<String, UserCredentialEntity> credentials = new HashMap<String, UserCredentialEntity>();
    private final List<String> credentialsOrder = new LinkedList<String>();
    private final Map<String, UserFederatedIdentityEntity> federatedIdentities = new HashMap<String, UserFederatedIdentityEntity>();
    private final Map<String, UserConsentEntity> userConsents = new HashMap<String, UserConsentEntity>();
    private Set<String> groupsMembership = new HashSet<String>();
    private Set<String> rolesMembership = new HashSet<String>();
    private String federationLink;
    private String serviceAccountClientLink;
    private int notBefore;

    public MapUserEntity() {
    }

    public MapUserEntity(String id, String realmId) {
        this.id = id;
        this.realmId = realmId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Id cannot be changed");
        }
        this.id = id;
        this.updated |= id != null;
    }

    @Override
    public boolean isUpdated() {
        return this.updated || this.userConsents.values().stream().anyMatch(UpdatableEntity.Impl::isUpdated) || this.credentials.values().stream().anyMatch(UpdatableEntity.Impl::isUpdated) || this.federatedIdentities.values().stream().anyMatch(UpdatableEntity.Impl::isUpdated);
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.updated |= !Objects.equals(this.realmId, realmId);
        this.realmId = realmId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.updated |= !Objects.equals(this.username, username);
        this.username = username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.updated |= !Objects.equals(this.firstName, firstName);
        this.firstName = firstName;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Long createdTimestamp) {
        this.updated |= !Objects.equals(this.createdTimestamp, createdTimestamp);
        this.createdTimestamp = createdTimestamp;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.updated |= !Objects.equals(this.lastName, lastName);
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email, boolean duplicateEmailsAllowed) {
        this.updated |= !Objects.equals(this.email, email);
        this.email = email;
        this.emailConstraint = email == null || duplicateEmailsAllowed ? KeycloakModelUtils.generateId() : email;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.updated |= !Objects.equals(this.enabled, enabled);
        this.enabled = enabled;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.updated |= !Objects.equals(this.emailVerified, emailVerified);
        this.emailVerified = emailVerified;
    }

    public String getEmailConstraint() {
        return this.emailConstraint;
    }

    public void setEmailConstraint(String emailConstraint) {
        this.updated |= !Objects.equals(this.emailConstraint, emailConstraint);
        this.emailConstraint = emailConstraint;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.attributes.getOrDefault(name, Collections.emptyList());
    }

    @Override
    public void setAttributes(Map<String, List<String>> attributes) {
        this.updated |= !Objects.equals(this.attributes, attributes);
        this.attributes = attributes;
    }

    @Override
    public void setAttribute(String name, List<String> value) {
        this.updated |= !Objects.equals(this.attributes.put(name, value), value);
    }

    @Override
    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    public Set<String> getRequiredActions() {
        return this.requiredActions;
    }

    public void setRequiredActions(Set<String> requiredActions) {
        this.updated |= !Objects.equals(this.requiredActions, requiredActions);
        this.requiredActions = requiredActions;
    }

    public void addRequiredAction(String requiredAction) {
        this.updated |= this.requiredActions.add(requiredAction);
    }

    public void removeRequiredAction(String requiredAction) {
        this.updated |= this.requiredActions.remove(requiredAction);
    }

    public void updateCredential(UserCredentialEntity credentialEntity) {
        this.updated |= this.credentials.replace(credentialEntity.getId(), credentialEntity) != null;
    }

    public void addCredential(UserCredentialEntity credentialEntity) {
        if (this.credentials.containsKey(credentialEntity.getId())) {
            throw new ModelDuplicateException("A CredentialModel with given id already exists");
        }
        this.updated = true;
        this.credentials.put(credentialEntity.getId(), credentialEntity);
        this.credentialsOrder.add(credentialEntity.getId());
    }

    public boolean removeCredential(String credentialId) {
        if (!this.credentials.containsKey(credentialId)) {
            return false;
        }
        this.updated = true;
        this.credentials.remove(credentialId);
        this.credentialsOrder.remove(credentialId);
        return true;
    }

    public UserCredentialEntity getCredential(String id) {
        return this.credentials.get(id);
    }

    public Stream<UserCredentialEntity> getCredentials() {
        return this.credentialsOrder.stream().map(this.credentials::get);
    }

    public int getCredentialIndex(String credentialId) {
        return this.credentialsOrder.indexOf(credentialId);
    }

    public void moveCredential(int currentPosition, int newPosition) {
        this.updated |= currentPosition != newPosition;
        this.credentialsOrder.add(newPosition, this.credentialsOrder.remove(currentPosition));
    }

    public Stream<UserFederatedIdentityEntity> getFederatedIdentities() {
        return this.federatedIdentities.values().stream();
    }

    public void setFederatedIdentities(Collection<UserFederatedIdentityEntity> federatedIdentities) {
        this.updated = true;
        this.federatedIdentities.clear();
        this.federatedIdentities.putAll(federatedIdentities.stream().collect(Collectors.toMap(UserFederatedIdentityEntity::getIdentityProvider, Function.identity())));
    }

    public void addFederatedIdentity(UserFederatedIdentityEntity federatedIdentity) {
        String idpId = federatedIdentity.getIdentityProvider();
        this.updated |= !Objects.equals(this.federatedIdentities.put(idpId, federatedIdentity), federatedIdentity);
    }

    public UserFederatedIdentityEntity getFederatedIdentity(String federatedIdentity) {
        return this.federatedIdentities.get(federatedIdentity);
    }

    public boolean removeFederatedIdentity(String providerId) {
        boolean removed = this.federatedIdentities.remove(providerId) != null;
        this.updated |= removed;
        return removed;
    }

    public void updateFederatedIdentity(UserFederatedIdentityEntity federatedIdentityModel) {
        this.updated |= this.federatedIdentities.replace(federatedIdentityModel.getIdentityProvider(), federatedIdentityModel) != null;
    }

    public Stream<UserConsentEntity> getUserConsents() {
        return this.userConsents.values().stream();
    }

    public UserConsentEntity getUserConsent(String clientId) {
        return this.userConsents.get(clientId);
    }

    public void addUserConsent(UserConsentEntity userConsentEntity) {
        String clientId = userConsentEntity.getClientId();
        this.updated |= !Objects.equals(this.userConsents.put(clientId, userConsentEntity), userConsentEntity);
    }

    public boolean removeUserConsent(String clientId) {
        boolean removed = this.userConsents.remove(clientId) != null;
        this.updated |= removed;
        return removed;
    }

    public Set<String> getGroupsMembership() {
        return this.groupsMembership;
    }

    public void setGroupsMembership(Set<String> groupsMembership) {
        this.updated |= Objects.equals(groupsMembership, this.groupsMembership);
        this.groupsMembership = groupsMembership;
    }

    public void addGroupsMembership(String groupId) {
        this.updated |= this.groupsMembership.add(groupId);
    }

    public void removeGroupsMembership(String groupId) {
        this.updated |= this.groupsMembership.remove(groupId);
    }

    public Set<String> getRolesMembership() {
        return this.rolesMembership;
    }

    public void setRolesMembership(Set<String> rolesMembership) {
        this.updated |= Objects.equals(rolesMembership, this.rolesMembership);
        this.rolesMembership = rolesMembership;
    }

    public void addRolesMembership(String roleId) {
        this.updated |= this.rolesMembership.add(roleId);
    }

    public void removeRolesMembership(String roleId) {
        this.updated |= this.rolesMembership.remove(roleId);
    }

    public String getFederationLink() {
        return this.federationLink;
    }

    public void setFederationLink(String federationLink) {
        this.updated |= !Objects.equals(this.federationLink, federationLink);
        this.federationLink = federationLink;
    }

    public String getServiceAccountClientLink() {
        return this.serviceAccountClientLink;
    }

    public void setServiceAccountClientLink(String serviceAccountClientLink) {
        this.updated |= !Objects.equals(this.serviceAccountClientLink, serviceAccountClientLink);
        this.serviceAccountClientLink = serviceAccountClientLink;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.updated |= !Objects.equals(this.notBefore, notBefore);
        this.notBefore = notBefore;
    }
}

