/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.models.map.storage.tree.TreeNode;

public class DefaultTreeNode<Self extends DefaultTreeNode<Self>>
implements TreeNode<Self> {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final Map<String, Object> nodeProperties;
    private final Map<String, Object> edgeProperties;
    private final Map<String, Object> treeProperties;
    private final LinkedList<Self> children = new LinkedList();
    private String id;
    private Self parent;
    private final int uniqueId = COUNTER.getAndIncrement();
    private static final ThreadLocal<Boolean> TOSTRING_DETAILS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    protected DefaultTreeNode(Map<String, Object> treeProperties) {
        this.treeProperties = treeProperties == null ? Collections.emptyMap() : treeProperties;
        this.edgeProperties = new HashMap<String, Object>();
        this.nodeProperties = new HashMap<String, Object>();
    }

    public DefaultTreeNode(Map<String, Object> nodeProperties, Map<String, Object> edgeProperties, Map<String, Object> treeProperties) {
        this.treeProperties = treeProperties == null ? Collections.emptyMap() : treeProperties;
        this.edgeProperties = edgeProperties == null ? new HashMap() : edgeProperties;
        this.nodeProperties = nodeProperties == null ? new HashMap() : nodeProperties;
    }

    @Override
    public Map<String, Object> getEdgeProperties() {
        return this.edgeProperties;
    }

    @Override
    public <V> Optional<V> getEdgeProperty(String key, Class<V> clazz) {
        Object v = this.getEdgeProperties().get(key);
        return clazz.isInstance(v) ? Optional.of(clazz.cast(v)) : Optional.empty();
    }

    public void setEdgeProperty(String property, Object value) {
        this.edgeProperties.put(property, value);
    }

    @Override
    public Map<String, Object> getNodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public <V> Optional<V> getNodeProperty(String key, Class<V> clazz) {
        Object v = this.getNodeProperties().get(key);
        return clazz.isInstance(v) ? Optional.of(clazz.cast(v)) : Optional.empty();
    }

    public void setNodeProperty(String property, Object value) {
        this.nodeProperties.put(property, value);
    }

    @Override
    public Map<String, Object> getTreeProperties() {
        return this.treeProperties;
    }

    @Override
    public <V> Optional<V> getTreeProperty(String key, Class<V> clazz) {
        Object v = this.getTreeProperties().get(key);
        return clazz.isInstance(v) ? Optional.of(clazz.cast(v)) : Optional.empty();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Optional<Self> findFirstDfs(Predicate<Self> visitor) {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.add(this.getThis());
        while (!stack.isEmpty()) {
            DefaultTreeNode node = (DefaultTreeNode)stack.pop();
            if (visitor.test(node)) {
                return Optional.of(node);
            }
            List<Self> c = node.getChildren();
            ListIterator<Self> li = c.listIterator(c.size());
            while (li.hasPrevious()) {
                stack.push((DefaultTreeNode)li.previous());
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Self> findFirstBottommostDfs(Predicate<Self> visitor) {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.add(this.getThis());
        while (!stack.isEmpty()) {
            DefaultTreeNode node = (DefaultTreeNode)stack.pop();
            if (visitor.test(node)) {
                for (DefaultTreeNode child : node.getChildren()) {
                    Optional<Self> childRes = child.findFirstBottommostDfs(visitor);
                    if (!childRes.isPresent()) continue;
                    return childRes;
                }
                return Optional.of(node);
            }
            List<Self> c = node.getChildren();
            ListIterator<Self> li = c.listIterator(c.size());
            while (li.hasPrevious()) {
                stack.push((DefaultTreeNode)li.previous());
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Self> findFirstBfs(Predicate<Self> visitor) {
        LinkedList<Self> queue = new LinkedList<Self>();
        queue.add(this.getThis());
        while (!queue.isEmpty()) {
            DefaultTreeNode node = (DefaultTreeNode)queue.poll();
            if (visitor.test(node)) {
                return Optional.of(node);
            }
            queue.addAll(node.getChildren());
        }
        return Optional.empty();
    }

    @Override
    public void walkBfs(Consumer<Self> visitor) {
        LinkedList<Self> queue = new LinkedList<Self>();
        queue.add(this.getThis());
        while (!queue.isEmpty()) {
            DefaultTreeNode node = (DefaultTreeNode)queue.poll();
            visitor.accept(node);
            queue.addAll(node.getChildren());
        }
    }

    @Override
    public void walkDfs(Consumer<Self> visitorUponEntry, Consumer<Self> visitorAfterChildrenVisited) {
        if (visitorUponEntry != null) {
            visitorUponEntry.accept(this.getThis());
        }
        for (DefaultTreeNode child : this.children) {
            child.walkDfs(visitorUponEntry, visitorAfterChildrenVisited);
        }
        if (visitorAfterChildrenVisited != null) {
            visitorAfterChildrenVisited.accept(this.getThis());
        }
    }

    @Override
    public void forEachParent(Consumer<Self> visitor) {
        Optional<Self> p = this.getParent();
        while (p.isPresent()) {
            visitor.accept((DefaultTreeNode)p.get());
            p = ((DefaultTreeNode)p.get()).getParent();
        }
    }

    @Override
    public List<Self> getPathToRoot(TreeNode.PathOrientation orientation) {
        LinkedList res = new LinkedList();
        Consumer<DefaultTreeNode> addFunc = orientation == TreeNode.PathOrientation.BOTTOM_FIRST ? res::addLast : res::addFirst;
        Optional<Self> p = Optional.of(this.getThis());
        while (p.isPresent()) {
            addFunc.accept((DefaultTreeNode)p.get());
            p = ((DefaultTreeNode)p.get()).getParent();
        }
        return res;
    }

    @Override
    public List<Self> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void addChild(Self node) {
        if (node == null) {
            return;
        }
        if (!this.children.contains(node)) {
            this.children.add(node);
        }
        ((DefaultTreeNode)node).setParent(this.getThis());
        Optional<Self> p = this.getParent();
        while (p.isPresent()) {
            if (p.get() == node) {
                this.setParent((Self)null);
                return;
            }
            p = ((DefaultTreeNode)p.get()).getParent();
        }
    }

    @Override
    public void addChild(int index, Self node) {
        if (node == null) {
            return;
        }
        if (!this.children.contains(node)) {
            this.children.add(index, node);
        }
        ((DefaultTreeNode)node).setParent(this.getThis());
        Optional<Self> p = this.getParent();
        while (p.isPresent()) {
            if (p.get() == node) {
                this.setParent((Self)null);
                return;
            }
            p = ((DefaultTreeNode)p.get()).getParent();
        }
    }

    @Override
    public Optional<Self> getChild(String id) {
        for (DefaultTreeNode c : this.children) {
            if (!id.equals(c.getId())) continue;
            return Optional.of(c);
        }
        return Optional.empty();
    }

    @Override
    public int removeChild(Predicate<Self> shouldRemove) {
        if (shouldRemove == null) {
            return 0;
        }
        int res = 0;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            DefaultTreeNode n = (DefaultTreeNode)it.next();
            if (!shouldRemove.test(n)) continue;
            it.remove();
            n.setParent((Self)null);
            ++res;
        }
        return res;
    }

    @Override
    public Optional<Self> removeChild(Self node) {
        if (node == null) {
            return Optional.empty();
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            DefaultTreeNode res = (DefaultTreeNode)it.next();
            if (!((DefaultTreeNode)node).equals(res)) continue;
            it.remove();
            res.setParent((Self)null);
            return Optional.of(res);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Self> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public void setParent(Self parent) {
        if (this.parent == parent) {
            return;
        }
        if (parent == this) {
            this.setParent((Self)null);
        }
        if (this.parent != null) {
            Self previousParent = this.parent;
            this.parent = null;
            ((DefaultTreeNode)previousParent).removeChild(this.getThis());
        }
        if (parent != null) {
            this.parent = parent;
            ((DefaultTreeNode)parent).addChild(this.getThis());
        }
    }

    public <RNode extends TreeNode<? super RNode>> RNode cloneTree(Function<Self, RNode> instantiateFunc) {
        TreeNode res = (TreeNode)instantiateFunc.apply(this.getThis());
        this.getChildren().forEach(c -> res.addChild(c.cloneTree(instantiateFunc)));
        return (RNode)res;
    }

    private Self getThis() {
        return (Self)this;
    }

    public int hashCode() {
        return this.uniqueId;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public Stream<Self> getParentsStream() {
        Stream.Builder<DefaultTreeNode> resBuilder = Stream.builder();
        Optional<Self> p = this.getParent();
        while (p.isPresent()) {
            resBuilder.accept((DefaultTreeNode)p.get());
            p = ((DefaultTreeNode)p.get()).getParent();
        }
        return resBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder toString(StringBuilder output, String prefix, DefaultTreeNode<?> node, boolean isTail) {
        String nodeName = node.getLabel();
        if (Objects.equals(TOSTRING_DETAILS.get(), Boolean.FALSE)) {
            return new StringBuilder("@").append(nodeName);
        }
        String nodeConnection = isTail ? (prefix.isEmpty() ? "O\u2500\u2500 " : "\u2514\u2500\u2500 ") : "\u251c\u2500\u2500 ";
        output.append(prefix).append(nodeConnection).append(nodeName);
        try {
            TOSTRING_DETAILS.set(Boolean.FALSE);
            output.append(node.getNodeProperties().isEmpty() ? "" : " " + node.getNodeProperties());
        }
        finally {
            TOSTRING_DETAILS.set(Boolean.TRUE);
        }
        output.append(System.lineSeparator());
        List<?> ch = node.getChildren();
        for (int i = 0; i < ch.size(); ++i) {
            String newPrefix = prefix + (isTail ? "    " : "\u2502   ");
            DefaultTreeNode.toString(output, newPrefix, (DefaultTreeNode)ch.get(i), i == ch.size() - 1);
        }
        return output;
    }

    protected String getLabel() {
        return this.getId();
    }

    public String toString() {
        return DefaultTreeNode.toString(new StringBuilder(), "", this.getThis(), true).toString();
    }
}

