/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.StringKeyConvertor;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapKeycloakTransaction;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

public class UserSessionConcurrentHashMapStorage<K>
extends ConcurrentHashMapStorage<K, MapUserSessionEntity, UserSessionModel> {
    private final ConcurrentHashMapStorage<K, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionStore;

    public UserSessionConcurrentHashMapStorage(ConcurrentHashMapStorage<K, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionStore, StringKeyConvertor<K> keyConvertor) {
        super(UserSessionModel.class, keyConvertor);
        this.clientSessionStore = clientSessionStore;
    }

    @Override
    public MapKeycloakTransaction<MapUserSessionEntity, UserSessionModel> createTransaction(KeycloakSession session) {
        MapKeycloakTransaction<MapUserSessionEntity, UserSessionModel> sessionTransaction = (MapKeycloakTransaction<MapUserSessionEntity, UserSessionModel>)session.getAttribute("map-transaction-" + this.hashCode(), MapKeycloakTransaction.class);
        return sessionTransaction == null ? new Transaction(this.clientSessionStore.createTransaction(session), this.clientSessionStore.getKeyConvertor()) : sessionTransaction;
    }

    private class Transaction
    extends ConcurrentHashMapKeycloakTransaction<K, MapUserSessionEntity, UserSessionModel> {
        private final MapKeycloakTransaction<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionTr;

        public Transaction(MapKeycloakTransaction<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionTr, StringKeyConvertor<K> keyConvertor) {
            super(UserSessionConcurrentHashMapStorage.this, keyConvertor);
            this.clientSessionTr = clientSessionTr;
        }

        @Override
        public long delete(QueryParameters<UserSessionModel> queryParameters) {
            Set ids = this.read(queryParameters).map(AbstractEntity::getId).collect(Collectors.toSet());
            ModelCriteriaBuilder csMcb = UserSessionConcurrentHashMapStorage.this.clientSessionStore.createCriteriaBuilder().compare(AuthenticatedClientSessionModel.SearchableFields.USER_SESSION_ID, ModelCriteriaBuilder.Operator.IN, ids);
            this.clientSessionTr.delete(QueryParameters.withCriteria(csMcb));
            return super.delete(queryParameters);
        }

        @Override
        public boolean delete(String key) {
            ModelCriteriaBuilder csMcb = UserSessionConcurrentHashMapStorage.this.clientSessionStore.createCriteriaBuilder().compare(AuthenticatedClientSessionModel.SearchableFields.USER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, key);
            this.clientSessionTr.delete(QueryParameters.withCriteria(csMcb));
            return super.delete(key);
        }
    }
}

