/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapIdentityProviderMapperEntity
implements UpdatableEntity {
    private String id;
    private String name;
    private String identityProviderAlias;
    private String identityProviderMapper;
    private Map<String, String> config = new HashMap<String, String>();
    private boolean updated;

    private MapIdentityProviderMapperEntity() {
    }

    public static MapIdentityProviderMapperEntity fromModel(IdentityProviderMapperModel model) {
        if (model == null) {
            return null;
        }
        MapIdentityProviderMapperEntity entity = new MapIdentityProviderMapperEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setConfig(model.getConfig() == null ? null : new HashMap(model.getConfig()));
        return entity;
    }

    public static IdentityProviderMapperModel toModel(MapIdentityProviderMapperEntity entity) {
        if (entity == null) {
            return null;
        }
        IdentityProviderMapperModel model = new IdentityProviderMapperModel();
        model.setId(entity.getId());
        model.setName(entity.getName());
        model.setIdentityProviderAlias(entity.getIdentityProviderAlias());
        model.setIdentityProviderMapper(entity.getIdentityProviderMapper());
        model.setConfig((Map)(entity.getConfig() == null ? null : new HashMap<String, String>(entity.getConfig())));
        return model;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.updated = !Objects.equals(this.id, id);
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated = !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getIdentityProviderAlias() {
        return this.identityProviderAlias;
    }

    public void setIdentityProviderAlias(String identityProviderAlias) {
        this.updated = !Objects.equals(this.identityProviderAlias, identityProviderAlias);
        this.identityProviderAlias = identityProviderAlias;
    }

    public String getIdentityProviderMapper() {
        return this.identityProviderMapper;
    }

    public void setIdentityProviderMapper(String identityProviderMapper) {
        this.updated = !Objects.equals(this.identityProviderMapper, identityProviderMapper);
        this.identityProviderMapper = identityProviderMapper;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.updated = !Objects.equals(this.config, config);
        this.config = config;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapIdentityProviderMapperEntity)) {
            return false;
        }
        MapIdentityProviderMapperEntity other = (MapIdentityProviderMapperEntity)obj;
        return Objects.equals(other.getId(), this.getId());
    }
}

