/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class MapClientProviderFactory
extends AbstractMapProviderFactory<ClientProvider, MapClientEntity, ClientModel>
implements ClientProviderFactory,
ProviderEventListener {
    private final ConcurrentHashMap<String, ConcurrentMap<String, Integer>> REGISTERED_NODES_STORE = new ConcurrentHashMap();
    private Runnable onClose;

    public MapClientProviderFactory() {
        super(ClientModel.class);
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        this.onClose = () -> factory.unregister((ProviderEventListener)this);
    }

    public MapClientProvider create(KeycloakSession session) {
        return new MapClientProvider(session, this.getStorage(session), this.REGISTERED_NODES_STORE);
    }

    public void close() {
        super.close();
        this.onClose.run();
    }

    public String getHelpText() {
        return "Client provider";
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof RoleContainerModel.RoleRemovedEvent) {
            RealmModel realm;
            RoleContainerModel.RoleRemovedEvent e = (RoleContainerModel.RoleRemovedEvent)event;
            RoleModel role = e.getRole();
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel) {
                realm = (RealmModel)container;
            } else if (container instanceof ClientModel) {
                realm = ((ClientModel)container).getRealm();
            } else {
                return;
            }
            this.create(e.getKeycloakSession()).preRemove(realm, role);
        }
    }
}

