/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.common.StreamUtils;
import org.keycloak.models.map.role.MapRoleAdapter;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapRoleProvider<K>
implements RoleProvider {
    private static final Logger LOG = Logger.getLogger(MapRoleProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<K, MapRoleEntity<K>, RoleModel> tx;
    private final MapStorage<K, MapRoleEntity<K>, RoleModel> roleStore;
    private static final Comparator<MapRoleEntity<?>> COMPARE_BY_NAME = new Comparator<MapRoleEntity<?>>(){

        @Override
        public int compare(MapRoleEntity<?> o1, MapRoleEntity<?> o2) {
            String r2;
            String r1 = o1 == null ? null : o1.getName();
            String string = r2 = o2 == null ? null : o2.getName();
            return r1 == r2 ? 0 : (r1 == null ? -1 : (r2 == null ? 1 : r1.compareTo(r2)));
        }
    };

    public MapRoleProvider(KeycloakSession session, MapStorage<K, MapRoleEntity<K>, RoleModel> roleStore) {
        this.session = session;
        this.roleStore = roleStore;
        this.tx = roleStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapRoleEntity<K>, RoleModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapRoleAdapter<K>(this.session, realm, MapStorageUtils.registerEntityForChanges(this.tx, origEntity)){

            public String getId() {
                return MapRoleProvider.this.roleStore.getKeyConvertor().keyToString(((MapRoleEntity)this.entity).getId());
            }
        };
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        K entityId = id == null ? this.roleStore.getKeyConvertor().yieldNewUniqueKey() : this.roleStore.getKeyConvertor().fromString(id);
        LOG.tracef("addRealmRole(%s, %s, %s)%s", new Object[]{realm, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity<K> entity = new MapRoleEntity<K>(entityId, realm.getId());
        entity.setName(name);
        entity.setRealmId(realm.getId());
        if (this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        this.tx.create(entity.getId(), entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        return StreamsUtil.paginatedStream(this.getRealmRolesStream(realm), (Integer)first, (Integer)max);
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm) {
        ModelCriteriaBuilder<RoleModel> mcb = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.NE, true);
        return this.tx.getUpdatedNotRemoved(mcb).sorted(COMPARE_BY_NAME).map(this.entityToAdapterFunc(realm));
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        if (this.getClientRole(client, name) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        K entityId = id == null ? this.roleStore.getKeyConvertor().yieldNewUniqueKey() : this.roleStore.getKeyConvertor().fromString(id);
        LOG.tracef("addClientRole(%s, %s, %s)%s", new Object[]{client, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity<K> entity = new MapRoleEntity<K>(entityId, client.getRealm().getId());
        entity.setName(name);
        entity.setClientRole(true);
        entity.setClientId(client.getId());
        if (this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        this.tx.create(entity.getId(), entity);
        return this.entityToAdapterFunc(client.getRealm()).apply(entity);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        return StreamsUtil.paginatedStream(this.getClientRolesStream(client), (Integer)first, (Integer)max);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client) {
        ModelCriteriaBuilder<RoleModel> mcb = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, client.getRealm().getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId());
        return this.tx.getUpdatedNotRemoved(mcb).sorted(COMPARE_BY_NAME).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public boolean removeRole(final RoleModel role) {
        LOG.tracef("removeRole(%s(%s))%s", (Object)role.getName(), (Object)role.getId(), StackUtil.getShortStackTrace());
        RealmModel realm = role.isClientRole() ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer();
        this.session.users().preRemove(realm, role);
        ModelCriteriaBuilder<RoleModel> mcb = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.IS_CLIENT_ROLE, ModelCriteriaBuilder.Operator.EQ, false).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.IS_COMPOSITE_ROLE, ModelCriteriaBuilder.Operator.EQ, false);
        try (Stream<MapRoleEntity<K>> baseStream = this.tx.getUpdatedNotRemoved(mcb);){
            StreamUtils.leftInnerJoinIterable(baseStream, MapRoleEntity::getCompositeRoles).filter(pair -> role.getId().equals(pair.getV())).collect(Collectors.toSet()).forEach(pair -> {
                MapRoleEntity origEntity = (MapRoleEntity)pair.getK();
                MapStorageUtils.registerEntityForChanges(this.tx, origEntity);
                origEntity.removeCompositeRole(role.getId());
            });
        }
        this.session.clients().getClientsStream(realm).forEach(client -> {
            client.deleteScopeMapping(role);
            ModelCriteriaBuilder<RoleModel> mcbClient = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.IS_COMPOSITE_ROLE, ModelCriteriaBuilder.Operator.EQ, false);
            try (Stream<MapRoleEntity<K>> baseStream = this.tx.getUpdatedNotRemoved(mcbClient);){
                StreamUtils.leftInnerJoinIterable(baseStream, MapRoleEntity::getCompositeRoles).filter(pair -> role.getId().equals(pair.getV())).collect(Collectors.toSet()).forEach(pair -> {
                    MapRoleEntity origEntity = (MapRoleEntity)pair.getK();
                    MapStorageUtils.registerEntityForChanges(this.tx, origEntity);
                    origEntity.removeCompositeRole(role.getId());
                });
            }
        });
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RoleContainerModel.RoleRemovedEvent(){

            public RoleModel getRole() {
                return role;
            }

            public KeycloakSession getKeycloakSession() {
                return MapRoleProvider.this.session;
            }
        });
        this.tx.delete(this.roleStore.getKeyConvertor().fromString(role.getId()));
        return true;
    }

    public void removeRoles(RealmModel realm) {
        this.getRealmRolesStream(realm).forEach(this::removeRole);
    }

    public void removeRoles(ClientModel client) {
        this.getClientRolesStream(client).forEach(this::removeRole);
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmRole(%s, %s)%s", (Object)realm, (Object)name, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<RoleModel> mcb = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, name);
        String roleId = this.tx.getUpdatedNotRemoved(mcb).map(this.entityToAdapterFunc(realm)).map(RoleModel::getId).findFirst().orElse(null);
        return roleId == null ? null : this.session.roles().getRoleById(realm, roleId);
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getClientRole(%s, %s)%s", (Object)client, (Object)name, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<RoleModel> mcb = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, client.getRealm().getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, name);
        String roleId = this.tx.getUpdatedNotRemoved(mcb).map(this.entityToAdapterFunc(client.getRealm())).map(RoleModel::getId).findFirst().orElse(null);
        return roleId == null ? null : this.session.roles().getRoleById(client.getRealm(), roleId);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        if (id == null || realm == null || realm.getId() == null) {
            return null;
        }
        LOG.tracef("getRoleById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapRoleEntity<K> entity = this.tx.read(this.roleStore.getKeyConvertor().fromStringSafe(id));
        String realmId = realm.getId();
        return entity == null || !Objects.equals(realmId, entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder<RoleModel> mcb = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).or(this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + search + "%"), this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, "%" + search + "%"));
        Stream<MapRoleEntity<?>> s = this.tx.getUpdatedNotRemoved(mcb).sorted(COMPARE_BY_NAME);
        return StreamsUtil.paginatedStream(s.map(this.entityToAdapterFunc(realm)), (Integer)first, (Integer)max);
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        ModelCriteriaBuilder<RoleModel> mcb = this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, client.getRealm().getId()).compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, client.getId()).or(this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + search + "%"), this.roleStore.createCriteriaBuilder().compare((SearchableModelField<RoleModel>)RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, "%" + search + "%"));
        Stream<MapRoleEntity<?>> s = this.tx.getUpdatedNotRemoved(mcb).sorted(COMPARE_BY_NAME);
        return StreamsUtil.paginatedStream(s, (Integer)first, (Integer)max).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public void close() {
    }
}

