/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.group.MapGroupAdapter;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapGroupProvider<K>
implements GroupProvider {
    private static final Logger LOG = Logger.getLogger(MapGroupProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<K, MapGroupEntity<K>, GroupModel> tx;
    private final MapStorage<K, MapGroupEntity<K>, GroupModel> groupStore;

    public MapGroupProvider(KeycloakSession session, MapStorage<K, MapGroupEntity<K>, GroupModel> groupStore) {
        this.session = session;
        this.groupStore = groupStore;
        this.tx = groupStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapGroupEntity<K>, GroupModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapGroupAdapter<K>(this.session, realm, MapStorageUtils.registerEntityForChanges(this.tx, origEntity)){

            public String getId() {
                return MapGroupProvider.this.groupStore.getKeyConvertor().keyToString(((MapGroupEntity)this.entity).getId());
            }
        };
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        K uid;
        if (id == null) {
            return null;
        }
        LOG.tracef("getGroupById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        try {
            uid = this.groupStore.getKeyConvertor().fromStringSafe(id);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        MapGroupEntity<K> entity = this.tx.read(uid);
        String realmId = realm.getId();
        return entity == null || !Objects.equals(realmId, entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        return this.getGroupsStreamInternal(realm, null);
    }

    private Stream<GroupModel> getGroupsStreamInternal(RealmModel realm, UnaryOperator<ModelCriteriaBuilder<GroupModel>> modifier) {
        LOG.tracef("getGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        if (modifier != null) {
            mcb = (ModelCriteriaBuilder)modifier.apply(mcb);
        }
        return this.tx.getUpdatedNotRemoved(mcb).map(this.entityToAdapterFunc(realm)).sorted(GroupModel.COMPARE_BY_NAME);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        Object[] objectArray = new Object[1];
        objectArray[0] = ids.map(this.groupStore.getKeyConvertor()::fromString);
        ModelCriteriaBuilder<GroupModel> mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, objectArray).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        if (search != null) {
            mcb = mcb.compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + search + "%");
        }
        Stream<GroupModel> groupModelStream = this.tx.getUpdatedNotRemoved(mcb).map(this.entityToAdapterFunc(realm)).sorted(Comparator.comparing(GroupModel::getName));
        return StreamsUtil.paginatedStream(groupModelStream, (Integer)first, (Integer)max);
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        LOG.tracef("getGroupsCount(%s, %s)%s", (Object)realm, (Object)onlyTopGroups, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<GroupModel> mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        if (Objects.equals(onlyTopGroups, Boolean.TRUE)) {
            mcb = mcb.compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{null});
        }
        return this.tx.getCount(mcb);
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        ModelCriteriaBuilder<GroupModel> mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + search + "%");
        return this.tx.getCount(mcb);
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        LOG.tracef("getGroupsByRole(%s, %s, %d, %d)%s", new Object[]{realm, role, firstResult, maxResults, StackUtil.getShortStackTrace()});
        Stream<GroupModel> groupModelStream = this.getGroupsStreamInternal(realm, mcb -> mcb.compare(GroupModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, role.getId()));
        return StreamsUtil.paginatedStream(groupModelStream, (Integer)firstResult, (Integer)maxResults);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        LOG.tracef("getTopLevelGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getGroupsStreamInternal(realm, mcb -> mcb.compare(GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{null}));
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        Stream<GroupModel> groupModelStream = this.getTopLevelGroupsStream(realm);
        return StreamsUtil.paginatedStream(groupModelStream, (Integer)firstResult, (Integer)maxResults);
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForGroupByNameStream(%s, %s, %d, %d)%s", new Object[]{realm, search, firstResult, maxResults, StackUtil.getShortStackTrace()});
        Stream<GroupModel> groupModelStream = this.getGroupsStreamInternal(realm, mcb -> mcb.compare(GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + search + "%"));
        return StreamsUtil.paginatedStream(groupModelStream, (Integer)firstResult, (Integer)maxResults);
    }

    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        LOG.tracef("createGroup(%s, %s, %s, %s)%s", new Object[]{realm, id, name, toParent, StackUtil.getShortStackTrace()});
        K entityId = id == null ? this.groupStore.getKeyConvertor().yieldNewUniqueKey() : this.groupStore.getKeyConvertor().fromString(id);
        String parentId = toParent == null ? null : toParent.getId();
        ModelCriteriaBuilder<GroupModel> mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, parentId).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name);
        if (this.tx.getCount(mcb) > 0L) {
            throw new ModelDuplicateException("Group with name '" + name + "' in realm " + realm.getName() + " already exists for requested parent");
        }
        MapGroupEntity<K> entity = new MapGroupEntity<K>(entityId, realm.getId());
        entity.setName(name);
        entity.setParentId(toParent == null ? null : toParent.getId());
        if (this.tx.read(entity.getId()) != null) {
            throw new ModelDuplicateException("Group exists: " + entityId);
        }
        this.tx.create(entity.getId(), entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public boolean removeGroup(final RealmModel realm, final GroupModel group) {
        LOG.tracef("removeGroup(%s, %s)%s", (Object)realm, (Object)group, StackUtil.getShortStackTrace());
        if (group == null) {
            return false;
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new GroupModel.GroupRemovedEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public GroupModel getGroup() {
                return group;
            }

            public KeycloakSession getKeycloakSession() {
                return MapGroupProvider.this.session;
            }
        });
        this.session.users().preRemove(realm, group);
        realm.removeDefaultGroup(group);
        group.getSubGroupsStream().forEach(subGroup -> this.session.groups().removeGroup(realm, subGroup));
        this.tx.delete(this.groupStore.getKeyConvertor().fromString(group.getId()));
        return true;
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        LOG.tracef("moveGroup(%s, %s, %s)%s", new Object[]{realm, group, toParent, StackUtil.getShortStackTrace()});
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        String parentId = toParent == null ? null : toParent.getId();
        ModelCriteriaBuilder<GroupModel> mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, parentId).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, group.getName());
        try (Stream<MapGroupEntity<K>> possibleSiblings = this.tx.getUpdatedNotRemoved(mcb);){
            if (possibleSiblings.findAny().isPresent()) {
                throw new ModelDuplicateException("Parent already contains subgroup named '" + group.getName() + "'");
            }
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        }
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        LOG.tracef("addTopLevelGroup(%s, %s)%s", (Object)realm, (Object)subGroup, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<GroupModel> mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.PARENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{null}).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, subGroup.getName());
        try (Stream<MapGroupEntity<K>> possibleSiblings = this.tx.getUpdatedNotRemoved(mcb);){
            if (possibleSiblings.findAny().isPresent()) {
                throw new ModelDuplicateException("There is already a top level group named '" + subGroup.getName() + "'");
            }
        }
        subGroup.setParent(null);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        LOG.tracef("preRemove(%s, %s)%s", (Object)realm, (Object)role, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<GroupModel> mcb = this.groupStore.createCriteriaBuilder().compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<GroupModel>)GroupModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, role.getId());
        try (Stream<MapGroupEntity<K>> toRemove = this.tx.getUpdatedNotRemoved(mcb);){
            toRemove.map(groupEntity -> this.session.groups().getGroupById(realm, groupEntity.getId().toString())).forEach(groupModel -> groupModel.deleteRoleMapping(role));
        }
    }

    public void close() {
    }
}

