/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.realm.MapRealmAdapter;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;

public class MapRealmProvider<K>
implements RealmProvider {
    private static final Logger LOG = Logger.getLogger(MapRealmProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<K, MapRealmEntity<K>, RealmModel> tx;
    private final MapStorage<K, MapRealmEntity<K>, RealmModel> realmStore;

    public MapRealmProvider(KeycloakSession session, MapStorage<K, MapRealmEntity<K>, RealmModel> realmStore) {
        this.session = session;
        this.realmStore = realmStore;
        this.tx = realmStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private RealmModel entityToAdapter(MapRealmEntity<K> entity) {
        return new MapRealmAdapter<K>(this.session, MapStorageUtils.registerEntityForChanges(this.tx, entity)){

            public String getId() {
                return MapRealmProvider.this.realmStore.getKeyConvertor().keyToString(((MapRealmEntity)this.entity).getId());
            }
        };
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        Object kId;
        if (this.getRealmByName(name) != null) {
            throw new ModelDuplicateException("Realm with given name exists: " + name);
        }
        Object k = kId = id == null ? null : (Object)this.realmStore.getKeyConvertor().fromString(id);
        if (kId != null) {
            if (this.tx.read(kId) != null) {
                throw new ModelDuplicateException("Realm exists: " + kId);
            }
        } else {
            kId = this.realmStore.getKeyConvertor().yieldNewUniqueKey();
        }
        LOG.tracef("createRealm(%s, %s)%s", kId, (Object)name, StackUtil.getShortStackTrace());
        MapRealmEntity<Object> entity = new MapRealmEntity<Object>(kId);
        entity.setName(name);
        this.tx.create(kId, entity);
        return this.entityToAdapter(entity);
    }

    public RealmModel getRealm(String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getRealm(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        MapRealmEntity<K> entity = this.tx.read(this.realmStore.getKeyConvertor().fromStringSafe(id));
        return entity == null ? null : this.entityToAdapter(entity);
    }

    public RealmModel getRealmByName(String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmByName(%s)%s", (Object)name, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<RealmModel> mcb = this.realmStore.createCriteriaBuilder().compare((SearchableModelField<RealmModel>)RealmModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name);
        Object realmId = this.tx.getUpdatedNotRemoved(mcb).findFirst().map(MapRealmEntity::getId).orElse(null);
        return realmId == null ? null : this.session.realms().getRealm(this.realmStore.getKeyConvertor().keyToString(realmId));
    }

    public Stream<RealmModel> getRealmsStream() {
        return this.getRealmsStream(this.realmStore.createCriteriaBuilder());
    }

    public Stream<RealmModel> getRealmsWithProviderTypeStream(Class<?> type) {
        ModelCriteriaBuilder<RealmModel> mcb = this.realmStore.createCriteriaBuilder().compare((SearchableModelField<RealmModel>)RealmModel.SearchableFields.COMPONENT_PROVIDER_TYPE, ModelCriteriaBuilder.Operator.EQ, type.getName());
        return this.getRealmsStream(mcb);
    }

    private Stream<RealmModel> getRealmsStream(ModelCriteriaBuilder<RealmModel> mcb) {
        return this.tx.getUpdatedNotRemoved(mcb).map(this::entityToAdapter).sorted(RealmModel.COMPARE_BY_NAME);
    }

    public boolean removeRealm(String id) {
        LOG.tracef("removeRealm(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        final RealmModel realm = this.getRealm(id);
        if (realm == null) {
            return false;
        }
        this.session.users().preRemove(realm);
        this.session.clients().removeClients(realm);
        this.session.clientScopes().removeClientScopes(realm);
        this.session.roles().removeRoles(realm);
        realm.getTopLevelGroupsStream().forEach(arg_0 -> ((RealmModel)realm).removeGroup(arg_0));
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmRemovedEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public KeycloakSession getKeycloakSession() {
                return MapRealmProvider.this.session;
            }
        });
        this.tx.delete(this.realmStore.getKeyConvertor().fromString(id));
        return true;
    }

    public void removeExpiredClientInitialAccess() {
        ModelCriteriaBuilder<RealmModel> mcb = this.realmStore.createCriteriaBuilder().compare((SearchableModelField<RealmModel>)RealmModel.SearchableFields.CLIENT_INITIAL_ACCESS, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
        this.tx.getUpdatedNotRemoved(mcb).map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).forEach(MapRealmEntity::removeExpiredClientInitialAccesses);
    }

    public void saveLocalizationText(RealmModel realm, String locale, String key, String text) {
        if (!this.updateLocalizationText(realm, locale, key, text)) {
            HashMap<String, String> texts = new HashMap<String, String>();
            texts.put(key, text);
            realm.patchRealmLocalizationTexts(locale, texts);
        }
    }

    public void saveLocalizationTexts(RealmModel realm, String locale, Map<String, String> localizationTexts) {
        if (locale == null || localizationTexts == null) {
            return;
        }
        realm.patchRealmLocalizationTexts(locale, localizationTexts);
    }

    public boolean updateLocalizationText(RealmModel realm, String locale, String key, String text) {
        if (locale == null || key == null || text == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return false;
        }
        HashMap<String, String> texts = new HashMap<String, String>(realm.getRealmLocalizationTextsByLocale(locale));
        texts.replace(key, text);
        realm.patchRealmLocalizationTexts(locale, texts);
        return true;
    }

    public boolean deleteLocalizationTextsByLocale(RealmModel realm, String locale) {
        return realm.removeRealmLocalizationTexts(locale);
    }

    public boolean deleteLocalizationText(RealmModel realm, String locale, String key) {
        if (locale == null || key == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return false;
        }
        HashMap texts = new HashMap(realm.getRealmLocalizationTextsByLocale(locale));
        texts.remove(key);
        realm.removeRealmLocalizationTexts(locale);
        realm.patchRealmLocalizationTexts(locale, texts);
        return true;
    }

    public String getLocalizationTextsById(RealmModel realm, String locale, String key) {
        if (locale == null || key == null || !realm.getRealmLocalizationTextsByLocale(locale).containsKey(key)) {
            return null;
        }
        return (String)realm.getRealmLocalizationTextsByLocale(locale).get(key);
    }

    @Deprecated
    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        return this.session.clients().addClient(realm, id, clientId);
    }

    @Deprecated
    public long getClientsCount(RealmModel realm) {
        return this.session.clients().getClientsCount(realm);
    }

    @Deprecated
    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.session.clients().getClientsStream(realm, firstResult, maxResults);
    }

    @Deprecated
    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        return this.session.clients().getAlwaysDisplayInConsoleClientsStream(realm);
    }

    @Deprecated
    public boolean removeClient(RealmModel realm, String id) {
        return this.session.clients().removeClient(realm, id);
    }

    @Deprecated
    public void removeClients(RealmModel realm) {
        this.session.clients().removeClients(realm);
    }

    @Deprecated
    public ClientModel getClientById(RealmModel realm, String id) {
        return this.session.clients().getClientById(realm, id);
    }

    @Deprecated
    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        return this.session.clients().getClientByClientId(realm, clientId);
    }

    @Deprecated
    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        return this.session.clients().searchClientsByClientIdStream(realm, clientId, firstResult, maxResults);
    }

    @Deprecated
    public void addClientScopes(RealmModel realm, ClientModel client, Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        this.session.clients().addClientScopes(realm, client, clientScopes, defaultScope);
    }

    @Deprecated
    public void removeClientScope(RealmModel realm, ClientModel client, ClientScopeModel clientScope) {
        this.session.clients().removeClientScope(realm, client, clientScope);
    }

    @Deprecated
    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScopes) {
        return this.session.clients().getClientScopes(realm, client, defaultScopes);
    }

    @Deprecated
    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        return this.session.clientScopes().getClientScopeById(realm, id);
    }

    @Deprecated
    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        return this.session.clientScopes().getClientScopesStream(realm);
    }

    @Deprecated
    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        return this.session.clientScopes().addClientScope(realm, id, name);
    }

    @Deprecated
    public boolean removeClientScope(RealmModel realm, String id) {
        return this.session.clientScopes().removeClientScope(realm, id);
    }

    @Deprecated
    public void removeClientScopes(RealmModel realm) {
        this.session.clientScopes().removeClientScopes(realm);
    }

    @Deprecated
    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        this.session.groups().moveGroup(realm, group, toParent);
    }

    @Deprecated
    public GroupModel getGroupById(RealmModel realm, String id) {
        return this.session.groups().getGroupById(realm, id);
    }

    @Deprecated
    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        return this.session.groups().getGroupsCount(realm, onlyTopGroups);
    }

    @Deprecated
    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.session.groups().getGroupsCountByNameContaining(realm, search);
    }

    @Deprecated
    public boolean removeGroup(RealmModel realm, GroupModel group) {
        return this.session.groups().removeGroup(realm, group);
    }

    @Deprecated
    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        return this.session.groups().createGroup(realm, id, name, toParent);
    }

    @Deprecated
    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        this.session.groups().addTopLevelGroup(realm, subGroup);
    }

    @Deprecated
    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        return this.session.groups().getGroupsStream(realm);
    }

    @Deprecated
    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        return this.session.groups().getGroupsStream(realm, ids, search, first, max);
    }

    @Deprecated
    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return this.session.groups().getGroupsByRoleStream(realm, role, firstResult, maxResults);
    }

    @Deprecated
    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        return this.session.groups().getTopLevelGroupsStream(realm);
    }

    @Deprecated
    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.session.groups().getTopLevelGroupsStream(realm, firstResult, maxResults);
    }

    @Deprecated
    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        return this.session.groups().searchForGroupByNameStream(realm, search, firstResult, maxResults);
    }

    @Deprecated
    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        return this.session.roles().addRealmRole(realm, id, name);
    }

    @Deprecated
    public RoleModel getRealmRole(RealmModel realm, String name) {
        return this.session.roles().getRealmRole(realm, name);
    }

    @Deprecated
    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        return this.session.roles().getRealmRolesStream(realm, first, max);
    }

    @Deprecated
    public boolean removeRole(RoleModel role) {
        return this.session.roles().removeRole(role);
    }

    @Deprecated
    public void removeRoles(RealmModel realm) {
        this.session.roles().removeRoles(realm);
    }

    @Deprecated
    public RoleModel addClientRole(ClientModel client, String id, String name) {
        return this.session.roles().addClientRole(client, name);
    }

    @Deprecated
    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        return this.session.roles().getClientRolesStream(client, first, max);
    }

    @Deprecated
    public void removeRoles(ClientModel client) {
        this.session.roles().removeRoles(client);
    }

    @Deprecated
    public RoleModel getRoleById(RealmModel realm, String id) {
        return this.session.roles().getRoleById(realm, id);
    }

    @Deprecated
    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        return this.session.roles().searchForRolesStream(realm, search, first, max);
    }

    @Deprecated
    public RoleModel getClientRole(ClientModel client, String name) {
        return this.session.roles().getClientRole(client, name);
    }

    @Deprecated
    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        return this.session.roles().searchForClientRolesStream(client, search, first, max);
    }

    public void close() {
    }
}

