/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapPermissionTicketAdapter;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapPermissionTicketStore<K extends Comparable<K>>
implements PermissionTicketStore {
    private static final Logger LOG = Logger.getLogger(MapPermissionTicketStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<K, MapPermissionTicketEntity<K>, PermissionTicket> tx;
    private final MapStorage<K, MapPermissionTicketEntity<K>, PermissionTicket> permissionTicketStore;

    public MapPermissionTicketStore(KeycloakSession session, MapStorage<K, MapPermissionTicketEntity<K>, PermissionTicket> permissionTicketStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.permissionTicketStore = permissionTicketStore;
        this.tx = permissionTicketStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private PermissionTicket entityToAdapter(MapPermissionTicketEntity<K> origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapPermissionTicketAdapter<K>(MapStorageUtils.registerEntityForChanges(this.tx, origEntity), this.authorizationProvider.getStoreFactory()){

            public String getId() {
                return MapPermissionTicketStore.this.permissionTicketStore.getKeyConvertor().keyToString(((MapPermissionTicketEntity)this.entity).getId());
            }
        };
    }

    private ModelCriteriaBuilder<PermissionTicket> forResourceServer(String resourceServerId) {
        ModelCriteriaBuilder<PermissionTicket> mcb = this.permissionTicketStore.createCriteriaBuilder();
        return resourceServerId == null ? mcb : mcb.compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, resourceServerId);
    }

    public long count(Map<PermissionTicket.FilterOption, String> attributes, String resourceServerId) {
        ModelCriteriaBuilder<PermissionTicket> mcb = this.forResourceServer(resourceServerId).and((ModelCriteriaBuilder[])attributes.entrySet().stream().map(this::filterEntryToModelCriteriaBuilder).toArray(ModelCriteriaBuilder[]::new));
        return this.tx.getCount(mcb);
    }

    public PermissionTicket create(String resourceId, String scopeId, String requester, ResourceServer resourceServer) {
        LOG.tracef("create(%s, %s, %s, %s)%s", new Object[]{resourceId, scopeId, requester, resourceServer, StackUtil.getShortStackTrace()});
        String owner = this.authorizationProvider.getStoreFactory().getResourceStore().findById(resourceId, resourceServer.getId()).getOwner();
        ModelCriteriaBuilder<PermissionTicket> mcb = this.forResourceServer(resourceServer.getId()).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, owner).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, resourceId).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.EQ, requester);
        if (scopeId != null) {
            mcb = mcb.compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.EQ, scopeId);
        }
        if (this.tx.getCount(mcb) > 0L) {
            throw new ModelDuplicateException("Permission ticket for resource server: '" + resourceServer.getId() + ", Resource: " + resourceId + ", owner: " + owner + ", scopeId: " + scopeId + " already exists.");
        }
        Comparable newId = (Comparable)this.permissionTicketStore.getKeyConvertor().yieldNewUniqueKey();
        MapPermissionTicketEntity<Comparable> entity = new MapPermissionTicketEntity<Comparable>(newId);
        entity.setResourceId(resourceId);
        entity.setRequester(requester);
        entity.setCreatedTimestamp(System.currentTimeMillis());
        if (scopeId != null) {
            entity.setScopeId(scopeId);
        }
        entity.setOwner(owner);
        entity.setResourceServerId(resourceServer.getId());
        this.tx.create(entity.getId(), entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        this.tx.delete(this.permissionTicketStore.getKeyConvertor().fromString(id));
    }

    public PermissionTicket findById(String id, String resourceServerId) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.getUpdatedNotRemoved(this.forResourceServer(resourceServerId).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, id)).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public List<PermissionTicket> findByResourceServer(String resourceServerId) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.getUpdatedNotRemoved(this.forResourceServer(resourceServerId)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> findByOwner(String owner, String resourceServerId) {
        LOG.tracef("findByOwner(%s, %s)%s", (Object)owner, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.getUpdatedNotRemoved(this.forResourceServer(resourceServerId).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, owner)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> findByResource(String resourceId, String resourceServerId) {
        LOG.tracef("findByResource(%s, %s)%s", (Object)resourceId, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.getUpdatedNotRemoved(this.forResourceServer(resourceServerId).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, resourceId)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> findByScope(String scopeId, String resourceServerId) {
        LOG.tracef("findByScope(%s, %s)%s", (Object)scopeId, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.getUpdatedNotRemoved(this.forResourceServer(resourceServerId).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.EQ, scopeId)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> find(Map<PermissionTicket.FilterOption, String> attributes, String resourceServerId, int firstResult, int maxResult) {
        ModelCriteriaBuilder<PermissionTicket> mcb = this.forResourceServer(resourceServerId);
        if (attributes.containsKey(PermissionTicket.FilterOption.RESOURCE_NAME)) {
            String expectedResourceName = attributes.remove(PermissionTicket.FilterOption.RESOURCE_NAME);
            EnumMap<Resource.FilterOption, String[]> filterOptionStringMap = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            filterOptionStringMap.put(Resource.FilterOption.EXACT_NAME, new String[]{expectedResourceName});
            List r = this.authorizationProvider.getStoreFactory().getResourceStore().findByResourceServer(filterOptionStringMap, resourceServerId, -1, -1);
            if (r == null || r.isEmpty()) {
                return Collections.emptyList();
            }
            mcb = mcb.compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.IN, r.stream().map(Resource::getId));
        }
        mcb = mcb.and((ModelCriteriaBuilder[])attributes.entrySet().stream().map(this::filterEntryToModelCriteriaBuilder).toArray(ModelCriteriaBuilder[]::new));
        Comparator<MapPermissionTicketEntity> c = Comparator.comparing(MapPermissionTicketEntity::getId);
        return StreamsUtil.paginatedStream(this.tx.getUpdatedNotRemoved(mcb).sorted(c), (Integer)firstResult, (Integer)maxResult).map(this::entityToAdapter).collect(Collectors.toList());
    }

    private ModelCriteriaBuilder<PermissionTicket> filterEntryToModelCriteriaBuilder(Map.Entry<PermissionTicket.FilterOption, String> entry) {
        PermissionTicket.FilterOption name = entry.getKey();
        String value = entry.getValue();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case RESOURCE_ID: 
            case OWNER: 
            case REQUESTER: 
            case POLICY_ID: {
                return this.permissionTicketStore.createCriteriaBuilder().compare((SearchableModelField<PermissionTicket>)name.getSearchableModelField(), ModelCriteriaBuilder.Operator.EQ, value);
            }
            case SCOPE_IS_NULL: 
            case GRANTED: 
            case REQUESTER_IS_NULL: {
                ModelCriteriaBuilder.Operator op = ModelCriteriaBuilder.Operator.NOT_EXISTS;
                if (Boolean.parseBoolean(value)) {
                    op = ModelCriteriaBuilder.Operator.EXISTS;
                }
                return this.permissionTicketStore.createCriteriaBuilder().compare((SearchableModelField<PermissionTicket>)name.getSearchableModelField(), op, new Object[0]);
            }
            case POLICY_IS_NOT_NULL: {
                return this.permissionTicketStore.createCriteriaBuilder().compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public List<PermissionTicket> findGranted(String userId, String resourceServerId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(filters, resourceServerId, -1, -1);
    }

    public List<PermissionTicket> findGranted(String resourceName, String userId, String resourceServerId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.RESOURCE_NAME, resourceName);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(filters, resourceServerId, -1, -1);
    }

    public List<Resource> findGrantedResources(String requester, String name, int first, int max) {
        ModelCriteriaBuilder<PermissionTicket> mcb = this.permissionTicketStore.createCriteriaBuilder().compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.EQ, requester).compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.GRANTED_TIMESTAMP, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
        ResourceStore resourceStore = this.authorizationProvider.getStoreFactory().getResourceStore();
        Function<MapPermissionTicketEntity, Resource> ticketResourceMapper = name != null ? ticket -> {
            EnumMap<Resource.FilterOption, String[]> filterOptionMap = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            filterOptionMap.put(Resource.FilterOption.ID, new String[]{ticket.getResourceId()});
            filterOptionMap.put(Resource.FilterOption.NAME, new String[]{name});
            List resource = resourceStore.findByResourceServer(filterOptionMap, ticket.getResourceServerId(), -1, 1);
            return resource.isEmpty() ? null : (Resource)resource.get(0);
        } : ticket -> resourceStore.findById(ticket.getResourceId(), ticket.getResourceServerId());
        return StreamsUtil.paginatedStream(this.tx.getUpdatedNotRemoved(mcb).filter(StreamsUtil.distinctByKey(MapPermissionTicketEntity::getResourceId)).sorted(MapPermissionTicketEntity.COMPARE_BY_RESOURCE_ID).map(ticketResourceMapper).filter(Objects::nonNull), (Integer)first, (Integer)max).collect(Collectors.toList());
    }

    public List<Resource> findGrantedOwnerResources(String owner, int first, int max) {
        ModelCriteriaBuilder<PermissionTicket> mcb = this.permissionTicketStore.createCriteriaBuilder().compare((SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, owner);
        return StreamsUtil.paginatedStream(this.tx.getUpdatedNotRemoved(mcb).filter(StreamsUtil.distinctByKey(MapPermissionTicketEntity::getResourceId)).sorted(MapPermissionTicketEntity.COMPARE_BY_RESOURCE_ID), (Integer)first, (Integer)max).map(ticket -> this.authorizationProvider.getStoreFactory().getResourceStore().findById(ticket.getResourceId(), ticket.getResourceServerId())).collect(Collectors.toList());
    }
}

