/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.user.AbstractUserEntity;
import org.keycloak.models.map.user.MapUserAdapter;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.UserConsentEntity;
import org.keycloak.models.map.user.UserCredentialEntity;
import org.keycloak.models.map.user.UserFederatedIdentityEntity;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.client.ClientStorageProvider;

public class MapUserProvider
implements UserProvider.Streams,
UserCredentialStore.Streams {
    private static final Logger LOG = Logger.getLogger(MapUserProvider.class);
    private static final Predicate<MapUserEntity> ALWAYS_FALSE = c -> false;
    private final KeycloakSession session;
    final MapKeycloakTransaction<UUID, MapUserEntity> tx;
    private final MapStorage<UUID, MapUserEntity> userStore;

    public MapUserProvider(KeycloakSession session, MapStorage<UUID, MapUserEntity> store) {
        this.session = session;
        this.userStore = store;
        this.tx = new MapKeycloakTransaction<UUID, MapUserEntity>(this.userStore);
        session.getTransactionManager().enlist(this.tx);
    }

    private MapUserEntity registerEntityForChanges(MapUserEntity origEntity) {
        MapUserEntity res = this.tx.get((UUID)origEntity.getId(), id -> Serialization.from(origEntity));
        this.tx.putIfChanged((UUID)origEntity.getId(), res, AbstractUserEntity::isUpdated);
        return res;
    }

    private Function<MapUserEntity, UserModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapUserAdapter(this.session, realm, this.registerEntityForChanges((MapUserEntity)origEntity)){

            @Override
            public boolean checkEmailUniqueness(RealmModel realm, String email) {
                return MapUserProvider.this.getUserByEmail(email, realm) != null;
            }

            @Override
            public boolean checkUsernameUniqueness(RealmModel realm, String username) {
                return MapUserProvider.this.getUserByUsername(username, realm) != null;
            }
        };
    }

    private Predicate<MapUserEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return ALWAYS_FALSE;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    private ModelException userDoesntExistException() {
        return new ModelException("Specified user doesn't exist.");
    }

    private Optional<MapUserEntity> getEntityById(RealmModel realm, String id) {
        try {
            return this.getEntityById(realm, UUID.fromString(id));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private MapUserEntity getRegisteredEntityByIdOrThrow(RealmModel realm, String id) {
        return this.getEntityById(realm, id).map(this::registerEntityForChanges).orElseThrow(this::userDoesntExistException);
    }

    private Optional<MapUserEntity> getEntityById(RealmModel realm, UUID id) {
        MapUserEntity mapUserEntity = this.tx.get(id, this.userStore::get);
        if (mapUserEntity != null && this.entityRealmFilter(realm).test(mapUserEntity)) {
            return Optional.of(mapUserEntity);
        }
        return Optional.empty();
    }

    private Optional<MapUserEntity> getRegisteredEntityById(RealmModel realm, String id) {
        return this.getEntityById(realm, id).map(this::registerEntityForChanges);
    }

    private Stream<MapUserEntity> getNotRemovedUpdatedUsersStream() {
        Stream<MapUserEntity> updatedAndNotRemovedUsersStream = this.userStore.entrySet().stream().map(this.tx::getUpdated).filter(Objects::nonNull);
        return Stream.concat(this.tx.createdValuesStream(), updatedAndNotRemovedUsersStream);
    }

    private Stream<MapUserEntity> getUnsortedUserEntitiesStream(RealmModel realm) {
        return this.getNotRemovedUpdatedUsersStream().filter(this.entityRealmFilter(realm));
    }

    private <T> Stream<T> paginatedStream(Stream<T> originalStream, Integer first, Integer max) {
        if (first != null && first > 0) {
            originalStream = originalStream.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            originalStream = originalStream.limit(max.intValue());
        }
        return originalStream;
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        if (user == null || user.getId() == null) {
            return;
        }
        LOG.tracef("addFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialLink.getIdentityProvider(), StackUtil.getShortStackTrace()});
        this.getRegisteredEntityById(realm, user.getId()).ifPresent(userEntity -> userEntity.addFederatedIdentity(UserFederatedIdentityEntity.fromModel(socialLink)));
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        LOG.tracef("removeFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialProvider, StackUtil.getShortStackTrace()});
        return this.getRegisteredEntityById(realm, user.getId()).map(entity -> entity.removeFederatedIdentity(socialProvider)).orElse(false);
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        String socialProvider = provider.getAlias();
        LOG.tracef("preRemove[RealmModel realm, IdentityProviderModel provider](%s, %s)%s", (Object)realm, (Object)socialProvider, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).map(this::registerEntityForChanges).forEach(userEntity -> userEntity.removeFederatedIdentity(socialProvider));
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        LOG.tracef("updateFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, federatedUser.getId(), federatedIdentityModel.getIdentityProvider(), StackUtil.getShortStackTrace()});
        this.getRegisteredEntityById(realm, federatedUser.getId()).ifPresent(entity -> entity.updateFederatedIdentity(UserFederatedIdentityEntity.fromModel(federatedIdentityModel)));
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(UserModel user, RealmModel realm) {
        LOG.tracef("getFederatedIdentitiesStream(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        return this.getEntityById(realm, user.getId()).map(AbstractUserEntity::getFederatedIdentities).orElseGet(Stream::empty).map(UserFederatedIdentityEntity::toModel);
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        LOG.tracef("getFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialProvider, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, user.getId()).map(userEntity -> userEntity.getFederatedIdentity(socialProvider)).map(UserFederatedIdentityEntity::toModel).orElse(null);
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        LOG.tracef("getUserByFederatedIdentity(%s, %s)%s", (Object)realm, (Object)socialLink, StackUtil.getShortStackTrace());
        return this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> Objects.nonNull(userEntity.getFederatedIdentity(socialLink.getIdentityProvider()))).filter(userEntity -> Objects.equals(userEntity.getFederatedIdentity(socialLink.getIdentityProvider()).getUserId(), socialLink.getUserId())).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() == 0) {
                return null;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("More results found for identityProvider=" + socialLink.getIdentityProvider() + ", userId=" + socialLink.getUserId() + ", results=" + list);
            }
            return this.entityToAdapterFunc(realm).apply((MapUserEntity)list.get(0));
        }));
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        LOG.tracef("addConsent(%s, %s, %s)%s", new Object[]{realm, userId, consent, StackUtil.getShortStackTrace()});
        UserConsentEntity consentEntity = UserConsentEntity.fromModel(consent);
        this.getRegisteredEntityById(realm, userId).ifPresent(userEntity -> userEntity.addUserConsent(consentEntity));
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        LOG.tracef("getConsentByClient(%s, %s, %s)%s", new Object[]{realm, userId, clientInternalId, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, userId).map(userEntity -> userEntity.getUserConsent(clientInternalId)).map(consent -> UserConsentEntity.toModel(realm, consent)).orElse(null);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        LOG.tracef("getConsentByClientStream(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        return this.getEntityById(realm, userId).map(AbstractUserEntity::getUserConsents).orElse(Stream.empty()).map(consent -> UserConsentEntity.toModel(realm, consent));
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        LOG.tracef("updateConsent(%s, %s, %s)%s", new Object[]{realm, userId, consent, StackUtil.getShortStackTrace()});
        MapUserEntity user = this.getRegisteredEntityByIdOrThrow(realm, userId);
        UserConsentEntity userConsentEntity = user.getUserConsent(consent.getClient().getId());
        if (userConsentEntity == null) {
            throw new ModelException("Consent not found for client [" + consent.getClient().getId() + "] and user [" + userId + "]");
        }
        userConsentEntity.setGrantedClientScopesIds(consent.getGrantedClientScopes().stream().map(ClientScopeModel::getId).collect(Collectors.toSet()));
        userConsentEntity.setLastUpdatedDate(Time.currentTimeMillis());
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        LOG.tracef("revokeConsentForClient(%s, %s, %s)%s", new Object[]{realm, userId, clientInternalId, StackUtil.getShortStackTrace()});
        return this.getRegisteredEntityById(realm, userId).map(userEntity -> userEntity.removeUserConsent(clientInternalId)).orElse(false);
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        LOG.tracef("setNotBeforeForUser(%s, %s, %d)%s", new Object[]{realm, user.getId(), notBefore, StackUtil.getShortStackTrace()});
        this.getRegisteredEntityById(realm, user.getId()).ifPresent(userEntity -> userEntity.setNotBefore(notBefore));
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        LOG.tracef("getNotBeforeOfUser(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        return this.getEntityById(realm, user.getId()).map(AbstractUserEntity::getNotBefore).orElse(0);
    }

    public UserModel getServiceAccount(ClientModel client) {
        LOG.tracef("getServiceAccount(%s)%s", (Object)client.getId(), StackUtil.getShortStackTrace());
        return this.getUnsortedUserEntitiesStream(client.getRealm()).filter(userEntity -> Objects.equals(userEntity.getServiceAccountClientLink(), client.getId())).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() == 0) {
                return null;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("More service account linked users found for client=" + client.getClientId() + ", results=" + list);
            }
            return this.entityToAdapterFunc(client.getRealm()).apply((MapUserEntity)list.get(0));
        }));
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        LOG.tracef("addUser(%s, %s, %s, %s, %s)%s", new Object[]{realm, id, username, addDefaultRoles, addDefaultRequiredActions, StackUtil.getShortStackTrace()});
        if (this.getUnsortedUserEntitiesStream(realm).anyMatch(userEntity -> Objects.equals(userEntity.getUsername(), username))) {
            throw new ModelDuplicateException("User with username '" + username + "' in realm " + realm.getName() + " already exists");
        }
        UUID entityId = id == null ? UUID.randomUUID() : UUID.fromString(id);
        if (this.tx.get(entityId, this.userStore::get) != null) {
            throw new ModelDuplicateException("User exists: " + entityId);
        }
        MapUserEntity entity = new MapUserEntity(entityId, realm.getId());
        entity.setUsername(username.toLowerCase());
        entity.setCreatedTimestamp(Time.currentTimeMillis());
        this.tx.putIfAbsent(entityId, entity);
        UserModel userModel = this.entityToAdapterFunc(realm).apply(entity);
        if (addDefaultRoles) {
            DefaultRoles.addDefaultRoles((RealmModel)realm, (UserModel)userModel);
            realm.getDefaultGroupsStream().forEach(arg_0 -> ((UserModel)userModel).joinGroup(arg_0));
        }
        if (addDefaultRequiredActions) {
            realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).filter(RequiredActionProviderModel::isDefaultAction).map(RequiredActionProviderModel::getAlias).forEach(arg_0 -> ((UserModel)userModel).addRequiredAction(arg_0));
        }
        return userModel;
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove[RealmModel](%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).map(AbstractUserEntity::getId).forEach(this.tx::remove);
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        LOG.tracef("removeImportedUsers(%s, %s)%s", (Object)realm, (Object)storageProviderId, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> Objects.equals(userEntity.getFederationLink(), storageProviderId)).map(AbstractUserEntity::getId).forEach(this.tx::remove);
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        LOG.tracef("unlinkUsers(%s, %s)%s", (Object)realm, (Object)storageProviderId, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> Objects.equals(userEntity.getFederationLink(), storageProviderId)).map(this::registerEntityForChanges).forEach(userEntity -> userEntity.setFederationLink(null));
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        String roleId = role.getId();
        LOG.tracef("preRemove[RoleModel](%s, %s)%s", (Object)realm, (Object)roleId, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> userEntity.getRolesMembership().contains(roleId)).map(this::registerEntityForChanges).forEach(userEntity -> userEntity.removeRolesMembership(roleId));
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        String groupId = group.getId();
        LOG.tracef("preRemove[GroupModel](%s, %s)%s", (Object)realm, (Object)groupId, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> userEntity.getGroupsMembership().contains(groupId)).map(this::registerEntityForChanges).forEach(userEntity -> userEntity.removeGroupsMembership(groupId));
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        String clientId = client.getId();
        LOG.tracef("preRemove[ClientModel](%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> Objects.nonNull(userEntity.getUserConsent(clientId))).map(this::registerEntityForChanges).forEach(userEntity -> userEntity.removeUserConsent(clientId));
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
    }

    public void preRemove(ClientScopeModel clientScope) {
        String clientScopeId = clientScope.getId();
        LOG.tracef("preRemove[ClientScopeModel](%s)%s", (Object)clientScopeId, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(clientScope.getRealm()).map(this::registerEntityForChanges).flatMap(AbstractUserEntity::getUserConsents).forEach(consent -> consent.removeGrantedClientScopesIds(clientScopeId));
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        String componentId = component.getId();
        LOG.tracef("preRemove[ComponentModel](%s, %s)%s", (Object)realm, (Object)componentId, StackUtil.getShortStackTrace());
        if (component.getProviderType().equals(UserStorageProvider.class.getName())) {
            this.removeImportedUsers(realm, componentId);
        }
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.getUnsortedUserEntitiesStream(realm).forEach(this.removeConsentsForExternalClient(componentId));
        }
    }

    private Consumer<MapUserEntity> removeConsentsForExternalClient(String componentId) {
        return userEntity -> {
            List consentModels = userEntity.getUserConsents().filter(consent -> Objects.equals(new StorageId(consent.getClientId()).getProviderId(), componentId)).collect(Collectors.toList());
            if (consentModels.size() > 0) {
                userEntity = this.registerEntityForChanges((MapUserEntity)userEntity);
                for (UserConsentEntity consentEntity : consentModels) {
                    userEntity.removeUserConsent(consentEntity.getClientId());
                }
            }
        };
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        String roleId = role.getId();
        LOG.tracef("grantToAllUsers(%s, %s)%s", (Object)realm, (Object)roleId, StackUtil.getShortStackTrace());
        this.getUnsortedUserEntitiesStream(realm).map(this::registerEntityForChanges).forEach(entity -> entity.addRolesMembership(roleId));
    }

    public UserModel getUserById(String id, RealmModel realm) {
        LOG.tracef("getUserById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        return this.getEntityById(realm, id).map(this.entityToAdapterFunc(realm)).orElse(null);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        if (username == null) {
            return null;
        }
        String usernameLowercase = username.toLowerCase();
        LOG.tracef("getUserByUsername(%s, %s)%s", (Object)realm, (Object)username, StackUtil.getShortStackTrace());
        return this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> Objects.equals(userEntity.getUsername(), usernameLowercase)).findFirst().map(this.entityToAdapterFunc(realm)).orElse(null);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        LOG.tracef("getUserByEmail(%s, %s)%s", (Object)realm, (Object)email, StackUtil.getShortStackTrace());
        List usersWithEmail = this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> Objects.equals(userEntity.getEmail(), email)).collect(Collectors.toList());
        if (usersWithEmail.size() == 0) {
            return null;
        }
        if (usersWithEmail.size() > 1) {
            throw new ModelDuplicateException("Multiple users with email '" + email + "' exist in Keycloak.");
        }
        MapUserEntity userEntity2 = this.registerEntityForChanges((MapUserEntity)usersWithEmail.get(0));
        if (!realm.isDuplicateEmailsAllowed() && userEntity2.getEmail() != null && !userEntity2.getEmail().equals(userEntity2.getEmailConstraint())) {
            userEntity2.setEmailConstraint(userEntity2.getEmail());
        }
        return new MapUserAdapter(this.session, realm, userEntity2){

            @Override
            public boolean checkEmailUniqueness(RealmModel realm, String email) {
                return MapUserProvider.this.getUserByEmail(email, realm) != null;
            }

            @Override
            public boolean checkUsernameUniqueness(RealmModel realm, String username) {
                return MapUserProvider.this.getUserByUsername(username, realm) != null;
            }
        };
    }

    public int getUsersCount(RealmModel realm) {
        LOG.tracef("getUsersCount(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getUsersCount(realm, false);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        LOG.tracef("getUsersCount(%s, %s)%s", (Object)realm, (Object)includeServiceAccount, StackUtil.getShortStackTrace());
        Stream<MapUserEntity> unsortedUserEntitiesStream = this.getUnsortedUserEntitiesStream(realm);
        if (!includeServiceAccount) {
            unsortedUserEntitiesStream = unsortedUserEntitiesStream.filter(userEntity -> Objects.isNull(userEntity.getServiceAccountClientLink()));
        }
        return (int)unsortedUserEntitiesStream.count();
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults, boolean includeServiceAccounts) {
        LOG.tracef("getUsersStream(%s, %d, %d, %s)%s", new Object[]{realm, firstResult, maxResults, includeServiceAccounts, StackUtil.getShortStackTrace()});
        Stream<MapUserEntity> usersStream = this.getUnsortedUserEntitiesStream(realm);
        if (!includeServiceAccounts) {
            usersStream = usersStream.filter(userEntity -> Objects.isNull(userEntity.getServiceAccountClientLink()));
        }
        return this.paginatedStream(usersStream.sorted(MapUserEntity.COMPARE_BY_USERNAME), firstResult, maxResults).map(this.entityToAdapterFunc(realm));
    }

    public Stream<UserModel> getUsersStream(RealmModel realm) {
        LOG.tracef("getUsersStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getUsersStream(realm, null, null, false);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, boolean includeServiceAccounts) {
        LOG.tracef("getUsersStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getUsersStream(realm, null, null, includeServiceAccounts);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, int firstResult, int maxResults) {
        LOG.tracef("getUsersStream(%s, %d, %d)%s", new Object[]{realm, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.getUsersStream(realm, firstResult, maxResults, false);
    }

    public Stream<UserModel> searchForUserStream(String search, RealmModel realm) {
        LOG.tracef("searchForUserStream(%s, %s)%s", (Object)realm, (Object)search, StackUtil.getShortStackTrace());
        return this.searchForUserStream(search, realm, null, null);
    }

    public Stream<UserModel> searchForUserStream(String search, RealmModel realm, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForUserStream(%s, %s, %d, %d)%s", new Object[]{realm, search, firstResult, maxResults, StackUtil.getShortStackTrace()});
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("keycloak.session.realm.users.query.search", search);
        this.session.setAttribute("keycloak.session.realm.users.query.include_service_account", (Object)false);
        return this.searchForUserStream(attributes, realm, firstResult, maxResults);
    }

    public Stream<UserModel> searchForUserStream(Map<String, String> params, RealmModel realm) {
        LOG.tracef("searchForUserStream(%s, %s)%s", (Object)realm, params, StackUtil.getShortStackTrace());
        return this.searchForUserStream(params, realm, null, null);
    }

    public Stream<UserModel> searchForUserStream(Map<String, String> attributes, RealmModel realm, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForUserStream(%s, %s, %d, %d)%s", new Object[]{realm, attributes, firstResult, maxResults, StackUtil.getShortStackTrace()});
        ArrayList<Predicate<MapUserEntity>> predicatesList = new ArrayList<Predicate<MapUserEntity>>();
        if (!((Boolean)this.session.getAttributeOrDefault("keycloak.session.realm.users.query.include_service_account", (Object)true)).booleanValue()) {
            predicatesList.add(userEntity -> Objects.isNull(userEntity.getServiceAccountClientLink()));
        }
        boolean exactSearch = Boolean.parseBoolean(attributes.getOrDefault("keycloak.session.realm.users.query.exact", Boolean.FALSE.toString()));
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            String searchedString = value.toLowerCase();
            Function<Function, Predicate> containsOrExactPredicate = func -> userEntity -> this.testContainsOrExact((String)func.apply(userEntity), searchedString, exactSearch);
            switch (key) {
                case "keycloak.session.realm.users.query.search": {
                    ArrayList<Predicate<MapUserEntity>> orPredicates = new ArrayList<Predicate<MapUserEntity>>();
                    orPredicates.add(userEntity -> StringUtils.containsIgnoreCase((String)userEntity.getUsername(), (String)searchedString));
                    orPredicates.add(userEntity -> StringUtils.containsIgnoreCase((String)userEntity.getEmail(), (String)searchedString));
                    orPredicates.add(userEntity -> StringUtils.containsIgnoreCase((String)this.concatFirstNameLastName((MapUserEntity)userEntity), (String)searchedString));
                    predicatesList.add(orPredicates.stream().reduce(Predicate::or).orElse(t -> false));
                    break;
                }
                case "username": {
                    predicatesList.add(containsOrExactPredicate.apply(AbstractUserEntity::getUsername));
                    break;
                }
                case "firstName": {
                    predicatesList.add(containsOrExactPredicate.apply(AbstractUserEntity::getFirstName));
                    break;
                }
                case "lastName": {
                    predicatesList.add(containsOrExactPredicate.apply(AbstractUserEntity::getLastName));
                    break;
                }
                case "email": {
                    predicatesList.add(containsOrExactPredicate.apply(AbstractUserEntity::getEmail));
                    break;
                }
                case "emailVerified": {
                    boolean booleanValue = Boolean.parseBoolean(searchedString);
                    predicatesList.add(userEntity -> Objects.equals(userEntity.isEmailVerified(), booleanValue));
                    break;
                }
                case "enabled": {
                    boolean booleanValue = Boolean.parseBoolean(searchedString);
                    predicatesList.add(userEntity -> Objects.equals(userEntity.isEnabled(), booleanValue));
                    break;
                }
                case "keycloak.session.realm.users.query.idp_alias": {
                    predicatesList.add(mapUserEntity -> Objects.nonNull(mapUserEntity.getFederatedIdentity(value)));
                    break;
                }
                case "keycloak.session.realm.users.query.idp_user_id": {
                    predicatesList.add(mapUserEntity -> mapUserEntity.getFederatedIdentities().anyMatch(idp -> Objects.equals(idp.getUserId(), value)));
                }
            }
        }
        Set userGroups = (Set)this.session.getAttribute("keycloak.session.realm.users.query.groups");
        if (userGroups != null && userGroups.size() > 0) {
            ResourceStore resourceStore = ((AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class)).getStoreFactory().getResourceStore();
            Predicate<String> resourceByGroupIdExists = id -> resourceStore.findByResourceServer(Collections.singletonMap("name", new String[]{"group.resource." + id}), null, 0, 1).size() == 1;
            predicatesList.add(userEntity -> userEntity.getGroupsMembership().stream().filter(userGroups::contains).anyMatch(resourceByGroupIdExists));
        }
        Predicate<MapUserEntity> resultingPredicate = predicatesList.stream().reduce(Predicate::and).orElse(t -> true);
        Stream<AbstractUserEntity<?>> usersStream = this.getUnsortedUserEntitiesStream(realm).filter(resultingPredicate).sorted(AbstractUserEntity.COMPARE_BY_USERNAME);
        return this.paginatedStream(usersStream, firstResult, maxResults).map(this.entityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    private String concatFirstNameLastName(MapUserEntity entity) {
        StringBuilder stringBuilder = new StringBuilder();
        if (entity.getFirstName() != null) {
            stringBuilder.append(entity.getFirstName());
        }
        stringBuilder.append(" ");
        if (entity.getLastName() != null) {
            stringBuilder.append(entity.getLastName());
        }
        return stringBuilder.toString();
    }

    private boolean testContainsOrExact(String testedString, String searchedString, boolean exactMatch) {
        if (exactMatch) {
            return StringUtils.equalsIgnoreCase((String)testedString, (String)searchedString);
        }
        return StringUtils.containsIgnoreCase((String)testedString, (String)searchedString);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        LOG.tracef("getGroupMembersStream(%s, %s, %d, %d)%s", new Object[]{realm, group.getId(), firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.paginatedStream(this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> userEntity.getGroupsMembership().contains(group.getId())).sorted(MapUserEntity.COMPARE_BY_USERNAME), firstResult, maxResults).map(this.entityToAdapterFunc(realm));
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        LOG.tracef("getGroupMembersStream(%s, %s)%s", (Object)realm, (Object)group.getId(), StackUtil.getShortStackTrace());
        return this.getGroupMembersStream(realm, group, null, null);
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(String attrName, String attrValue, RealmModel realm) {
        LOG.tracef("searchForUserByUserAttributeStream(%s, %s, %s)%s", new Object[]{realm, attrName, attrValue, StackUtil.getShortStackTrace()});
        return this.getUnsortedUserEntitiesStream(realm).filter(userEntity -> userEntity.getAttribute(attrName).contains(attrValue)).map(this.entityToAdapterFunc(realm)).sorted(UserModel.COMPARE_BY_USERNAME);
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, null, username.toLowerCase(), true, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        String userId = user.getId();
        Optional<MapUserEntity> userById = this.getEntityById(realm, userId);
        if (userById.isPresent()) {
            this.tx.remove(UUID.fromString(userId));
            return true;
        }
        return false;
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        LOG.tracef("getRoleMembersStream(%s, %s, %d, %d)%s", new Object[]{realm, role, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.paginatedStream(this.getUnsortedUserEntitiesStream(realm).filter(entity -> entity.getRolesMembership().contains(role.getId())).sorted(MapUserEntity.COMPARE_BY_USERNAME), firstResult, maxResults).map(this.entityToAdapterFunc(realm));
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.getRegisteredEntityById(realm, user.getId()).ifPresent(this.updateCredential(cred));
    }

    private Consumer<MapUserEntity> updateCredential(CredentialModel credentialModel) {
        return user -> {
            UserCredentialEntity credentialEntity = user.getCredential(credentialModel.getId());
            if (credentialEntity == null) {
                return;
            }
            credentialEntity.setCreatedDate(credentialModel.getCreatedDate());
            credentialEntity.setUserLabel(credentialModel.getUserLabel());
            credentialEntity.setType(credentialModel.getType());
            credentialEntity.setSecretData(credentialModel.getSecretData());
            credentialEntity.setCredentialData(credentialModel.getCredentialData());
        };
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        LOG.tracef("createCredential(%s, %s, %s)%s", new Object[]{realm, user.getId(), cred.getId(), StackUtil.getShortStackTrace()});
        UserCredentialEntity credentialEntity = UserCredentialEntity.fromModel(cred);
        this.getRegisteredEntityByIdOrThrow(realm, user.getId()).addCredential(credentialEntity);
        return UserCredentialEntity.toModel(credentialEntity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        LOG.tracef("removeStoredCredential(%s, %s, %s)%s", new Object[]{realm, user.getId(), id, StackUtil.getShortStackTrace()});
        return this.getRegisteredEntityById(realm, user.getId()).map(mapUserEntity -> mapUserEntity.removeCredential(id)).orElse(false);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        LOG.tracef("getStoredCredentialById(%s, %s, %s)%s", new Object[]{realm, user.getId(), id, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, user.getId()).map(mapUserEntity -> mapUserEntity.getCredential(id)).map(UserCredentialEntity::toModel).orElse(null);
    }

    public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, UserModel user) {
        LOG.tracef("getStoredCredentialsStream(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        return this.getEntityById(realm, user.getId()).map(AbstractUserEntity::getCredentials).orElseGet(Stream::empty).map(UserCredentialEntity::toModel);
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, UserModel user, String type) {
        LOG.tracef("getStoredCredentialsByTypeStream(%s, %s, %s)%s", new Object[]{realm, user.getId(), type, StackUtil.getShortStackTrace()});
        return this.getStoredCredentialsStream(realm, user).filter(credential -> Objects.equals(type, credential.getType()));
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        LOG.tracef("getStoredCredentialByNameAndType(%s, %s, %s, %s)%s", new Object[]{realm, user.getId(), name, type, StackUtil.getShortStackTrace()});
        return this.getStoredCredentialsByType(realm, user, type).stream().filter(credential -> Objects.equals(name, credential.getUserLabel())).findFirst().orElse(null);
    }

    public boolean moveCredentialTo(RealmModel realm, UserModel user, String id, String newPreviousCredentialId) {
        LOG.tracef("moveCredentialTo(%s, %s, %s, %s)%s", new Object[]{realm, user.getId(), id, newPreviousCredentialId, StackUtil.getShortStackTrace()});
        String userId = user.getId();
        MapUserEntity userEntity = this.getRegisteredEntityById(realm, userId).orElse(null);
        if (userEntity == null) {
            LOG.warnf("User with id: [%s] not found", (Object)userId);
            return false;
        }
        int newPreviousCredentialIdIndex = -1;
        if (newPreviousCredentialId != null && (newPreviousCredentialIdIndex = userEntity.getCredentialIndex(newPreviousCredentialId)) == -1) {
            LOG.warnf("Credential with id: [%s] for user: [%s] not found", (Object)newPreviousCredentialId, (Object)userId);
            return false;
        }
        int currentPositionOfId = userEntity.getCredentialIndex(id);
        if (currentPositionOfId == -1) {
            LOG.warnf("Credential with id: [%s] for user: [%s] not found", (Object)id, (Object)userId);
            return false;
        }
        if (currentPositionOfId < newPreviousCredentialIdIndex) {
            --newPreviousCredentialIdIndex;
        }
        userEntity.moveCredential(currentPositionOfId, newPreviousCredentialIdIndex + 1);
        return true;
    }

    public void close() {
    }
}

