/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.common.StreamUtils;
import org.keycloak.models.map.role.AbstractRoleEntity;
import org.keycloak.models.map.role.MapRoleAdapter;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.provider.ProviderEvent;

public class MapRoleProvider
implements RoleProvider {
    private static final Logger LOG = Logger.getLogger(MapRoleProvider.class);
    private static final Predicate<MapRoleEntity> ALWAYS_FALSE = role -> false;
    private final KeycloakSession session;
    final MapKeycloakTransaction<UUID, MapRoleEntity> tx;
    private final MapStorage<UUID, MapRoleEntity> roleStore;
    private static final Comparator<MapRoleEntity> COMPARE_BY_NAME = new Comparator<MapRoleEntity>(){

        @Override
        public int compare(MapRoleEntity o1, MapRoleEntity o2) {
            String r2;
            String r1 = o1 == null ? null : o1.getName();
            String string = r2 = o2 == null ? null : o2.getName();
            return r1 == r2 ? 0 : (r1 == null ? -1 : (r2 == null ? 1 : r1.compareTo(r2)));
        }
    };

    public MapRoleProvider(KeycloakSession session, MapStorage<UUID, MapRoleEntity> roleStore) {
        this.session = session;
        this.roleStore = roleStore;
        this.tx = new MapKeycloakTransaction<UUID, MapRoleEntity>(roleStore);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapRoleEntity, RoleModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapRoleAdapter(this.session, realm, this.registerEntityForChanges((MapRoleEntity)origEntity));
    }

    private MapRoleEntity registerEntityForChanges(MapRoleEntity origEntity) {
        MapRoleEntity res = Serialization.from(origEntity);
        this.tx.putIfChanged((UUID)origEntity.getId(), res, AbstractRoleEntity::isUpdated);
        return res;
    }

    private Predicate<MapRoleEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return ALWAYS_FALSE;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    private Predicate<MapRoleEntity> entityClientFilter(ClientModel client) {
        if (client == null || client.getId() == null) {
            return ALWAYS_FALSE;
        }
        String clientId = client.getId();
        return entity -> entity.isClientRole() && Objects.equals(clientId, entity.getClientId());
    }

    private Stream<MapRoleEntity> getNotRemovedUpdatedRolesStream(RealmModel realm) {
        Stream<MapRoleEntity> updatedAndNotRemovedRolesStream = this.roleStore.entrySet().stream().map(this.tx::getUpdated).filter(Objects::nonNull);
        return Stream.concat(this.tx.createdValuesStream(), updatedAndNotRemovedRolesStream).filter(this.entityRealmFilter(realm));
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        UUID entityId = id == null ? UUID.randomUUID() : UUID.fromString(id);
        LOG.tracef("addRealmRole(%s, %s, %s)%s", new Object[]{realm.getName(), id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = new MapRoleEntity(entityId, realm.getId());
        entity.setName(name);
        entity.setRealmId(realm.getId());
        if (this.tx.get((UUID)entity.getId(), this.roleStore::get) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        this.tx.putIfAbsent((UUID)entity.getId(), entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        Stream<RoleModel> s = this.getRealmRolesStream(realm);
        if (first != null && first >= 0) {
            s = s.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            s = s.limit(max.intValue());
        }
        return s;
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm) {
        return this.getNotRemovedUpdatedRolesStream(realm).filter(this::isRealmRole).sorted(COMPARE_BY_NAME).map(this.entityToAdapterFunc(realm));
    }

    private boolean isRealmRole(MapRoleEntity role) {
        return !role.isClientRole();
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        if (this.getClientRole(client, name) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        UUID entityId = id == null ? UUID.randomUUID() : UUID.fromString(id);
        LOG.tracef("addClientRole(%s, %s, %s)%s", new Object[]{client.getClientId(), id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = new MapRoleEntity(entityId, client.getRealm().getId());
        entity.setName(name);
        entity.setClientRole(true);
        entity.setClientId(client.getId());
        if (this.tx.get((UUID)entity.getId(), this.roleStore::get) != null) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        this.tx.putIfAbsent((UUID)entity.getId(), entity);
        return this.entityToAdapterFunc(client.getRealm()).apply(entity);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        Stream<RoleModel> s = this.getClientRolesStream(client);
        if (first != null && first > 0) {
            s = s.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            s = s.limit(max.intValue());
        }
        return s;
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client) {
        return this.getNotRemovedUpdatedRolesStream(client.getRealm()).filter(this.entityClientFilter(client)).sorted(COMPARE_BY_NAME).map(this.entityToAdapterFunc(client.getRealm()));
    }

    public boolean removeRole(final RoleModel role) {
        LOG.tracef("removeRole(%s(%s))%s", (Object)role.getName(), (Object)role.getId(), StackUtil.getShortStackTrace());
        RealmModel realm = role.isClientRole() ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer();
        this.session.users().preRemove(realm, role);
        RoleContainerModel container = role.getContainer();
        if (container.getDefaultRolesStream().anyMatch(r -> Objects.equals(r, role.getName()))) {
            container.removeDefaultRoles(new String[]{role.getName()});
        }
        try (Stream<MapRoleEntity> baseStream = this.getNotRemovedUpdatedRolesStream(realm).filter(this::isRealmRole).filter(AbstractRoleEntity::isComposite);){
            StreamUtils.leftInnerJoinIterable(baseStream, AbstractRoleEntity::getCompositeRoles).filter(pair -> role.getId().equals(pair.getV())).collect(Collectors.toSet()).forEach(pair -> {
                MapRoleEntity origEntity = (MapRoleEntity)pair.getK();
                this.registerEntityForChanges(origEntity);
                origEntity.removeCompositeRole(role.getId());
            });
        }
        this.session.clients().getClientsStream(realm).forEach(client -> {
            client.deleteScopeMapping(role);
            try (Stream<MapRoleEntity> baseStream = this.getNotRemovedUpdatedRolesStream(client.getRealm()).filter(this.entityClientFilter((ClientModel)client)).filter(AbstractRoleEntity::isComposite);){
                StreamUtils.leftInnerJoinIterable(baseStream, AbstractRoleEntity::getCompositeRoles).filter(pair -> role.getId().equals(pair.getV())).collect(Collectors.toSet()).forEach(pair -> {
                    MapRoleEntity origEntity = (MapRoleEntity)pair.getK();
                    this.registerEntityForChanges(origEntity);
                    origEntity.removeCompositeRole(role.getId());
                });
            }
        });
        this.session.groups().preRemove(realm, role);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RoleContainerModel.RoleRemovedEvent(){

            public RoleModel getRole() {
                return role;
            }

            public KeycloakSession getKeycloakSession() {
                return MapRoleProvider.this.session;
            }
        });
        this.tx.remove(UUID.fromString(role.getId()));
        return true;
    }

    public void removeRoles(RealmModel realm) {
        this.getRealmRolesStream(realm).forEach(this::removeRole);
    }

    public void removeRoles(ClientModel client) {
        this.getClientRolesStream(client).forEach(this::removeRole);
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmRole(%s, %s)%s", (Object)realm.getName(), (Object)name, StackUtil.getShortStackTrace());
        String roleNameLower = name.toLowerCase();
        String roleId = this.getNotRemovedUpdatedRolesStream(realm).filter(entity -> entity.getName() != null && Objects.equals(entity.getName().toLowerCase(), roleNameLower)).map(this.entityToAdapterFunc(realm)).map(RoleModel::getId).findFirst().orElse(null);
        return roleId == null ? null : this.session.roles().getRoleById(realm, roleId);
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getClientRole(%s, %s)%s", (Object)client.getClientId(), (Object)name, StackUtil.getShortStackTrace());
        String roleNameLower = name.toLowerCase();
        String roleId = this.getNotRemovedUpdatedRolesStream(client.getRealm()).filter(this.entityClientFilter(client)).filter(entity -> entity.getName() != null && Objects.equals(entity.getName().toLowerCase(), roleNameLower)).map(this.entityToAdapterFunc(client.getRealm())).map(RoleModel::getId).findFirst().orElse(null);
        return roleId == null ? null : this.session.roles().getRoleById(client.getRealm(), roleId);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getRoleById(%s, %s)%s", (Object)realm.getName(), (Object)id, StackUtil.getShortStackTrace());
        MapRoleEntity entity = this.tx.get(UUID.fromString(id), this.roleStore::get);
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        String searchLower = search.toLowerCase();
        Stream<MapRoleEntity> s = this.getNotRemovedUpdatedRolesStream(realm).filter(entity -> entity.getName() != null && entity.getName().toLowerCase().contains(searchLower) || entity.getDescription() != null && entity.getDescription().toLowerCase().contains(searchLower)).sorted(COMPARE_BY_NAME);
        if (first != null && first > 0) {
            s = s.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            s = s.limit(max.intValue());
        }
        return s.map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        String searchLower = search.toLowerCase();
        Stream<MapRoleEntity> s = this.getNotRemovedUpdatedRolesStream(client.getRealm()).filter(this.entityClientFilter(client)).filter(entity -> entity.getName() != null && entity.getName().toLowerCase().contains(searchLower) || entity.getDescription() != null && entity.getDescription().toLowerCase().contains(searchLower)).sorted(COMPARE_BY_NAME);
        if (first != null && first > 0) {
            s = s.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            s = s.limit(max.intValue());
        }
        return s.map(this.entityToAdapterFunc(client.getRealm()));
    }

    public void close() {
    }
}

