/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.group.AbstractGroupModel;
import org.keycloak.models.map.group.MapGroupEntity;

public class MapGroupAdapter
extends AbstractGroupModel<MapGroupEntity> {
    public MapGroupAdapter(KeycloakSession session, RealmModel realm, MapGroupEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return ((UUID)((MapGroupEntity)this.entity).getId()).toString();
    }

    public String getName() {
        return ((MapGroupEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((MapGroupEntity)this.entity).setName(name);
    }

    public void setSingleAttribute(String name, String value) {
        ((MapGroupEntity)this.entity).setAttribute(name, Collections.singletonList(value));
    }

    public void setAttribute(String name, List<String> values) {
        ((MapGroupEntity)this.entity).setAttribute(name, values);
    }

    public void removeAttribute(String name) {
        ((MapGroupEntity)this.entity).removeAttribute(name);
    }

    public String getFirstAttribute(String name) {
        List<String> attributeValues = ((MapGroupEntity)this.entity).getAttribute(name);
        if (attributeValues == null) {
            return null;
        }
        return attributeValues.get(0);
    }

    public Stream<String> getAttributeStream(String name) {
        List<String> attributes = ((MapGroupEntity)this.entity).getAttribute(name);
        if (attributes == null || attributes.isEmpty()) {
            return Stream.empty();
        }
        return attributes.stream();
    }

    public Map<String, List<String>> getAttributes() {
        return ((MapGroupEntity)this.entity).getAttributes();
    }

    public GroupModel getParent() {
        String parentId = this.getParentId();
        if (parentId == null) {
            return null;
        }
        return this.session.groups().getGroupById(this.realm, parentId);
    }

    public String getParentId() {
        return ((MapGroupEntity)this.entity).getParentId();
    }

    public Stream<GroupModel> getSubGroupsStream() {
        return this.session.groups().getGroupsStream(this.realm).filter(groupModel -> this.getId().equals(groupModel.getParentId()));
    }

    public void setParent(GroupModel group) {
        if (group == null) {
            ((MapGroupEntity)this.entity).setParentId(null);
            return;
        }
        if (!this.getId().equals(group.getId())) {
            ((MapGroupEntity)this.entity).setParentId(group.getId());
        }
    }

    public void addChild(GroupModel subGroup) {
        subGroup.setParent((GroupModel)this);
    }

    public void removeChild(GroupModel subGroup) {
        if (this.getId().equals(subGroup.getParentId())) {
            subGroup.setParent(null);
        }
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return this.getRoleMappingsStream().filter(roleModel -> roleModel.getContainer() instanceof RealmModel);
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        String clientId = app.getId();
        return this.getRoleMappingsStream().filter(roleModel -> roleModel.getContainer() instanceof ClientModel).filter(roleModel -> roleModel.getContainer().getId().equals(clientId));
    }

    public boolean hasRole(RoleModel role) {
        return ((MapGroupEntity)this.entity).getGrantedRoles().contains(role.getId());
    }

    public void grantRole(RoleModel role) {
        ((MapGroupEntity)this.entity).addGrantedRole(role.getId());
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        return ((MapGroupEntity)this.entity).getGrantedRoles().stream().map(roleId -> this.session.roles().getRoleById(this.realm, roleId));
    }

    public void deleteRoleMapping(RoleModel role) {
        ((MapGroupEntity)this.entity).removeRole(role.getId());
    }
}

