/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import com.google.common.base.Functions;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.client.AbstractClientModel;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class MapClientAdapter
extends AbstractClientModel<MapClientEntity>
implements ClientModel {
    public MapClientAdapter(KeycloakSession session, RealmModel realm, MapClientEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return ((UUID)((MapClientEntity)this.entity).getId()).toString();
    }

    public String getClientId() {
        return ((MapClientEntity)this.entity).getClientId();
    }

    public void setClientId(String clientId) {
        ((MapClientEntity)this.entity).setClientId(clientId);
    }

    public String getName() {
        return ((MapClientEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((MapClientEntity)this.entity).setName(name);
    }

    public String getDescription() {
        return ((MapClientEntity)this.entity).getDescription();
    }

    public void setDescription(String description) {
        ((MapClientEntity)this.entity).setDescription(description);
    }

    public boolean isEnabled() {
        return ((MapClientEntity)this.entity).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        ((MapClientEntity)this.entity).setEnabled(enabled);
    }

    public boolean isAlwaysDisplayInConsole() {
        return ((MapClientEntity)this.entity).isAlwaysDisplayInConsole();
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        ((MapClientEntity)this.entity).setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    public boolean isSurrogateAuthRequired() {
        return ((MapClientEntity)this.entity).isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        ((MapClientEntity)this.entity).setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public Set<String> getWebOrigins() {
        return ((MapClientEntity)this.entity).getWebOrigins();
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ((MapClientEntity)this.entity).setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        ((MapClientEntity)this.entity).addWebOrigin(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        ((MapClientEntity)this.entity).removeWebOrigin(webOrigin);
    }

    public Set<String> getRedirectUris() {
        return ((MapClientEntity)this.entity).getRedirectUris();
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ((MapClientEntity)this.entity).setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        ((MapClientEntity)this.entity).addRedirectUri(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        ((MapClientEntity)this.entity).removeRedirectUri(redirectUri);
    }

    public String getManagementUrl() {
        return ((MapClientEntity)this.entity).getManagementUrl();
    }

    public void setManagementUrl(String url) {
        ((MapClientEntity)this.entity).setManagementUrl(url);
    }

    public String getRootUrl() {
        return ((MapClientEntity)this.entity).getRootUrl();
    }

    public void setRootUrl(String url) {
        ((MapClientEntity)this.entity).setRootUrl(url);
    }

    public String getBaseUrl() {
        return ((MapClientEntity)this.entity).getBaseUrl();
    }

    public void setBaseUrl(String url) {
        ((MapClientEntity)this.entity).setBaseUrl(url);
    }

    public boolean isBearerOnly() {
        return ((MapClientEntity)this.entity).isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        ((MapClientEntity)this.entity).setBearerOnly(only);
    }

    public String getClientAuthenticatorType() {
        return ((MapClientEntity)this.entity).getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        ((MapClientEntity)this.entity).setClientAuthenticatorType(clientAuthenticatorType);
    }

    public boolean validateSecret(String secret) {
        return MessageDigest.isEqual(secret.getBytes(), ((MapClientEntity)this.entity).getSecret().getBytes());
    }

    public String getSecret() {
        return ((MapClientEntity)this.entity).getSecret();
    }

    public void setSecret(String secret) {
        ((MapClientEntity)this.entity).setSecret(secret);
    }

    public int getNodeReRegistrationTimeout() {
        return ((MapClientEntity)this.entity).getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        ((MapClientEntity)this.entity).setNodeReRegistrationTimeout(timeout);
    }

    public String getRegistrationToken() {
        return ((MapClientEntity)this.entity).getRegistrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        ((MapClientEntity)this.entity).setRegistrationToken(registrationToken);
    }

    public String getProtocol() {
        return ((MapClientEntity)this.entity).getProtocol();
    }

    public void setProtocol(String protocol) {
        ((MapClientEntity)this.entity).setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        ((MapClientEntity)this.entity).setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        ((MapClientEntity)this.entity).removeAttribute(name);
    }

    public String getAttribute(String name) {
        return ((MapClientEntity)this.entity).getAttribute(name);
    }

    public Map<String, String> getAttributes() {
        return ((MapClientEntity)this.entity).getAttributes();
    }

    public String getAuthenticationFlowBindingOverride(String binding) {
        return ((MapClientEntity)this.entity).getAuthenticationFlowBindingOverride(binding);
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return ((MapClientEntity)this.entity).getAuthenticationFlowBindingOverrides();
    }

    public void removeAuthenticationFlowBindingOverride(String binding) {
        ((MapClientEntity)this.entity).removeAuthenticationFlowBindingOverride(binding);
    }

    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        ((MapClientEntity)this.entity).setAuthenticationFlowBindingOverride(binding, flowId);
    }

    public boolean isFrontchannelLogout() {
        return ((MapClientEntity)this.entity).isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        ((MapClientEntity)this.entity).setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        return ((MapClientEntity)this.entity).isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        ((MapClientEntity)this.entity).setFullScopeAllowed(value);
    }

    public boolean isPublicClient() {
        return ((MapClientEntity)this.entity).isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        ((MapClientEntity)this.entity).setPublicClient(flag);
    }

    public boolean isConsentRequired() {
        return ((MapClientEntity)this.entity).isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        ((MapClientEntity)this.entity).setConsentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        return ((MapClientEntity)this.entity).isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        ((MapClientEntity)this.entity).setStandardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        return ((MapClientEntity)this.entity).isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        ((MapClientEntity)this.entity).setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        return ((MapClientEntity)this.entity).isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        ((MapClientEntity)this.entity).setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        return ((MapClientEntity)this.entity).isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        ((MapClientEntity)this.entity).setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return ((MapClientEntity)this.entity).getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        ((MapClientEntity)this.entity).setNotBefore(notBefore);
    }

    public void addClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        String id;
        String string = id = clientScope == null ? null : clientScope.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).addClientScope(id, defaultScope);
        }
    }

    public void removeClientScope(ClientScopeModel clientScope) {
        String id;
        String string = id = clientScope == null ? null : clientScope.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).removeClientScope(id);
        }
    }

    public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope, boolean filterByProtocol) {
        Stream<ClientScopeModel> res = ((MapClientEntity)this.entity).getClientScopes(defaultScope).map(arg_0 -> ((RealmModel)this.realm).getClientScopeById(arg_0)).filter(Objects::nonNull);
        if (filterByProtocol) {
            String clientProtocol = this.getProtocol() == null ? "openid-connect" : this.getProtocol();
            res = res.filter(cs -> Objects.equals(cs.getProtocol(), clientProtocol));
        }
        return res.collect(Collectors.toMap(ClientScopeModel::getName, Functions.identity()));
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        return ((MapClientEntity)this.entity).getScopeMappings().stream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull);
    }

    public void addScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).addScopeMapping(id);
        }
    }

    public void deleteScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).deleteScopeMapping(id);
        }
    }

    public boolean hasScope(RoleModel role) {
        String id;
        if (this.isFullScopeAllowed()) {
            return true;
        }
        String string = id = role == null ? null : role.getId();
        if (id != null && ((MapClientEntity)this.entity).getScopeMappings().contains(id)) {
            return true;
        }
        if (this.getScopeMappingsStream().anyMatch(r -> r.hasRole(role))) {
            return true;
        }
        return this.getRolesStream().anyMatch(r -> Objects.equals(r, role) || r.hasRole(role));
    }

    public Stream<String> getDefaultRolesStream() {
        return ((MapClientEntity)this.entity).getDefaultRoles().stream();
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        ((MapClientEntity)this.entity).addDefaultRole(name);
    }

    public void removeDefaultRoles(String ... defaultRoles) {
        ((MapClientEntity)this.entity).removeDefaultRoles(defaultRoles);
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        return ((MapClientEntity)this.entity).getProtocolMappers().stream().distinct();
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (model == null) {
            return null;
        }
        ProtocolMapperModel pm = new ProtocolMapperModel();
        pm.setId(KeycloakModelUtils.generateId());
        pm.setName(model.getName());
        pm.setProtocol(model.getProtocol());
        pm.setProtocolMapper(model.getProtocolMapper());
        if (model.getConfig() != null) {
            pm.setConfig(new HashMap(model.getConfig()));
        } else {
            pm.setConfig(new HashMap());
        }
        return ((MapClientEntity)this.entity).addProtocolMapper(pm);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).removeProtocolMapper(id);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientEntity)this.entity).updateProtocolMapper(id, mapping);
        }
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return ((MapClientEntity)this.entity).getProtocolMapperById(id);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        return ((MapClientEntity)this.entity).getProtocolMappers().stream().filter(pm -> Objects.equals(pm.getProtocol(), protocol) && Objects.equals(pm.getName(), name)).findAny().orElse(null);
    }
}

