/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authSession.AbstractRootAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapAuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionAdapter;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.utils.RealmInfoUtil;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapRootAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private static final Logger LOG = Logger.getLogger(MapRootAuthenticationSessionProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<UUID, MapRootAuthenticationSessionEntity> tx;
    private final MapStorage<UUID, MapRootAuthenticationSessionEntity> sessionStore;
    private static final Predicate<MapRootAuthenticationSessionEntity> ALWAYS_FALSE = role -> false;
    private static final String AUTHENTICATION_SESSION_EVENTS = "AUTHENTICATION_SESSION_EVENTS";

    public MapRootAuthenticationSessionProvider(KeycloakSession session, MapStorage<UUID, MapRootAuthenticationSessionEntity> sessionStore) {
        this.session = session;
        this.sessionStore = sessionStore;
        this.tx = new MapKeycloakTransaction<UUID, MapRootAuthenticationSessionEntity>(sessionStore);
        session.getTransactionManager().enlistAfterCompletion(this.tx);
    }

    private Function<MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapRootAuthenticationSessionAdapter(this.session, realm, this.registerEntityForChanges((MapRootAuthenticationSessionEntity)origEntity));
    }

    private MapRootAuthenticationSessionEntity registerEntityForChanges(MapRootAuthenticationSessionEntity origEntity) {
        MapRootAuthenticationSessionEntity res = this.tx.get((UUID)origEntity.getId(), id -> Serialization.from(origEntity));
        this.tx.putIfChanged((UUID)origEntity.getId(), res, AbstractRootAuthenticationSessionEntity::isUpdated);
        return res;
    }

    private Predicate<MapRootAuthenticationSessionEntity> entityRealmFilter(String realmId) {
        if (realmId == null) {
            return ALWAYS_FALSE;
        }
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        return this.createRootAuthenticationSession(realm, null);
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm, String id) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        UUID entityId = id == null ? UUID.randomUUID() : UUID.fromString(id);
        LOG.tracef("createRootAuthenticationSession(%s)%s", (Object)realm.getName(), StackUtil.getShortStackTrace());
        MapRootAuthenticationSessionEntity entity = new MapRootAuthenticationSessionEntity(entityId, realm.getId());
        entity.setRealmId(realm.getId());
        entity.setTimestamp(Time.currentTime());
        if (this.tx.get((UUID)entity.getId(), this.sessionStore::get) != null) {
            throw new ModelDuplicateException("Root authentication session exists: " + entity.getId());
        }
        this.tx.putIfAbsent((UUID)entity.getId(), entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public RootAuthenticationSessionModel getRootAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        if (authenticationSessionId == null) {
            return null;
        }
        LOG.tracef("getRootAuthenticationSession(%s, %s)%s", (Object)realm.getName(), (Object)authenticationSessionId, StackUtil.getShortStackTrace());
        MapRootAuthenticationSessionEntity entity = this.tx.get(UUID.fromString(authenticationSessionId), this.sessionStore::get);
        return entity == null || !this.entityRealmFilter(realm.getId()).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public void removeRootAuthenticationSession(RealmModel realm, RootAuthenticationSessionModel authenticationSession) {
        Objects.requireNonNull(authenticationSession, "The provided root authentication session can't be null!");
        this.tx.remove(UUID.fromString(authenticationSession.getId()));
    }

    public void removeExpired(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        LOG.debugf("Removing expired sessions", new Object[0]);
        int expired = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        List<UUID> sessionIds = this.sessionStore.entrySet().stream().filter(entity -> this.entityRealmFilter(realm.getId()).test((MapRootAuthenticationSessionEntity)entity.getValue())).filter(entity -> ((MapRootAuthenticationSessionEntity)entity.getValue()).getTimestamp() < expired).map(Map.Entry::getKey).collect(Collectors.toList());
        LOG.debugf("Removed %d expired authentication sessions for realm '%s'", sessionIds.size(), (Object)realm.getName());
        sessionIds.forEach(this.tx::remove);
    }

    public void onRealmRemoved(RealmModel realm) {
        Objects.requireNonNull(realm, "The provided realm can't be null!");
        this.sessionStore.entrySet().stream().filter(entity -> this.entityRealmFilter(realm.getId()).test((MapRootAuthenticationSessionEntity)entity.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(this.tx::remove);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public void updateNonlocalSessionAuthNotes(AuthenticationSessionCompoundId compoundId, Map<String, String> authNotesFragment) {
        if (compoundId == null) {
            return;
        }
        Objects.requireNonNull(authNotesFragment, "The provided authentication's notes map can't be null!");
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify(AUTHENTICATION_SESSION_EVENTS, (ClusterEvent)MapAuthenticationSessionAuthNoteUpdateEvent.create(compoundId.getRootSessionId(), compoundId.getTabId(), compoundId.getClientUUID(), authNotesFragment), true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }

    public void close() {
    }
}

