/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractEntity;

public abstract class AbstractClientModel<E extends AbstractEntity>
implements ClientModel {
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final E entity;

    public AbstractClientModel(KeycloakSession session, RealmModel realm, E entity) {
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(realm, "realm");
        this.session = session;
        this.realm = realm;
        this.entity = entity;
    }

    public void addClientScopes(Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        for (ClientScopeModel cs : clientScopes) {
            this.addClientScope(cs, defaultScope);
        }
    }

    public Set<RoleModel> getRealmScopeMappings() {
        String realmId = this.realm.getId();
        return this.getScopeMappingsStream().filter(rm -> Objects.equals(rm.getContainerId(), realmId)).collect(Collectors.toSet());
    }

    public RoleModel getRole(String name) {
        return this.session.realms().getClientRole(this.realm, (ClientModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.realms().addClientRole(this.realm, (ClientModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.realms().addClientRole(this.realm, (ClientModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.session.realms().removeRole(this.realm, role);
    }

    public Set<RoleModel> getRoles() {
        return this.session.realms().getClientRoles(this.realm, (ClientModel)this);
    }

    public Set<RoleModel> getRoles(Integer firstResult, Integer maxResults) {
        return this.session.realms().getClientRoles(this.realm, (ClientModel)this, firstResult, maxResults);
    }

    public Set<RoleModel> searchForRoles(String search, Integer first, Integer max) {
        return this.session.realms().searchForClientRoles(this.realm, (ClientModel)this, search, first, max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return Objects.equals(that.getId(), this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

