/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.SessionAttributesUtils;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ldap.LdapMapStorage;
import org.keycloak.models.map.storage.ldap.LdapMapStorageProviderFactory;

public class LdapMapStorageProvider
implements MapStorageProvider {
    private final KeycloakSession session;
    private final LdapMapStorageProviderFactory factory;
    private final int factoryId;

    public LdapMapStorageProvider(KeycloakSession session, LdapMapStorageProviderFactory factory, int factoryId) {
        this.session = session;
        this.factory = factory;
        this.factoryId = factoryId;
    }

    public void close() {
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getMapStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        return SessionAttributesUtils.createMapStorageIfAbsent((KeycloakSession)this.session, this.getClass(), modelType, (int)this.factoryId, () -> {
            LdapMapStorage store = (LdapMapStorage)this.factory.createMapStorage(this.session, modelType);
            this.session.getTransactionManager().enlist((KeycloakTransaction)store);
            return store;
        });
    }
}

