/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.QueryParameters;

public abstract class LdapMapStorage<RE, E extends AbstractEntity & UpdatableEntity, M>
implements MapStorage<E, M>,
KeycloakTransaction {
    private boolean active;
    private boolean rollback;
    protected final LinkedList<MapTaskWithValue> tasksOnRollback = new LinkedList();
    protected final LinkedList<MapTaskWithValue> tasksOnCommit = new LinkedList();
    protected final Map<String, RE> entities = new HashMap<String, RE>();

    public long getCount(QueryParameters<M> queryParameters) {
        return this.read(queryParameters).count();
    }

    public long delete(QueryParameters<M> queryParameters) {
        return this.read(queryParameters).map(m -> this.delete(m.getId()) ? 1 : 0).collect(Collectors.summarizingLong(val -> val.intValue())).getSum();
    }

    public void begin() {
        this.active = true;
    }

    public void commit() {
        if (this.rollback) {
            throw new RuntimeException("Rollback only!");
        }
    }

    public void rollback() {
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        return this.rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    protected static abstract class DeleteOperation
    extends MapTaskWithValue {
        protected DeleteOperation() {
        }
    }

    protected static abstract class MapTaskWithValue {
        protected MapTaskWithValue() {
        }

        public abstract void execute();
    }
}

