/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.store;

import org.keycloak.models.map.storage.ldap.store.LdapMapEscapeStrategy;

public class LdapMapOctetStringEncoder {
    private final LdapMapEscapeStrategy fallback;

    public LdapMapOctetStringEncoder() {
        this(null);
    }

    public LdapMapOctetStringEncoder(LdapMapEscapeStrategy fallback) {
        this.fallback = fallback;
    }

    public String encode(Object parameterValue, boolean isBinary) {
        String escaped = parameterValue instanceof byte[] ? LdapMapEscapeStrategy.escapeHex((byte[])parameterValue) : this.escapeAsString(parameterValue, isBinary);
        return escaped;
    }

    private String escapeAsString(Object parameterValue, boolean isBinary) {
        String stringValue = parameterValue.toString();
        String escaped = isBinary ? LdapMapEscapeStrategy.OCTET_STRING.escape(stringValue) : (this.fallback == null ? stringValue : this.fallback.escape(stringValue));
        return escaped;
    }
}

