/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ldap.LdapMapStorageProvider;
import org.keycloak.models.map.storage.ldap.config.LdapMapConfig;
import org.keycloak.models.map.storage.ldap.role.LdapRoleMapKeycloakTransaction;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class LdapMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "ldap-map-storage";
    private static final AtomicInteger SESSION_TX_PREFIX_ENUMERATOR = new AtomicInteger(0);
    private static final String SESSION_TX_PREFIX = "ldap-map-tx-";
    private final String sessionTxPrefixForFactoryInstance = "ldap-map-tx-" + SESSION_TX_PREFIX_ENUMERATOR.getAndIncrement() + "-";
    private Config.Scope config;
    private static final Map<Class<?>, LdapRoleMapKeycloakTransaction.LdapRoleMapKeycloakTransactionFunction<KeycloakSession, Config.Scope, MapKeycloakTransaction>> MODEL_TO_TX = new HashMap();

    public <M, V extends AbstractEntity> MapKeycloakTransaction<V, M> createTransaction(KeycloakSession session, Class<M> modelType) {
        return MODEL_TO_TX.get(modelType).apply(session, this.config);
    }

    public MapStorageProvider create(KeycloakSession session) {
        return new LdapMapStorageProvider(this, this.sessionTxPrefixForFactoryInstance);
    }

    public void init(Config.Scope config) {
        this.config = config;
        LdapMapConfig cfg = new LdapMapConfig(config);
        LdapMapStorageProviderFactory.checkSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", cfg.getConnectionPoolingAuthentication(), "none simple");
        LdapMapStorageProviderFactory.checkSystemProperty("com.sun.jndi.ldap.connect.pool.initsize", cfg.getConnectionPoolingInitSize(), "1");
        LdapMapStorageProviderFactory.checkSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize", cfg.getConnectionPoolingMaxSize(), "1000");
        LdapMapStorageProviderFactory.checkSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize", cfg.getConnectionPoolingPrefSize(), "5");
        LdapMapStorageProviderFactory.checkSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", cfg.getConnectionPoolingTimeout(), "300000");
        LdapMapStorageProviderFactory.checkSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", cfg.getConnectionPoolingProtocol(), "plain ssl");
        LdapMapStorageProviderFactory.checkSystemProperty("com.sun.jndi.ldap.connect.pool.debug", cfg.getConnectionPoolingDebug(), "off");
    }

    private static void checkSystemProperty(String name, String cfgValue, String defaultValue) {
        String value = System.getProperty(name);
        if (cfgValue != null) {
            value = cfgValue;
        }
        if (value == null) {
            value = defaultValue;
        }
        System.setProperty(name, value);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "LDAP Map Storage";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void close() {
    }

    static {
        MODEL_TO_TX.put(RoleModel.class, LdapRoleMapKeycloakTransaction::new);
    }
}

