/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.config;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.map.storage.ldap.config.LdapMapConfig;

public abstract class LdapMapCommonGroupMapperConfig {
    public static final String MEMBERSHIP_LDAP_ATTRIBUTE = "membership.ldap.attribute";
    public static final String MEMBERSHIP_ATTRIBUTE_TYPE = "membership.attribute.type";
    public static final String MEMBERSHIP_USER_LDAP_ATTRIBUTE = "membership.user.ldap.attribute";
    public static final String MODE = "mode";
    public static final String USER_ROLES_RETRIEVE_STRATEGY = "user.roles.retrieve.strategy";
    public static final String MEMBEROF_LDAP_ATTRIBUTE = "memberof.ldap.attribute";
    protected final ComponentModel mapperModel;

    public LdapMapCommonGroupMapperConfig(ComponentModel mapperModel) {
        this.mapperModel = mapperModel;
    }

    public String getMembershipLdapAttribute() {
        String membershipAttrName = (String)this.mapperModel.getConfig().getFirst((Object)MEMBERSHIP_LDAP_ATTRIBUTE);
        return membershipAttrName != null ? membershipAttrName : "member";
    }

    public String getMembershipUserLdapAttribute(LdapMapConfig ldapMapConfig) {
        String membershipUserAttrName = (String)this.mapperModel.getConfig().getFirst((Object)MEMBERSHIP_USER_LDAP_ATTRIBUTE);
        return membershipUserAttrName != null ? membershipUserAttrName : ldapMapConfig.getUsernameLdapAttribute();
    }

    public String getMemberOfLdapAttribute() {
        String memberOfLdapAttrName = (String)this.mapperModel.getConfig().getFirst((Object)MEMBEROF_LDAP_ATTRIBUTE);
        return memberOfLdapAttrName != null ? memberOfLdapAttrName : "memberOf";
    }

    protected Set<String> getConfigValues(String str) {
        String[] objClasses = str.split(",");
        HashSet<String> trimmed = new HashSet<String>();
        for (String objectClass : objClasses) {
            if ((objectClass = objectClass.trim()).length() <= 0) continue;
            trimmed.add(objectClass);
        }
        return trimmed;
    }

    public abstract String getLDAPGroupNameLdapAttribute();
}

