/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap;

import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ldap.LdapMapStorageProviderFactory;

public class LdapMapStorageProvider
implements MapStorageProvider {
    private final LdapMapStorageProviderFactory factory;
    private final String sessionTxPrefix;

    public LdapMapStorageProvider(LdapMapStorageProviderFactory factory, String sessionTxPrefix) {
        this.factory = factory;
        this.sessionTxPrefix = sessionTxPrefix;
    }

    public void close() {
    }

    public <V extends AbstractEntity, M> MapStorage<V, M> getStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        return session -> {
            MapKeycloakTransaction sessionTx = (MapKeycloakTransaction)session.getAttribute(this.sessionTxPrefix + modelType.hashCode(), MapKeycloakTransaction.class);
            if (sessionTx == null) {
                sessionTx = this.factory.createTransaction(session, modelType);
                session.setAttribute(this.sessionTxPrefix + modelType.hashCode(), sessionTx);
            }
            return sessionTx;
        };
    }
}

