/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.event.admin;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.event.admin.entity.JpaAdminEventEntity;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.util.EnumWithStableIndex;

public class JpaAdminEventModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaAdminEventEntity, AdminEvent, JpaAdminEventModelCriteriaBuilder> {
    private static final Map<String, String> FIELD_TO_JSON_PROP = new HashMap<String, String>();

    public JpaAdminEventModelCriteriaBuilder() {
        super(JpaAdminEventModelCriteriaBuilder::new);
    }

    private JpaAdminEventModelCriteriaBuilder(JpaPredicateFunction<JpaAdminEventEntity> predicateFunc) {
        super(JpaAdminEventModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaAdminEventModelCriteriaBuilder compare(SearchableModelField<? super AdminEvent> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == AdminEvent.SearchableFields.REALM_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == AdminEvent.SearchableFields.AUTH_CLIENT_ID || modelField == AdminEvent.SearchableFields.AUTH_REALM_ID || modelField == AdminEvent.SearchableFields.AUTH_USER_ID || modelField == AdminEvent.SearchableFields.AUTH_IP_ADDRESS) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.equal(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)FIELD_TO_JSON_PROP.get(modelField.getName()))}), value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case LE: {
                if (modelField == AdminEvent.SearchableFields.TIMESTAMP) {
                    this.validateValue(value, modelField, op, Number.class);
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.le((Expression)root.get(modelField.getName()), (Number)value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case LT: {
                if (modelField == AdminEvent.SearchableFields.TIMESTAMP) {
                    this.validateValue(value, modelField, op, Number.class);
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.lt((Expression)root.get(modelField.getName()), (Number)value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case LIKE: {
                if (modelField == AdminEvent.SearchableFields.RESOURCE_PATH) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.like(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)FIELD_TO_JSON_PROP.get(modelField.getName()))}), value[0].toString()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case GE: {
                if (modelField == AdminEvent.SearchableFields.TIMESTAMP) {
                    this.validateValue(value, modelField, op, Number.class);
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.ge((Expression)root.get(modelField.getName()), (Number)value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == AdminEvent.SearchableFields.OPERATION_TYPE) {
                    Set values = super.getValuesForInOperator(value, modelField).stream().map(o -> ((EnumWithStableIndex)o).getStableIndex()).collect(Collectors.toSet());
                    if (values.isEmpty()) {
                        return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)FIELD_TO_JSON_PROP.get(modelField.getName()))}).as(Integer.class));
                        values.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                if (modelField == AdminEvent.SearchableFields.RESOURCE_TYPE) {
                    Set values = super.getValuesForInOperator(value, modelField).stream().map(Object::toString).collect(Collectors.toSet());
                    if (values.isEmpty()) {
                        return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaAdminEventModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)FIELD_TO_JSON_PROP.get(modelField.getName()))}));
                        values.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }

    static {
        FIELD_TO_JSON_PROP.put(AdminEvent.SearchableFields.AUTH_CLIENT_ID.getName(), "fAuthClientId");
        FIELD_TO_JSON_PROP.put(AdminEvent.SearchableFields.AUTH_REALM_ID.getName(), "fAuthRealmId");
        FIELD_TO_JSON_PROP.put(AdminEvent.SearchableFields.AUTH_USER_ID.getName(), "fAuthUserId");
        FIELD_TO_JSON_PROP.put(AdminEvent.SearchableFields.AUTH_IP_ADDRESS.getName(), "fAuthIpAddress");
        FIELD_TO_JSON_PROP.put(AdminEvent.SearchableFields.RESOURCE_PATH.getName(), "fResourcePath");
        FIELD_TO_JSON_PROP.put(AdminEvent.SearchableFields.RESOURCE_TYPE.getName(), "fResourceType");
        FIELD_TO_JSON_PROP.put(AdminEvent.SearchableFields.OPERATION_TYPE.getName(), "fOperationType");
    }
}

